/*
 * Decompiled with CFR 0.152.
 */
package minechem.fluid;

import minechem.fluid.MinechemFluidBlock;
import minechem.item.bucket.MinechemBucketHandler;
import minechem.item.bucket.MinechemBucketItem;
import minechem.radiation.RadiationEnum;
import minechem.radiation.RadiationFluidTileEntity;
import minechem.radiation.RadiationInfo;
import minechem.utils.MinechemUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class MinechemBucketReceiver
implements IBehaviorDispenseItem {
    public final IBehaviorDispenseItem source;

    public static void init() {
        IBehaviorDispenseItem source = (IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)Items.field_151133_ar);
        MinechemBucketReceiver receiver = new MinechemBucketReceiver(source);
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151133_ar, (Object)receiver);
    }

    public MinechemBucketReceiver(IBehaviorDispenseItem source) {
        this.source = source;
    }

    public ItemStack func_82482_a(IBlockSource blockSource, ItemStack itemstack) {
        int z;
        int y;
        int x;
        EnumFacing enumfacing = BlockDispenser.func_149937_b((int)blockSource.func_82620_h());
        World world = blockSource.func_82618_k();
        Block front = world.func_147439_a(x = blockSource.func_82623_d() + enumfacing.func_82601_c(), y = blockSource.func_82622_e() + enumfacing.func_96559_d(), z = blockSource.func_82621_f() + enumfacing.func_82599_e());
        if (front instanceof MinechemFluidBlock) {
            MinechemBucketItem item = MinechemBucketHandler.getInstance().buckets.get(front);
            ItemStack newstack = new ItemStack((Item)item);
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile != null && item.chemical.radioactivity() != RadiationEnum.stable) {
                RadiationInfo.setRadiationInfo(((RadiationFluidTileEntity)tile).info, newstack);
            }
            world.func_147480_a(x, y, z, true);
            --itemstack.field_77994_a;
            if (itemstack.field_77994_a <= 0) {
                return newstack;
            }
            TileEntity inventoryTile = blockSource.func_150835_j();
            if (inventoryTile instanceof IInventory) {
                ItemStack stack = MinechemUtil.addItemToInventory((IInventory)blockSource.func_150835_j(), newstack);
                if (stack != null) {
                    MinechemUtil.throwItemStack(world, stack, x, y, z);
                }
            } else {
                MinechemUtil.throwItemStack(world, newstack, x, y, z);
            }
            return itemstack;
        }
        return this.source.func_82482_a(blockSource, itemstack);
    }
}

