/*
 * Decompiled with CFR 0.152.
 */
package minechem.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.List;
import minechem.gui.GuiMinechemContainer;
import minechem.gui.GuiTab;
import minechem.gui.GuiTabPatreon;
import minechem.utils.MinechemUtil;
import minechem.utils.Rect;
import minechem.utils.SessionVars;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public abstract class GuiContainerTabbed
extends GuiMinechemContainer
implements INEIGuiHandler,
GuiYesNoCallback {
    private String clickedURI;
    protected static int SCALE_ENERGY = 42;
    protected static int SCALE_LIQUID = 60;
    protected static int SCALE_PROGRESS = 24;
    protected static int SCALE_SPEED = 16;
    protected ArrayList<GuiTab> tabListLeft = new ArrayList();
    protected ArrayList<GuiTab> tabListRight = new ArrayList();
    public int mouseX = 0;
    public int mouseY = 0;
    public static boolean drawBorders;
    private final int _zLevel = 3;

    public void drawTexture(int x, int y, ResourceLocation resource) {
        int w = 16;
        int h = 16;
        this.field_146297_k.func_110434_K().func_110577_a(resource);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + h), (double)this._zLevel, 0.0, 1.0);
        tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)this._zLevel, 1.0, 1.0);
        tessellator.func_78374_a((double)(x + w), (double)(y + 0), (double)this._zLevel, 1.0, 0.0);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this._zLevel, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public GuiContainerTabbed(Container container) {
        super(container);
    }

    protected void func_146979_b(int i, int j) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.drawTabs();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public void func_73863_a(int mX, int mY, float par3) {
        String tooltip;
        super.func_73863_a(mX, mY, par3);
        GuiTab guiTab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (guiTab != null && (tooltip = guiTab.getTooltip()) != null) {
            this.drawHoveringText(tooltip, mX, mY);
        }
    }

    protected void drawColoredSlot(int x, int y, SlotColor color, SlotType type, SlotRender render) {
        if (drawBorders) {
            this.drawColoredSlotWithBorder(x, y, color, type, render);
        } else {
            this.drawColoredSlotNoBorder(x, y, color, type, render);
        }
    }

    protected void drawColoredSlotNoBorder(int x, int y, SlotColor color, SlotType type, SlotRender render) {
        int sizeX = 0;
        int sizeY = 0;
        int offsetX = color.ordinal() / 3 * 128;
        int offsetY = color.ordinal() % 3 * 32;
        switch (type) {
            case SINGLE: {
                sizeX = 16;
                sizeY = 16;
                offsetX += 8;
                offsetY += 8;
                break;
            }
            case OUTPUT: {
                sizeX = 24;
                sizeY = 24;
                offsetX += 36;
                offsetY += 4;
                break;
            }
            case DOUBLEOUTPUT: {
                sizeX = 42;
                sizeY = 24;
                offsetX += 75;
                offsetY += 4;
            }
        }
        switch (render) {
            case TOP: {
                sizeY /= 2;
                break;
            }
            case BOTTOM: {
                y += (sizeY /= 2);
                offsetY += sizeY;
                break;
            }
        }
        this.func_73729_b(x, y, offsetX, offsetY, sizeX, sizeY);
    }

    protected void drawColoredSlotWithBorder(int x, int y, SlotColor color, SlotType type, SlotRender render) {
        int sizeX = 32;
        int sizeY = 32;
        int offsetX = color.ordinal() / 3 * 128;
        int offsetY = color.ordinal() % 3 * 32;
        offsetX += type.ordinal() * 32;
        if (type.ordinal() == 2) {
            sizeX = 64;
        }
        switch (type) {
            case SINGLE: {
                x -= 8;
                y -= 8;
                break;
            }
            case OUTPUT: {
                x -= 4;
                y -= 4;
                break;
            }
            case DOUBLEOUTPUT: {
                x -= 11;
                y -= 4;
            }
        }
        switch (render) {
            case TOP: {
                sizeY /= 2;
                break;
            }
            case BOTTOM: {
                y += (sizeY /= 2);
                offsetY += sizeY;
                break;
            }
        }
        this.func_73729_b(x, y, offsetX, offsetY, sizeX, sizeY);
    }

    protected void drawColoredLiquidSlot(int x, int y, SlotColor color) {
        if (drawBorders) {
            this.drawColoredLiquidSlotWithBorder(x, y, color);
        } else {
            this.drawColoredLiquidSlotNoBorder(x, y, color);
        }
    }

    protected void drawColoredLiquidSlotNoBorder(int x, int y, SlotColor color) {
        int sizeX = 16;
        int sizeY = 60;
        int offsetX = color.ordinal() * 32;
        int offsetY = 96;
        this.func_73729_b(x, y, offsetX + 8, offsetY + 2, sizeX, sizeY);
    }

    protected void drawColoredLiquidSlotWithBorder(int x, int y, SlotColor color) {
        int sizeX = 32;
        int sizeY = 64;
        int offsetX = color.ordinal() * 32;
        int offsetY = 96;
        this.func_73729_b(x - 8, y - 2, offsetX, offsetY, sizeX, sizeY);
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_146999_f);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        FontRenderer fontRenderer = RenderManager.field_78727_a.func_78716_a();
        return (xWidth - fontRenderer.func_78256_a(string)) / 2;
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        super.func_73864_a(x, y, mouseButton);
        GuiTab guiTab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (guiTab != null) {
            GuiTabPatreon patreonTab;
            if (guiTab.leftSide) {
                for (GuiTab other : this.tabListLeft) {
                    if (other == guiTab || !other.isOpen()) continue;
                    other.toggleOpen();
                }
            } else {
                for (GuiTab other : this.tabListRight) {
                    if (other == guiTab || !other.isOpen()) continue;
                    other.toggleOpen();
                }
            }
            if (guiTab instanceof GuiTabPatreon && (patreonTab = (GuiTabPatreon)guiTab).isFullyOpened() && patreonTab.isLinkAtOffsetPosition(x - this.field_147003_i, y - this.field_147009_r)) {
                this.clickedURI = patreonTab.link;
                if (this.field_146297_k.field_71474_y.field_74358_q) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, this.clickedURI, 0, false));
                } else {
                    MinechemUtil.openURL(patreonTab.link);
                }
                return;
            }
            guiTab.toggleOpen();
        }
    }

    public void func_73878_a(boolean confirm, int id) {
        if (id == 0) {
            if (confirm) {
                MinechemUtil.openURL(this.clickedURI);
            }
            this.clickedURI = null;
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.mouseX = i - (this.field_146294_l - this.field_146999_f) / 2;
        this.mouseY = j - (this.field_146295_m - this.field_147000_g) / 2;
    }

    public void addTab(GuiTab guiTab) {
        if (guiTab.leftSide) {
            this.tabListLeft.add(guiTab);
        } else {
            this.tabListRight.add(guiTab);
        }
        if (SessionVars.getOpenedTab() != null && guiTab.getClass().equals(SessionVars.getOpenedTab())) {
            guiTab.setFullyOpen();
        }
    }

    protected void drawTabs() {
        int yPos = 4;
        for (GuiTab guiTab : this.tabListLeft) {
            guiTab.update();
            if (!guiTab.isVisible()) continue;
            guiTab.drawTab(0, yPos);
            yPos += guiTab.getHeight();
        }
        yPos = 4;
        for (GuiTab guiTab : this.tabListRight) {
            guiTab.update();
            if (!guiTab.isVisible()) continue;
            guiTab.drawTab(this.field_146999_f, yPos);
            yPos += guiTab.getHeight();
        }
    }

    protected GuiTab getTabAtPosition(int mX, int mY) {
        int xShift = 0;
        int yShift = 4;
        for (GuiTab guiTab : this.tabListLeft) {
            if (!guiTab.isVisible()) continue;
            guiTab.currentX = xShift;
            guiTab.currentY = yShift;
            if (guiTab.intersectsWith(mX, mY, xShift, yShift)) {
                return guiTab;
            }
            yShift += guiTab.getHeight();
        }
        xShift = this.field_146999_f;
        yShift = 4;
        for (GuiTab guiTab : this.tabListRight) {
            if (!guiTab.isVisible()) continue;
            guiTab.currentX = xShift;
            guiTab.currentY = yShift;
            if (guiTab.intersectsWith(mX, mY, xShift, yShift)) {
                return guiTab;
            }
            yShift += guiTab.getHeight();
        }
        return null;
    }

    public int getMouseX() {
        return Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c;
    }

    public int getMouseY() {
        return this.field_146295_m - (Mouse.getY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1);
    }

    @Optional.Method(modid="NotEnoughItems")
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return currentVisibility;
    }

    @Optional.Method(modid="NotEnoughItems")
    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        if (gui instanceof GuiContainerTabbed) {
            Rect item = new Rect(x, y, w, h);
            GuiContainerTabbed container = (GuiContainerTabbed)gui;
            for (GuiTab tab : this.tabListRight) {
                Rect tabRect = new Rect(tab.currentX + container.field_147003_i, tab.currentY + container.field_147009_r, tab.currentWidth, tab.currentHeight);
                if (!item.intersectsWith(tabRect)) continue;
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="NotEnoughItems")
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    protected static enum SlotRender {
        TOP,
        BOTTOM,
        FULL;

    }

    protected static enum SlotType {
        SINGLE,
        OUTPUT,
        DOUBLEOUTPUT;

    }

    protected static enum SlotColor {
        BLUE,
        RED,
        YELLOW,
        ORANGE,
        GREEN,
        PURPLE;

    }
}

