/*
 * Decompiled with CFR 0.152.
 */
package minechem.gui;

import java.util.ArrayList;
import java.util.List;
import minechem.reference.Resources;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiFluidTank
extends Gui {
    private int capacity;
    private int posX;
    private int posY;

    public GuiFluidTank(int capacity, int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
        this.capacity = capacity;
    }

    public void draw(int x, int y, FluidStack fluidStack) {
        GL11.glDisable((int)2896);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.Gui.TANK);
        this.func_73729_b(x + this.posX, y + this.posY, 0, 0, 18, 39);
        int iconHeightRemainder = 3;
        if (fluidStack != null && fluidStack.amount > 0) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            IIcon fluidIcon = fluidStack.getFluid().getStillIcon();
            this.func_94065_a(x + this.posX + 1, y + this.posY + 2, fluidIcon, 16, iconHeightRemainder);
            for (int i = 0; i < 2; ++i) {
                this.func_94065_a(x + this.posX + 1, y + this.posY + 2 + i * 16 + iconHeightRemainder, fluidIcon, 16, 16);
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.Gui.TANK);
            this.func_73729_b(x + this.posX + 2, y + this.posY + 1, 1, 1, 15, 37 - (int)(38.0f * ((float)fluidStack.amount / (float)this.capacity)));
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.Gui.TANK);
        this.func_73729_b(x + this.posX + 1, y + this.posY + 1, 19, 1, 16, 37);
        GL11.glEnable((int)2896);
    }

    public void drawTooltip(int x, int y, FluidStack fluidStack) {
        if (!this.mouseInTank(x, y)) {
            return;
        }
        ArrayList<String> description = new ArrayList<String>();
        if (fluidStack == null || fluidStack.getFluid() == null) {
            description.add("Empty");
        } else if (fluidStack.amount > 0 && fluidStack.getFluid() != null) {
            String amountToText = fluidStack.amount + "mB";
            description.add(fluidStack.getLocalizedName());
            description.add(amountToText);
        }
        this.drawHoveringText(description, x, y, Minecraft.func_71410_x().field_71466_p);
    }

    private boolean mouseInTank(int x, int y) {
        return x >= this.posX && x < this.posX + 16 && y >= this.posY && y < this.posY + 37;
    }

    protected void drawHoveringText(List list, int x, int y, FontRenderer fontrenderer) {
        if (!list.isEmpty()) {
            GL11.glDisable((int)32826);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : list) {
                int l = fontrenderer.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = x + 12;
            int j1 = y - 12;
            int k1 = 8;
            if (list.size() > 1) {
                k1 += 2 + (list.size() - 1) * 10;
            }
            this.field_73735_i = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < list.size(); ++k2) {
                String s1 = (String)list.get(k2);
                fontrenderer.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
        }
    }
}

