/*
 * Decompiled with CFR 0.152.
 */
package minechem.gui;

import cpw.mods.fml.client.FMLClientHandler;
import minechem.gui.GuiContainerTabbed;
import minechem.reference.Resources;
import minechem.utils.LogHelper;
import minechem.utils.SessionVars;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class GuiTab {
    public FontRenderer tabFontRenderer;
    public SoundHandler tabSoundManager;
    private boolean open;
    protected Gui myGui;
    public boolean leftSide;
    protected int overlayColor;
    public int currentX;
    public int currentY;
    protected int limitWidth;
    protected int maxWidth;
    protected int minWidth;
    protected int currentWidth;
    protected int maxHeight;
    protected int minHeight;
    protected int currentHeight;
    protected FontRenderer fontRenderer;
    protected TextureManager renderEngine;

    public GuiTab(Gui gui) {
        this.tabFontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
        this.tabSoundManager = FMLClientHandler.instance().getClient().func_147118_V();
        this.overlayColor = 0xFFFFFF;
        this.currentX = 0;
        this.currentY = 0;
        this.limitWidth = 128;
        this.maxWidth = 124;
        this.currentWidth = this.minWidth = 22;
        this.maxHeight = 22;
        this.currentHeight = this.minHeight = 22;
        this.myGui = gui;
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.renderEngine = Minecraft.func_71410_x().field_71446_o;
    }

    public abstract void draw(int var1, int var2);

    public void drawTab(int x, int y) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        this.currentX = x;
        this.currentY = y;
        this.draw(x, y);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2896);
    }

    protected void drawBackground(int x, int y) {
        float colorR = (float)(this.overlayColor >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(this.overlayColor >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(this.overlayColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        if (this.leftSide) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.Tab.LEFT);
            this.myGui.func_73729_b(x - this.currentWidth, y + 4, 0, 256 - this.currentHeight + 4, 4, this.currentHeight - 4);
            this.myGui.func_73729_b(x - this.currentWidth + 4, y, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            this.myGui.func_73729_b(x - this.currentWidth, y, 0, 0, 4, 4);
            this.myGui.func_73729_b(x - this.currentWidth + 4, y + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.Tab.RIGHT);
            this.myGui.func_73729_b(x, y, 0, 256 - this.currentHeight, 4, this.currentHeight);
            this.myGui.func_73729_b(x + 4, y, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            this.myGui.func_73729_b(x, y, 0, 0, 4, 4);
            this.myGui.func_73729_b(x + 4, y + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawIcon(int x, int y) {
        ResourceLocation resource = this.getIcon();
        if (this.myGui instanceof GuiContainerTabbed) {
            ((GuiContainerTabbed)this.myGui).drawTexture(x, y, resource);
        } else {
            LogHelper.debug("Failed to draw tab icons on a Minechem gui that was not GuiContainerTabbed.");
        }
    }

    public int getHeight() {
        return this.currentHeight;
    }

    public int getWidth() {
        return this.currentWidth;
    }

    public abstract ResourceLocation getIcon();

    public abstract String getTooltip();

    public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
        return this.leftSide ? mouseX <= shiftX && mouseX >= shiftX - this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.currentHeight : mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.currentHeight;
    }

    protected boolean isFullyOpened() {
        return this.currentWidth >= this.maxWidth;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isVisible() {
        return true;
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = this.maxWidth;
        this.currentHeight = this.maxHeight;
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            SessionVars.setOpenedTab(null);
        } else {
            this.open = true;
            SessionVars.setOpenedTab(this.getClass());
        }
    }

    public void update() {
        if (this.open && this.currentWidth < this.maxWidth) {
            this.currentWidth += 8;
        } else if (!this.open && this.currentWidth > this.minWidth) {
            this.currentWidth -= 8;
        }
        if (this.currentWidth > this.maxWidth) {
            this.currentWidth = this.maxWidth;
        } else if (this.currentWidth < this.minWidth) {
            this.currentWidth = this.minWidth;
        }
        if (this.open && this.currentHeight < this.maxHeight) {
            this.currentHeight += 8;
        } else if (!this.open && this.currentHeight > this.minHeight) {
            this.currentHeight -= 8;
        }
        if (this.currentHeight > this.maxHeight) {
            this.currentHeight = this.maxHeight;
        } else if (this.currentHeight < this.minHeight) {
            this.currentHeight = this.minHeight;
        }
    }
}

