/*
 * Decompiled with CFR 0.152.
 */
package minechem.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import minechem.gui.GuiTab;
import minechem.reference.Resources;
import minechem.tileentity.prefab.MinechemTileEntityElectric;
import minechem.utils.MinechemUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public abstract class GuiTabStateControl
extends GuiTab {
    int headerColour = 14797103;
    int subheaderColour = 11186104;
    int textColour = 0;
    protected TabState state = TabState.unpowered;
    protected MinechemTileEntityElectric tileEntity;

    public GuiTabStateControl(Gui gui) {
        super(gui);
        this.minWidth = 25;
        this.minHeight = 26;
        this.maxHeight = this.minHeight + 75;
        this.maxWidth = this.minWidth + 80;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        this.drawIcon(x + 3, y + 5);
        if (!this.isFullyOpened()) {
            return;
        }
        this.fontRenderer.func_78261_a(MinechemUtil.getLocalString(this.state.tooltip), x + 22, y + 10, this.headerColour);
        this.fontRenderer.func_78261_a(MinechemUtil.getLocalString("tab.title.stored") + ":", x + 5, y + 30, this.subheaderColour);
        String print = String.valueOf(this.tileEntity.getEnergyStored()) + " RF (" + String.valueOf(this.tileEntity.getPowerRemainingScaled(100.0)) + "%)";
        this.fontRenderer.func_78276_b(print, x + 5, y + 40, this.textColour);
        this.fontRenderer.func_78261_a(MinechemUtil.getLocalString("tab.title.activationEnergy"), x + 5, y + 60, this.subheaderColour);
        this.fontRenderer.func_78276_b(String.valueOf(this.tileEntity.getEnergyNeeded()) + " RF", x + 5, y + 70, this.textColour);
    }

    @Override
    public String getTooltip() {
        if (!this.isFullyOpened()) {
            return this.state.tooltip;
        }
        return null;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.state.resource;
    }

    protected static enum TabState {
        jammed(MinechemUtil.getLocalString("tab.tooltip.jammed"), 0xAA0000, Resources.Icon.JAMMED),
        noBottles(MinechemUtil.getLocalString("tab.tooltip.nobottles"), 0xAA0000, Resources.Icon.NO_BOTTLES),
        powered(MinechemUtil.getLocalString("tab.tooltip.powered"), 52224, Resources.Icon.ENERGY),
        unpowered(MinechemUtil.getLocalString("tab.tooltip.unpowered"), 0xAA0000, Resources.Icon.NO_ENERGY),
        norecipe(MinechemUtil.getLocalString("tab.tooltip.norecipe"), 0xAA0000, Resources.Icon.NO_RECIPE);

        public String tooltip;
        public int color;
        @SideOnly(value=Side.CLIENT)
        public IIcon icon;
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation resource;

        private TabState(String tooltip, int color, ResourceLocation resource) {
            this.tooltip = tooltip;
            this.color = color;
            this.resource = resource;
        }
    }
}

