/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.bucket;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import minechem.Minechem;
import minechem.fluid.MinechemBucketDispenser;
import minechem.fluid.MinechemFluid;
import minechem.fluid.MinechemFluidBlock;
import minechem.item.MinechemChemicalType;
import minechem.item.bucket.MinechemBucketItem;
import minechem.item.bucket.MinechemBucketRecipe;
import minechem.item.bucket.MinechemBucketReverseRecipe;
import minechem.item.element.Element;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.potion.PotionChemical;
import minechem.radiation.RadiationEnum;
import minechem.radiation.RadiationFluidTileEntity;
import minechem.radiation.RadiationInfo;
import minechem.tileentity.decomposer.DecomposerRecipe;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class MinechemBucketHandler {
    private static MinechemBucketHandler instance;
    public Map<MinechemFluidBlock, MinechemBucketItem> buckets = new HashMap<MinechemFluidBlock, MinechemBucketItem>();

    public static MinechemBucketHandler getInstance() {
        if (instance == null) {
            instance = new MinechemBucketHandler();
        }
        return instance;
    }

    private MinechemBucketHandler() {
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        ItemStack result = this.fillCustomBucket(event.world, event.target);
        if (result == null) {
            return;
        }
        event.result = result;
        event.setResult(Event.Result.ALLOW);
    }

    private ItemStack fillCustomBucket(World world, MovingObjectPosition pos) {
        Block block = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        Item bucket = (Item)this.buckets.get(block);
        if (bucket != null && world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) == 0) {
            ItemStack stack = new ItemStack(bucket);
            TileEntity tile = world.func_147438_o(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            RadiationEnum radiation = ((MinechemBucketItem)bucket).chemical.radioactivity();
            if (tile != null && radiation != RadiationEnum.stable && tile instanceof RadiationFluidTileEntity && ((RadiationFluidTileEntity)tile).info != null) {
                RadiationInfo.setRadiationInfo(((RadiationFluidTileEntity)tile).info, stack);
            }
            world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            return stack;
        }
        return null;
    }

    public MinechemBucketItem getBucket(MinechemChemicalType type) {
        if (type != null) {
            for (MinechemFluidBlock block : this.buckets.keySet()) {
                MinechemChemicalType blockType;
                if (!(block.getFluid() instanceof MinechemFluid) || type != (blockType = ((MinechemFluid)block.getFluid()).getChemical())) continue;
                return this.buckets.get((Object)block);
            }
        }
        return null;
    }

    public void registerCustomMinechemBucket(MinechemFluidBlock block, MinechemChemicalType type, String prefix) {
        if (this.buckets.get((Object)block) != null) {
            return;
        }
        MinechemBucketItem bucket = new MinechemBucketItem((Block)block, block.getFluid(), type);
        GameRegistry.registerItem((Item)bucket, (String)("minechemBucket." + prefix + block.getFluid().getName()));
        FluidContainerRegistry.registerFluidContainer((Fluid)block.getFluid(), (ItemStack)new ItemStack((Item)bucket), (ItemStack)new ItemStack(Items.field_151133_ar));
        this.buckets.put(block, bucket);
        Minechem.PROXY.onAddBucket(bucket);
        BlockDispenser.field_149943_a.func_82595_a((Object)bucket, (Object)MinechemBucketDispenser.dispenser);
    }

    public void registerBucketRecipes() {
        GameRegistry.addRecipe((IRecipe)new MinechemBucketRecipe());
        GameRegistry.addRecipe((IRecipe)new MinechemBucketReverseRecipe());
        for (MinechemBucketItem bucket : this.buckets.values()) {
            this.registerBucketDecomposerRecipe(new ItemStack((Item)bucket), bucket.chemical);
        }
    }

    private void registerBucketDecomposerRecipe(ItemStack itemStack, MinechemChemicalType type) {
        ArrayList<PotionChemical> tubes = new ArrayList<PotionChemical>();
        tubes.add(new Element(ElementEnum.Fe, 48));
        if (type instanceof ElementEnum) {
            tubes.add(new Element((ElementEnum)type, 8));
        } else if (type instanceof MoleculeEnum) {
            tubes.add(new Molecule((MoleculeEnum)type, 8));
        }
        DecomposerRecipe.add(new DecomposerRecipe(itemStack, tubes));
    }
}

