/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.bucket;

import minechem.MinechemItemsRegistration;
import minechem.item.MinechemChemicalType;
import minechem.item.bucket.MinechemBucketHandler;
import minechem.item.element.ElementItem;
import minechem.item.molecule.MoleculeItem;
import minechem.radiation.RadiationEnum;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MinechemBucketRecipe
implements IRecipe {
    private MinechemChemicalType type;

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        int chemicals = 0;
        boolean hasBucket = false;
        this.type = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            MinechemChemicalType anotherType;
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null) continue;
            if (stack.func_77973_b() == Items.field_151133_ar) {
                if (hasBucket) {
                    return false;
                }
                hasBucket = true;
                continue;
            }
            if (stack.func_77973_b() == MinechemItemsRegistration.element) {
                anotherType = ElementItem.getElement(stack);
            } else if (stack.func_77973_b() == MinechemItemsRegistration.molecule) {
                anotherType = MoleculeItem.getMolecule(stack);
            } else {
                return false;
            }
            if (this.type == null) {
                this.type = anotherType;
            }
            if (anotherType == this.type) {
                ++chemicals;
                continue;
            }
            return false;
        }
        return hasBucket && chemicals == 8;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        if (this.type.radioactivity() == RadiationEnum.stable) {
            return this.func_77571_b();
        }
        long time = Long.MAX_VALUE;
        boolean hasCompared = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            long anotherTime;
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != MinechemItemsRegistration.element && stack.func_77973_b() != MinechemItemsRegistration.molecule || stack.field_77990_d == null || (anotherTime = stack.field_77990_d.func_74763_f("decayStart")) >= time) continue;
            time = anotherTime;
            hasCompared = true;
        }
        ItemStack result = this.func_77571_b();
        if (!hasCompared) {
            return result;
        }
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_74772_a("decayStart", time);
        comp.func_74772_a("lastUpdate", time);
        comp.func_74768_a("dimensionID", 0);
        result.field_77990_d = comp;
        return result;
    }

    public int func_77570_a() {
        return 3;
    }

    public ItemStack func_77571_b() {
        if (this.type != null && this.type.getUnlocalizedName().equals("molecule.water")) {
            return new ItemStack(Items.field_151131_as);
        }
        if (this.type != null) {
            return new ItemStack((Item)MinechemBucketHandler.getInstance().getBucket(this.type), 1);
        }
        return null;
    }
}

