/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.chemistjournal;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import minechem.MinechemItemsRegistration;
import minechem.gui.GuiContainerTabbed;
import minechem.gui.GuiFakeSlot;
import minechem.gui.GuiTextField;
import minechem.gui.GuiVerticalScrollBar;
import minechem.gui.IVerticalScrollContainer;
import minechem.gui.ScissorHelper;
import minechem.item.chemistjournal.ChemistJournalContainer;
import minechem.network.MessageHandler;
import minechem.network.message.ChemistJournalActiveItemMessage;
import minechem.potion.PotionChemical;
import minechem.reference.Resources;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.tileentity.decomposer.DecomposerRecipeChance;
import minechem.tileentity.decomposer.DecomposerRecipeHandler;
import minechem.tileentity.decomposer.DecomposerRecipeSelect;
import minechem.tileentity.synthesis.SynthesisRecipe;
import minechem.tileentity.synthesis.SynthesisRecipeHandler;
import minechem.utils.MinechemUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ChemistJournalGui
extends GuiContainerTabbed
implements IVerticalScrollContainer {
    private static final int SYNTHESIS_X = 197;
    private static final int SYNTHESIS_Y = 121;
    private static final int DECOMPOSER_X = 197;
    private static final int DECOMPOSER_Y = 41;
    private static final int GUI_WIDTH = 302;
    private static final int GUI_HEIGHT = 191;
    GuiVerticalScrollBar scrollBar;
    GuiTextField searchBar;
    List<GuiFakeSlot> itemListSlots = new ArrayList<GuiFakeSlot>();
    int listHeight;
    GuiFakeSlot[] synthesisSlots = new GuiFakeSlot[9];
    GuiFakeSlot[] decomposerSlots = new GuiFakeSlot[9];
    EntityPlayer player;
    private int slideShowTimer = 0;
    private int currentSlide = 0;
    public ItemStack currentItemStack;
    SynthesisRecipe currentSynthesisRecipe;
    DecomposerRecipe currentDecomposerRecipe;
    ItemStack journalStack;
    List<ItemStack> itemList;

    public ChemistJournalGui(EntityPlayer entityPlayer) {
        super(new ChemistJournalContainer(entityPlayer.field_71071_by));
        this.player = entityPlayer;
        this.journalStack = entityPlayer.field_71071_by.func_70448_g();
        this.currentItemStack = MinechemItemsRegistration.journal.getActiveStack(this.journalStack);
        if (this.currentItemStack != null) {
            this.showRecipesForStack(this.currentItemStack);
        }
        this.field_146999_f = 302;
        this.field_147000_g = 191;
        this.scrollBar = new GuiVerticalScrollBar(this, 128, 14, 157, this.field_146999_f, this.field_147000_g);
        this.searchBar = new GuiTextField(100, 12, 20, 14);
        this.itemList = MinechemItemsRegistration.journal.getItemList(this.journalStack);
        this.populateItemList();
    }

    public void populateItemList() {
        int i = 0;
        int j = 0;
        this.itemListSlots.clear();
        if (this.itemList != null) {
            for (ItemStack itemstack : this.itemList) {
                if (!this.searchBar.getText().equals("") && itemstack != null && !itemstack.func_82833_r().toLowerCase().contains(this.searchBar.getText())) continue;
                int xPos = i * 18 + 18;
                int yPos = j * 18 + 28;
                GuiFakeSlot slot = new GuiFakeSlot(this, this.player);
                slot.setXPos(xPos);
                slot.setYPos(yPos);
                slot.setItemStack(itemstack);
                this.itemListSlots.add(slot);
                if (++i != 6) continue;
                i = 0;
                ++j;
            }
        }
        this.listHeight = j * 18;
        if (this.itemListSlots.size() == 1) {
            this.showRecipesForStack(this.itemListSlots.get(0).getItemStack());
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int mouseButton) {
        super.func_73864_a(x, y, mouseButton);
        GuiFakeSlot clickedSlot = null;
        for (GuiFakeSlot slot : this.itemListSlots) {
            if (!slot.getMouseIsOver()) continue;
            clickedSlot = slot;
            break;
        }
        if (clickedSlot != null) {
            this.onSlotClick(clickedSlot);
        }
    }

    protected void func_73869_a(char character, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.searchBar.keyTyped(character, keyCode);
        this.populateItemList();
    }

    public void onSlotClick(GuiFakeSlot slot) {
        ItemStack itemstack = slot.getItemStack();
        this.showRecipesForStack(itemstack);
    }

    public void showRecipesForStack(ItemStack itemstack) {
        this.currentItemStack = itemstack;
        MinechemItemsRegistration.journal.setActiveStack(itemstack, this.journalStack);
        ChemistJournalActiveItemMessage message = new ChemistJournalActiveItemMessage(itemstack, this.player);
        MessageHandler.INSTANCE.sendToServer((IMessage)message);
        SynthesisRecipe synthesisRecipe = SynthesisRecipeHandler.instance.getRecipeFromOutput(itemstack);
        DecomposerRecipe decomposerRecipe = DecomposerRecipeHandler.instance.getRecipe(itemstack);
        this.synthesisSlots = new GuiFakeSlot[9];
        this.decomposerSlots = new GuiFakeSlot[9];
        this.currentSynthesisRecipe = null;
        this.currentDecomposerRecipe = null;
        if (synthesisRecipe != null) {
            this.showSynthesisRecipe(synthesisRecipe);
            this.currentSynthesisRecipe = synthesisRecipe;
        }
        if (decomposerRecipe != null) {
            this.showDecomposerRecipe(decomposerRecipe);
            this.currentDecomposerRecipe = decomposerRecipe;
        }
    }

    public void showSynthesisRecipe(SynthesisRecipe recipe) {
        ItemStack[] ingredients = MinechemUtil.convertChemicalArrayIntoItemStackArray(recipe.isShaped() ? recipe.getShapedRecipe() : recipe.getShapelessRecipe());
        this.showIngredients(ingredients, this.synthesisSlots, 197, 121);
    }

    public void showDecomposerRecipe(DecomposerRecipe recipe) {
        if (recipe instanceof DecomposerRecipeSelect) {
            this.slideShowTimer = 0;
            this.currentSlide = 0;
            return;
        }
        ArrayList<ItemStack> ingredients = MinechemUtil.convertChemicalsIntoItemStacks(recipe.getOutputRaw());
        ItemStack[] ingredientArray = ingredients.toArray(new ItemStack[9]);
        this.showIngredients(ingredientArray, this.decomposerSlots, 197, 41);
    }

    private void showDecomposerRecipeSelect(DecomposerRecipeSelect recipe) {
        ArrayList<DecomposerRecipe> recipes = recipe.getAllPossibleRecipes();
        if (this.slideShowTimer >= 160) {
            this.slideShowTimer = 0;
            ++this.currentSlide;
            if (this.currentSlide >= recipes.size()) {
                this.currentSlide = 0;
            }
        }
        if (this.slideShowTimer == 0) {
            ArrayList<PotionChemical> potionChemicals = ((DecomposerRecipe)recipes.get(this.currentSlide)).getOutputRaw();
            ArrayList<ItemStack> ingredients = MinechemUtil.convertChemicalsIntoItemStacks(potionChemicals);
            ItemStack[] ingredientArray = ingredients.toArray(new ItemStack[9]);
            this.showIngredients(ingredientArray, this.decomposerSlots, 197, 41);
        }
        ++this.slideShowTimer;
    }

    private void showIngredients(ItemStack[] ingredients, GuiFakeSlot[] slotArray, int xOffset, int yOffset) {
        int pos = 0;
        int i = 0;
        int j = 0;
        for (ItemStack ingredient : ingredients) {
            if (pos >= 9) break;
            slotArray[pos] = null;
            if (ingredient != null) {
                int x = i * 18 + xOffset;
                int y = j * 18 + yOffset;
                GuiFakeSlot fakeSlot = new GuiFakeSlot(this, this.player);
                fakeSlot.setItemStack(ingredient);
                fakeSlot.setXPos(x);
                fakeSlot.setYPos(y);
                slotArray[pos] = fakeSlot;
            }
            ++pos;
            if (++i != 3) continue;
            i = 0;
            ++j;
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        this.field_146297_k.field_71446_o.func_110577_a(Resources.Gui.JOURNAL);
        this.func_73729_b(0, 0, 0, 0, this.field_146999_f / 2, this.field_147000_g / 2);
        GL11.glPopMatrix();
        if (this.currentItemStack != null) {
            this.drawRecipeGrid();
            this.drawRecipeGrid();
            this.drawText();
            this.drawRecipeSlots(x, y);
        } else {
            this.drawHelp();
        }
        this.scrollBar.draw();
        this.searchBar.draw();
        this.drawSlots(x, y);
        this.drawSlotTooltips();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        this.field_146297_k.field_71446_o.func_110577_a(Resources.Gui.JOURNAL);
        this.func_73729_b(4, 82, 80, 96, 10, 10);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        if (this.currentDecomposerRecipe instanceof DecomposerRecipeSelect) {
            this.showDecomposerRecipeSelect((DecomposerRecipeSelect)this.currentDecomposerRecipe);
        }
    }

    private void drawRecipeGrid() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(Resources.Gui.JOURNAL);
        this.func_73729_b(98, 20, 25, 96, 27, 27);
        if (this.currentSynthesisRecipe != null && this.currentSynthesisRecipe.isShaped()) {
            this.func_73729_b(98, 60, 52, 96, 27, 27);
        } else {
            this.func_73729_b(98, 60, 25, 96, 27, 27);
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
    }

    private void drawText() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        String itemname = String.format("%sl%s", "\u00a7", this.currentItemStack.func_82833_r());
        if (itemname.length() > 18) {
            itemname = itemname.substring(0, 18).trim() + "...";
        }
        this.field_146289_q.func_78276_b(itemname, 175, 10, 255);
        this.field_146289_q.func_78276_b(MinechemUtil.getLocalString("gui.journal.decomposer"), 175, 20, 0x884400);
        float chance = 100.0f;
        if (this.currentDecomposerRecipe != null && this.currentDecomposerRecipe instanceof DecomposerRecipeChance) {
            chance = this.currentDecomposerRecipe.getChance();
            chance *= 100.0f;
        }
        if (this.currentDecomposerRecipe != null) {
            this.field_146289_q.func_78276_b(String.format("%.1f%% chance", Float.valueOf(chance)), 175, 30, 0x555555);
        }
        this.field_146289_q.func_78276_b(MinechemUtil.getLocalString("gui.journal.synthesis"), 175, 100, 0x884400);
        if (this.currentSynthesisRecipe != null) {
            int energyCost = this.currentSynthesisRecipe.energyCost();
            this.field_146289_q.func_78276_b(String.format("%d Energy", energyCost), 175, 110, 0x555555);
        }
    }

    private void drawHelp() {
        this.field_146289_q.func_78276_b(MinechemUtil.getLocalString("item.itemChemistJournal.name"), 180, 18, -16777216);
        String help = MinechemUtil.getLocalString("help.journal");
        GL11.glPushMatrix();
        float scale = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        this.field_146289_q.func_78279_b(help, 345, 70, 200, -1442840576);
        GL11.glPopMatrix();
    }

    private void drawSlots(int x, int y) {
        GL11.glPushMatrix();
        ScissorHelper.startScissor(this.field_146297_k, x + 9, y + 26, 140, 176);
        int ypos = (int)((float)(this.listHeight - 150) * this.scrollBar.getScrollValue());
        GL11.glTranslatef((float)0.0f, (float)ypos, (float)0.0f);
        for (GuiFakeSlot slot : this.itemListSlots) {
            slot.setYOffset(ypos);
            slot.draw();
        }
        ScissorHelper.endScissor();
        GL11.glPopMatrix();
    }

    private void drawSlotTooltips() {
        for (GuiFakeSlot slot : this.itemListSlots) {
            slot.drawTooltip(this.mouseX + 10, this.mouseY);
        }
    }

    private void drawRecipeSlots(int x, int y) {
        for (GuiFakeSlot slot : this.synthesisSlots) {
            if (slot == null) continue;
            slot.draw();
        }
        for (GuiFakeSlot slot : this.decomposerSlots) {
            if (slot == null) continue;
            slot.draw();
        }
        for (GuiFakeSlot slot : this.synthesisSlots) {
            if (slot == null) continue;
            slot.drawTooltip(this.mouseX + 10, this.mouseY);
        }
        for (GuiFakeSlot slot : this.decomposerSlots) {
            if (slot == null) continue;
            slot.drawTooltip(this.mouseX + 10, this.mouseY);
        }
    }

    @Override
    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.mouseX = i - (this.field_146294_l - this.field_146999_f) / 2;
        this.mouseY = j - (this.field_146295_m - this.field_147000_g) / 2;
        if (this.isScrollBarActive()) {
            this.scrollBar.handleMouseInput();
        }
    }

    @Override
    public boolean isScrollBarActive() {
        return true;
    }

    @Override
    public int getScreenWidth() {
        return this.field_146294_l;
    }

    @Override
    public int getScreenHeight() {
        return this.field_146295_m;
    }

    @Override
    public int getGuiWidth() {
        return this.field_146999_f;
    }

    @Override
    public int getGuiHeight() {
        return this.field_147000_g;
    }

    @Override
    public int getScrollAmount() {
        return 5;
    }
}

