/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.polytool;

import java.util.ArrayList;
import minechem.item.element.ElementEnum;
import minechem.item.polytool.PolytoolItem;
import minechem.item.polytool.PolytoolUpgradeType;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class PolytoolInventoryRender
implements IItemRenderer {
    private static RenderItem renderItem = new RenderItem();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public float getRed(ElementEnum element) {
        switch (element.classification()) {
            case actinide: 
            case halogen: 
            case lanthanide: 
            case nonmetal: {
                return 1.0f;
            }
            case otherMetal: {
                return 0.5f;
            }
        }
        return 0.0f;
    }

    public float getGreen(ElementEnum element) {
        switch (element.classification()) {
            case halogen: 
            case otherMetal: 
            case alkaliMetal: 
            case inertGas: 
            case semimetallic: {
                return 1.0f;
            }
            case nonmetal: 
            case transitionMetal: {
                return 0.5f;
            }
        }
        return 0.0f;
    }

    public float getBlue(ElementEnum element) {
        switch (element.classification()) {
            case lanthanide: 
            case inertGas: 
            case transitionMetal: 
            case alkalineEarthMetal: {
                return 1.0f;
            }
            case semimetallic: {
                return 0.5f;
            }
        }
        return 0.0f;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        int j;
        int i;
        GL11.glPushMatrix();
        ArrayList upgrades = PolytoolItem.getUpgrades(item);
        int count = 1;
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        for (i = 0; i < upgrades.size(); ++i) {
            j = 0;
            while ((float)j < ((PolytoolUpgradeType)upgrades.get((int)i)).power) {
                ++count;
                ++j;
            }
        }
        for (i = 0; i < upgrades.size(); ++i) {
            j = 0;
            while ((float)j < ((PolytoolUpgradeType)upgrades.get((int)i)).power) {
                ElementEnum element = ((PolytoolUpgradeType)upgrades.get(i)).getElement();
                red += (float)(1 / count) * this.getRed(element);
                green += (float)(1 / count) * this.getGreen(element);
                blue += (float)(1 / count) * this.getBlue(element);
                ++j;
            }
        }
        GL11.glColor3f((float)red, (float)green, (float)blue);
        IIcon icon = item.func_77954_c();
        renderItem.func_94149_a(0, 0, icon, 16, 16);
        GL11.glPopMatrix();
    }
}

