/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.polytool;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minechem.Minechem;
import minechem.gui.CreativeTabMinechem;
import minechem.item.element.ElementEnum;
import minechem.item.element.ElementItem;
import minechem.item.polytool.PolytoolHelper;
import minechem.item.polytool.PolytoolTypeAlloy;
import minechem.item.polytool.PolytoolUpgradeType;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class PolytoolItem
extends ItemPickaxe {
    public static PolytoolItem instance;

    public PolytoolItem() {
        super(Item.ToolMaterial.IRON);
        instance = this;
        this.func_77637_a(CreativeTabMinechem.CREATIVE_TAB_ITEMS);
        this.func_77655_b("Polytool");
    }

    public static boolean validAlloyInfusion(ItemStack polytool, ItemStack element) {
        PolytoolUpgradeType upgrade;
        if (element.func_77973_b() instanceof ElementItem && (upgrade = PolytoolHelper.getTypeFromElement(ElementItem.getElement(element), 1.0f)) instanceof PolytoolTypeAlloy) {
            ItemStack toApply = polytool.func_77946_l();
            PolytoolItem.addTypeToNBT(toApply, upgrade);
            if (!(instance.getSwordStr(toApply) > 0.0f && instance.getPickaxeStr(toApply) > 0.0f && instance.getStoneStr(toApply) > 0.0f && instance.getAxeStr(toApply) > 0.0f && instance.getShovelStr(toApply) > 0.0f)) {
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World world, EntityPlayer entityPlayer) {
        entityPlayer.openGui((Object)Minechem.INSTANCE, 3, world, entityPlayer.field_70176_ah, entityPlayer.field_70162_ai, entityPlayer.field_70162_ai);
        return par1ItemStack;
    }

    public float getSwordStr(ItemStack stack) {
        return this.func_150893_a(stack, Blocks.field_150321_G);
    }

    public float getPickaxeStr(ItemStack stack) {
        return this.func_150893_a(stack, Blocks.field_150365_q);
    }

    public float getStoneStr(ItemStack stack) {
        return this.func_150893_a(stack, Blocks.field_150348_b);
    }

    public float getAxeStr(ItemStack stack) {
        return this.func_150893_a(stack, Blocks.field_150344_f);
    }

    public float getShovelStr(ItemStack stack) {
        return this.func_150893_a(stack, Blocks.field_150346_d);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a("minechem:polytool");
    }

    public float func_150893_a(ItemStack par1ItemStack, Block par2Block) {
        long sum = 8L;
        ArrayList upgrades = PolytoolItem.getUpgrades(par1ItemStack);
        Iterator iter = upgrades.iterator();
        while (iter.hasNext()) {
            sum = (long)((float)sum + ((PolytoolUpgradeType)iter.next()).getStrVsBlock(par1ItemStack, par2Block));
        }
        return sum;
    }

    public static ArrayList getUpgrades(ItemStack stack) {
        PolytoolItem.ensureNBT(stack);
        ArrayList<PolytoolUpgradeType> toReturn = new ArrayList<PolytoolUpgradeType>();
        NBTTagList list = stack.field_77990_d.func_150295_c("Upgrades", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            toReturn.add(PolytoolHelper.getTypeFromElement(ElementEnum.getByID(nbt.func_74762_e("Element")), nbt.func_74760_g("Power")));
        }
        return toReturn;
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        par2EntityLivingBase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)par3EntityLivingBase)), this.getSwordStr(par1ItemStack));
        ArrayList upgrades = PolytoolItem.getUpgrades(par1ItemStack);
        Iterator iter = upgrades.iterator();
        while (iter.hasNext()) {
            ((PolytoolUpgradeType)iter.next()).hitEntity(par1ItemStack, par2EntityLivingBase, par3EntityLivingBase);
        }
        return true;
    }

    public boolean func_150894_a(ItemStack p_150894_1_, World p_150894_2_, Block p_150894_3_, int p_150894_4_, int p_150894_5_, int p_150894_6_, EntityLivingBase p_150894_7_) {
        ArrayList upgrades = PolytoolItem.getUpgrades(p_150894_1_);
        Iterator iter = upgrades.iterator();
        while (iter.hasNext()) {
            ((PolytoolUpgradeType)iter.next()).onBlockDestroyed(p_150894_1_, p_150894_2_, p_150894_3_, p_150894_4_, p_150894_5_, p_150894_6_, p_150894_7_);
        }
        return true;
    }

    public static void addTypeToNBT(ItemStack stack, PolytoolUpgradeType type) {
        PolytoolItem.ensureNBT(stack);
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = stack.field_77990_d.func_150295_c("Upgrades", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            if (list.func_150305_b(i).func_74762_e("Element") != type.getElement().atomicNumber()) continue;
            list.func_150305_b(i).func_74776_a("Power", list.func_150305_b(i).func_74760_g("Power") + type.power);
            return;
        }
        compound.func_74776_a("Power", type.power);
        compound.func_74768_a("Element", type.getElement().atomicNumber());
        list.func_74742_a((NBTBase)compound);
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        ArrayList upgrades = PolytoolItem.getUpgrades(par1ItemStack);
        Iterator iter = upgrades.iterator();
        while (iter.hasNext()) {
            ((PolytoolUpgradeType)iter.next()).onTickFull(par1ItemStack, par2World, par3Entity, par4, par5);
        }
    }

    public static void ensureNBT(ItemStack item) {
        if (item.field_77990_d == null) {
            item.field_77990_d = new NBTTagCompound();
        }
        if (!item.field_77990_d.func_74764_b("Upgrades")) {
            item.field_77990_d.func_74782_a("Upgrades", (NBTBase)new NBTTagList());
        }
        if (!item.field_77990_d.func_74764_b("Energy")) {
            item.field_77990_d.func_74768_a("Energy", 0);
        }
    }

    public static float getPowerOfType(ItemStack item, ElementEnum element) {
        ArrayList upgrades = PolytoolItem.getUpgrades(item);
        for (PolytoolUpgradeType next : upgrades) {
            if (next.getElement().atomicNumber() != element.atomicNumber()) continue;
            return next.power;
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, list, par4);
    }
}

