/*
 * Decompiled with CFR 0.152.
 */
package minechem.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import minechem.gui.GuiDraw;
import minechem.potion.PotionChemical;
import minechem.reference.Resources;
import minechem.tileentity.synthesis.SynthesisGui;
import minechem.tileentity.synthesis.SynthesisRecipe;
import minechem.utils.Compare;
import minechem.utils.MinechemUtil;
import net.minecraft.item.ItemStack;

public class SynthesisNEIRecipeHandler
extends TemplateRecipeHandler {
    private static final String MINECHEM_SYNTHESIS_RECIPES_ID = "minechem.synthesis";
    private static final int INPUT_X_OFS = 57;
    private static final int INPUT_Y_OFS = 7;
    private static final int INPUT_X_SCALE = 18;
    private static final int INPUT_Y_SCALE = 18;
    private static final int OUTPUT_X_OFS = 129;
    private static final int OUTPUT_Y_OFS = 7;

    public String getRecipeName() {
        return MinechemUtil.getLocalString("gui.title.synthesis");
    }

    public String getGuiTexture() {
        return Resources.Gui.SYNTHESIS.toString();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(113, 7, 14, 16), MINECHEM_SYNTHESIS_RECIPES_ID, new Object[0]));
    }

    public Class getGuiClass() {
        return SynthesisGui.class;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(MINECHEM_SYNTHESIS_RECIPES_ID)) {
            for (SynthesisRecipe sr : SynthesisRecipe.recipes.values()) {
                this.registerSynthesisRecipe(sr);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (SynthesisRecipe sr : SynthesisRecipe.recipes.values()) {
            ItemStack recipeOutput = sr.getOutput();
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)result, (ItemStack)recipeOutput)) continue;
            this.registerSynthesisRecipe(sr);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (!Compare.isStackAChemical(ingredient)) {
            return;
        }
        PotionChemical ingredientChemical = MinechemUtil.itemStackToChemical(ingredient);
        if (ingredientChemical == null) {
            return;
        }
        block0: for (SynthesisRecipe sr : SynthesisRecipe.recipes.values()) {
            if (sr.isShaped()) {
                PotionChemical[] recipeInputs;
                for (PotionChemical c : recipeInputs = sr.getShapedRecipe()) {
                    if (!ingredientChemical.sameAs(c)) continue;
                    this.registerSynthesisRecipe(sr);
                    continue block0;
                }
                continue;
            }
            for (PotionChemical o : sr.getShapelessRecipe()) {
                PotionChemical c;
                c = o;
                if (!ingredientChemical.sameAs(c)) continue;
                this.registerSynthesisRecipe(sr);
                continue block0;
            }
        }
    }

    public void registerSynthesisRecipe(SynthesisRecipe sr) {
        if (sr == null) {
            return;
        }
        CachedSynthesisRecipe csr = new CachedSynthesisRecipe(sr);
        this.arecipes.add(csr);
    }

    public void drawExtras(int recipeIdx) {
        CachedSynthesisRecipe cdr = (CachedSynthesisRecipe)((Object)this.arecipes.get(recipeIdx));
        String shapedString = cdr.isShaped() ? "Shaped" : "Shapless";
        GuiDraw.drawString(shapedString, 117, 32, 8, false);
        String costString = cdr.getEnergyCost() + " RF";
        GuiDraw.drawString(costString, 117, 42, 8, false);
    }

    public class CachedSynthesisRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private List<PositionedStack> inputs;
        private PositionedStack output;
        private int energyCost;
        private boolean shaped;

        public CachedSynthesisRecipe(SynthesisRecipe sr) {
            super((TemplateRecipeHandler)SynthesisNEIRecipeHandler.this);
            this.inputs = new ArrayList<PositionedStack>();
            this.shaped = sr.isShaped();
            if (this.shaped) {
                PotionChemical[] inputChemicals = sr.getShapedRecipe();
                int xSlot = 0;
                int ySlot = 0;
                for (PotionChemical c : inputChemicals) {
                    if (c != null) {
                        ItemStack inputItem = MinechemUtil.chemicalToItemStack(c, c.amount);
                        this.inputs.add(new PositionedStack((Object)inputItem, 57 + xSlot * 18, 7 + ySlot * 18));
                    }
                    if (++xSlot <= 2) continue;
                    xSlot = 0;
                    ++ySlot;
                }
            } else {
                PotionChemical[] inputChemicals = sr.getShapelessRecipe();
                int xSlot = 0;
                int ySlot = 0;
                for (PotionChemical c : inputChemicals) {
                    ItemStack inputItem = MinechemUtil.chemicalToItemStack(c, c.amount);
                    this.inputs.add(new PositionedStack((Object)inputItem, 57 + xSlot * 18, 7 + ySlot * 18));
                    if (++xSlot <= 2) continue;
                    xSlot = 0;
                    ++ySlot;
                }
            }
            this.output = new PositionedStack((Object)sr.getOutput(), 129, 7);
            this.energyCost = sr.energyCost();
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public List<PositionedStack> getIngredients() {
            return this.inputs;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public int getEnergyCost() {
            return this.energyCost;
        }

        public boolean isShaped() {
            return this.shaped;
        }
    }
}

