/*
 * Decompiled with CFR 0.152.
 */
package minechem.network.message;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import minechem.tileentity.synthesis.SynthesisTileEntity;
import net.minecraft.tileentity.TileEntity;

public class SynthesisUpdateMessage
implements IMessage,
IMessageHandler<SynthesisUpdateMessage, IMessage> {
    private int posX;
    private int posY;
    private int posZ;
    private int energyStored;

    public SynthesisUpdateMessage() {
    }

    public SynthesisUpdateMessage(SynthesisTileEntity tile) {
        this.posX = tile.field_145851_c;
        this.posY = tile.field_145848_d;
        this.posZ = tile.field_145849_e;
        this.energyStored = tile.getEnergyStored();
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readInt();
        this.posY = buf.readInt();
        this.posZ = buf.readInt();
        this.energyStored = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
        buf.writeInt(this.energyStored);
    }

    public IMessage onMessage(SynthesisUpdateMessage message, MessageContext ctx) {
        TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(message.posX, message.posY, message.posZ);
        if (tileEntity instanceof SynthesisTileEntity) {
            ((SynthesisTileEntity)tileEntity).syncEnergyValue(message.energyStored);
        }
        return null;
    }
}

