/*
 * Decompiled with CFR 0.152.
 */
package minechem.oredictionary;

import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.oredictionary.OreDictionaryHandler;
import minechem.potion.PotionChemical;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.tileentity.synthesis.SynthesisRecipe;
import minechem.utils.LogHelper;

public class OreDictionaryAppliedEnergisticsHandler
implements OreDictionaryHandler {
    private MoleculeEnum certusQuartzMolecule = MoleculeEnum.aluminiumPhosphate;
    private PotionChemical certusQuartzChemical = new Molecule(this.certusQuartzMolecule);
    private MoleculeEnum chargedCertusQuartzMolecule = MoleculeEnum.aluminiumHypophosphite;
    private PotionChemical chargedCertusQuartzChemical = new Molecule(this.chargedCertusQuartzMolecule);
    private PotionChemical[] certusQuartzDecompositionFormula = new PotionChemical[]{new Molecule(this.certusQuartzMolecule, 4)};
    private PotionChemical[] certusQuartzCrystalSynthesisFormula = new PotionChemical[]{null, this.certusQuartzChemical, null, this.certusQuartzChemical, null, this.certusQuartzChemical, null, this.certusQuartzChemical, null};
    private PotionChemical[] certusQuartzDustSynthesisFormula = new PotionChemical[]{null, this.certusQuartzChemical, null, this.certusQuartzChemical, this.certusQuartzChemical, this.certusQuartzChemical, null, null, null};
    private PotionChemical[] chargedCertusQuartzDecompositionFormula = new PotionChemical[]{new Molecule(this.chargedCertusQuartzMolecule, 4)};
    private PotionChemical[] chargedCertusQuartzCrystalSynthesisFormula = new PotionChemical[]{null, this.chargedCertusQuartzChemical, null, this.chargedCertusQuartzChemical, null, this.chargedCertusQuartzChemical, null, this.chargedCertusQuartzChemical, null};
    private PotionChemical[] fluixCertusQuartzDecompositionFormula = new PotionChemical[]{new Molecule(this.certusQuartzMolecule, 2), new Molecule(this.chargedCertusQuartzMolecule)};
    private PotionChemical[] fluixQuartzCrystalSynthesisFormula = new PotionChemical[]{null, new Molecule(MoleculeEnum.galliumarsenide, 1), null, this.certusQuartzChemical, null, this.chargedCertusQuartzChemical, null, this.chargedCertusQuartzChemical, null};
    private PotionChemical[] fluixQuartzDustDecompositionFormula = new PotionChemical[]{new Molecule(MoleculeEnum.galliumarsenide, 1), new Molecule(this.certusQuartzMolecule, 1), new Molecule(this.chargedCertusQuartzMolecule, 2)};
    private PotionChemical[] fluixQuartzDustSynthesisFormula = new PotionChemical[]{null, null, null, this.certusQuartzChemical, new Molecule(MoleculeEnum.galliumarsenide, 1), this.chargedCertusQuartzChemical, null, this.chargedCertusQuartzChemical, null};
    private PotionChemical[] fluixQuartzPearlDecompositionFormula = new PotionChemical[]{new Molecule(MoleculeEnum.galliumarsenide, 2), this.certusQuartzChemical, new Molecule(this.chargedCertusQuartzMolecule, 2)};
    private PotionChemical[] fluixQuartzPearlSynthesisFormula = new PotionChemical[]{null, new Molecule(MoleculeEnum.galliumarsenide, 1), null, this.certusQuartzChemical, new Molecule(MoleculeEnum.galliumarsenide, 1), this.chargedCertusQuartzChemical, null, this.chargedCertusQuartzChemical, null};

    @Override
    public boolean canHandle(String oreName) {
        return oreName.endsWith("CertusQuartz") || oreName.endsWith("Fluix");
    }

    @Override
    public void handle(String oreName) {
        if (oreName.equals("dustCertusQuartz")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.certusQuartzDecompositionFormula);
            SynthesisRecipe.createAndAddRecipeSafely(oreName, true, 30000, this.certusQuartzDustSynthesisFormula);
        } else if (oreName.equals("crystalCertusQuartz")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.certusQuartzDecompositionFormula);
            SynthesisRecipe.createAndAddRecipeSafely(oreName, true, 30000, this.certusQuartzCrystalSynthesisFormula);
        } else if (oreName.equals("crystalChargedCertusQuartz")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.chargedCertusQuartzDecompositionFormula);
            SynthesisRecipe.createAndAddRecipeSafely(oreName, true, 30000, this.chargedCertusQuartzCrystalSynthesisFormula);
        } else if (oreName.equals("crystalFluix")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.fluixCertusQuartzDecompositionFormula);
            SynthesisRecipe.createAndAddRecipeSafely(oreName, true, 30000, this.fluixQuartzCrystalSynthesisFormula);
        } else if (oreName.equals("dustFluix")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.fluixQuartzDustDecompositionFormula);
            SynthesisRecipe.createAndAddRecipeSafely(oreName, true, 30000, this.fluixQuartzDustSynthesisFormula);
        } else if (oreName.equals("pearlFluix")) {
            DecomposerRecipe.createAndAddRecipeSafely(oreName, this.fluixQuartzPearlDecompositionFormula);
            SynthesisRecipe.createAndAddRecipeSafely(oreName, true, 30000, this.fluixQuartzPearlSynthesisFormula);
        } else {
            LogHelper.debug("Unknown type of AE2 item : " + oreName);
        }
    }
}

