/*
 * Decompiled with CFR 0.152.
 */
package minechem.potion;

import java.util.ArrayList;
import minechem.utils.EnumColour;
import minechem.utils.MinechemUtil;
import minechem.utils.PotionHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;

public abstract class PharmacologyEffect {
    private String colour;

    PharmacologyEffect(EnumColour colour) {
        this.colour = colour.toString();
    }

    public abstract void applyEffect(EntityLivingBase var1);

    public String getColour() {
        return this.colour;
    }

    public static class Potion
    extends PharmacologyEffect {
        private int duration;
        private int power;
        private int potionId;

        public Potion(String potionName, int power, int duration) {
            this(PotionHelper.getPotionByName(potionName).func_76396_c(), power, duration);
        }

        public Potion(String potionName, int duration) {
            this(potionName, 0, duration);
        }

        public Potion(int potionId, int duration) {
            this(potionId, 0, duration);
        }

        public Potion(int potionId, int power, int duration) {
            super(EnumColour.PURPLE);
            this.duration = duration;
            this.potionId = potionId;
            this.power = power;
        }

        @Override
        public void applyEffect(EntityLivingBase entityLivingBase) {
            entityLivingBase.func_70690_d(new PotionEffect(this.potionId, this.duration * 20, this.power));
        }

        public String toString() {
            return "Potion Effect: " + MinechemUtil.getLocalString(PotionHelper.getPotionNameById(this.potionId)) + ", Duration: " + this.duration + ", Power: " + this.power;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Potion) {
                Potion other = (Potion)obj;
                if (other.duration == this.duration && other.potionId == this.potionId && other.power == this.power) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Damage
    extends PharmacologyEffect {
        private float damage;

        public Damage(float damage) {
            super(EnumColour.ORANGE);
            this.damage = damage;
        }

        @Override
        public void applyEffect(EntityLivingBase entityLivingBase) {
            entityLivingBase.func_70097_a(DamageSource.field_76377_j, this.damage);
        }

        public String toString() {
            float print = this.damage / 2.0f;
            return "Damage Effect: " + print + " heart" + (print == 1.0f ? "" : "s");
        }

        public boolean equals(Object obj) {
            if (obj instanceof Damage) {
                Damage other = (Damage)obj;
                if (other.damage == this.damage) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Cure
    extends PharmacologyEffect {
        private int potionId;

        public Cure() {
            this(-1);
        }

        public Cure(int potionId) {
            super(EnumColour.AQUA);
            this.potionId = potionId;
        }

        public Cure(String potionName) {
            this(PotionHelper.getPotionByName(potionName).func_76396_c());
        }

        @Override
        public void applyEffect(EntityLivingBase entityLivingBase) {
            if (this.potionId == -1) {
                for (PotionEffect potionEffect : new ArrayList(entityLivingBase.func_70651_bq())) {
                    entityLivingBase.func_82170_o(potionEffect.func_76456_a());
                }
            } else {
                entityLivingBase.func_82170_o(this.potionId);
            }
        }

        public String toString() {
            return "Cure Effect: " + (this.potionId == -1 ? "all" : MinechemUtil.getLocalString(PotionHelper.getPotionNameById(this.potionId)));
        }

        public boolean equals(Object obj) {
            if (obj instanceof Cure) {
                Cure other = (Cure)obj;
                if (other.potionId == this.potionId) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Burn
    extends PharmacologyEffect {
        private int duration;

        public Burn(int duration) {
            super(EnumColour.RED);
            this.duration = duration;
        }

        @Override
        public void applyEffect(EntityLivingBase entityLivingBase) {
            entityLivingBase.func_70015_d(this.duration);
        }

        public String toString() {
            return "Burn Effect: " + this.duration + " s";
        }

        public boolean equals(Object obj) {
            if (obj instanceof Burn) {
                Burn other = (Burn)obj;
                if (other.duration == this.duration) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Food
    extends PharmacologyEffect {
        private int level;
        private float saturation;

        public Food(int level, float saturation) {
            super(EnumColour.DARK_GREEN);
            this.level = level;
            this.saturation = saturation;
        }

        @Override
        public void applyEffect(EntityLivingBase entityLivingBase) {
            if (entityLivingBase instanceof EntityPlayer) {
                ((EntityPlayer)entityLivingBase).func_71024_bL().func_75122_a(this.level, this.saturation);
            }
        }

        public String toString() {
            return "Food Effect: " + this.level + ", Saturation: " + this.saturation;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Food) {
                Food other = (Food)obj;
                if (other.level == this.level && other.saturation == this.saturation) {
                    return true;
                }
            }
            return false;
        }
    }
}

