/*
 * Decompiled with CFR 0.152.
 */
package minechem.radiation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import minechem.MinechemItemsRegistration;
import minechem.fluid.FluidHelper;
import minechem.item.bucket.MinechemBucketHandler;
import minechem.item.bucket.MinechemBucketItem;
import minechem.item.element.Element;
import minechem.item.element.ElementEnum;
import minechem.item.element.ElementItem;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.item.molecule.MoleculeItem;
import minechem.potion.PotionChemical;
import minechem.radiation.RadiationEnum;
import minechem.radiation.RadiationInfo;
import minechem.utils.MinechemUtil;
import minechem.utils.SoftHashMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class RadiationMoleculeHandler {
    private static RadiationMoleculeHandler instance = null;
    private final Map<MoleculeEnum, PotionChemical[]> decayedMoleculesPre;
    private final Map<MoleculeEnum, PotionChemical[]> decayedMoleculesCache = new SoftHashMap<MoleculeEnum, PotionChemical[]>();

    public static RadiationMoleculeHandler getInstance() {
        if (instance == null) {
            instance = new RadiationMoleculeHandler();
        }
        return instance;
    }

    private RadiationMoleculeHandler() {
        this.decayedMoleculesPre = new SoftHashMap<MoleculeEnum, PotionChemical[]>();
        this.initDecayedMoleculesPre();
    }

    public RadiationInfo handleRadiationMoleculeBucket(World world, ItemStack itemStack, IInventory inventory, double x, double y, double z) {
        PotionChemical[] decayedChemicals = this.getDecayedMolecule((MoleculeEnum)((MinechemBucketItem)itemStack.func_77973_b()).chemical);
        for (int i = 0; i < decayedChemicals.length; ++i) {
            decayedChemicals[i].amount *= 8 * itemStack.field_77994_a;
        }
        ItemStack[] items = this.toItemStacks(decayedChemicals);
        for (int i = 1; i < items.length; ++i) {
            ItemStack stack = MinechemUtil.addItemToInventory(inventory, items[i]);
            if (stack == null) continue;
            MinechemUtil.throwItemStack(world, itemStack, x, y, z);
        }
        Item item = items[0].func_77973_b();
        if (item instanceof MoleculeItem) {
            itemStack.func_150996_a((Item)MinechemBucketHandler.getInstance().buckets.get((Object)FluidHelper.moleculeBlocks.get((Object)FluidHelper.molecules.get(MoleculeItem.getMolecule(items[0])))));
        } else if (item instanceof ElementItem) {
            itemStack.func_150996_a((Item)MinechemBucketHandler.getInstance().buckets.get((Object)FluidHelper.elementsBlocks.get((Object)FluidHelper.elements.get(ElementItem.getElement(items[0])))));
        }
        itemStack.field_77994_a = items[0].field_77994_a / 8;
        itemStack.func_77982_d(items[0].field_77990_d);
        return ElementItem.initiateRadioactivity(itemStack, world);
    }

    public RadiationInfo handleRadiationMolecule(World world, ItemStack itemStack, IInventory inventory, double x, double y, double z) {
        PotionChemical[] decayedChemicals = this.getDecayedMolecule(MoleculeItem.getMolecule(itemStack));
        for (int i = 0; i < decayedChemicals.length; ++i) {
            decayedChemicals[i].amount *= itemStack.field_77994_a;
        }
        ItemStack[] items = this.toItemStacks(decayedChemicals);
        for (int i = 1; i < items.length; ++i) {
            ItemStack stack = MinechemUtil.addItemToInventory(inventory, items[i]);
            if (stack == null) continue;
            MinechemUtil.throwItemStack(world, itemStack, x, y, z);
        }
        itemStack.func_77964_b(items[0].func_77960_j());
        itemStack.func_150996_a(items[0].func_77973_b());
        itemStack.field_77994_a = items[0].field_77994_a;
        itemStack.func_77982_d(items[0].field_77990_d);
        return ElementItem.initiateRadioactivity(itemStack, world);
    }

    private void initDecayedMoleculesPre() {
    }

    private PotionChemical[] getDecayedMolecule(MoleculeEnum molecule) {
        PotionChemical[] chemicals = this.decayedMoleculesPre.get(molecule);
        if (chemicals != null) {
            return this.copyOf(chemicals);
        }
        chemicals = this.decayedMoleculesCache.get(molecule);
        if (chemicals == null) {
            Set<PotionChemical> potionChemicalsSet = this.computDecayMolecule(molecule);
            chemicals = potionChemicalsSet.toArray(new PotionChemical[potionChemicalsSet.size()]);
            this.decayedMoleculesCache.put(molecule, chemicals);
        }
        return this.copyOf(chemicals);
    }

    private ItemStack[] toItemStacks(PotionChemical[] chemicalsArray) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        ArrayList<PotionChemical> chemicals = new ArrayList<PotionChemical>(chemicalsArray.length);
        for (int i = 0; i < chemicalsArray.length; ++i) {
            chemicals.add(chemicalsArray[i]);
        }
        while (!chemicals.isEmpty()) {
            int thisDamage;
            Item thisType;
            int index = chemicals.size() - 1;
            PotionChemical chemical = (PotionChemical)chemicals.remove(index);
            if (chemical instanceof Element) {
                thisType = MinechemItemsRegistration.element;
                thisDamage = ((Element)chemical).element.atomicNumber();
            } else {
                if (!(chemical instanceof Molecule)) continue;
                thisType = MinechemItemsRegistration.molecule;
                thisDamage = ((Molecule)chemical).molecule.id();
            }
            for (int l = 0; l < itemStacks.size() && chemical.amount > 0; ++l) {
                ItemStack stack = (ItemStack)itemStacks.get(l);
                if (stack.func_77973_b() != thisType || stack.func_77960_j() != thisDamage) continue;
                int freeSpace = 64 - stack.field_77994_a;
                int append = freeSpace > chemical.amount ? chemical.amount : freeSpace;
                chemical.amount -= append;
                stack.field_77994_a += append;
            }
            if (chemical.amount <= 0) continue;
            itemStacks.add(new ItemStack(thisType, chemical.amount, thisDamage));
        }
        return itemStacks.toArray(new ItemStack[itemStacks.size()]);
    }

    private Set<PotionChemical> computDecayMolecule(MoleculeEnum molecule) {
        ArrayList<PotionChemical> chemicals = molecule.components();
        HashSet<PotionChemical> outChemicals = new HashSet<PotionChemical>();
        if (molecule.radioactivity() == RadiationEnum.stable) {
            outChemicals.add(new Molecule(molecule));
            return outChemicals;
        }
        for (PotionChemical chemical1 : chemicals) {
            PotionChemical chemical = chemical1.copy();
            if (chemical instanceof Element) {
                Element element = (Element)chemical;
                if (element.element.radioactivity() != RadiationEnum.stable) {
                    element.element = ElementEnum.getByID(element.element.atomicNumber());
                }
            } else if (chemical instanceof Molecule) {
                Molecule molecule2 = (Molecule)chemical;
                if (molecule2.molecule.radioactivity() != RadiationEnum.stable) {
                    PotionChemical[] chemicals2 = this.getDecayedMolecule(molecule2.molecule);
                    Collections.addAll(outChemicals, chemicals2);
                    chemical = null;
                }
            }
            if (chemical == null) continue;
            outChemicals.add(chemical);
        }
        return outChemicals;
    }

    private PotionChemical[] copyOf(PotionChemical[] a) {
        PotionChemical[] b = new PotionChemical[a.length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = a[i].clone();
        }
        return b;
    }
}

