/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.blueprintprojector;

import java.util.HashMap;
import minechem.MinechemBlocksGeneration;
import minechem.MinechemItemsRegistration;
import minechem.item.blueprint.BlueprintBlock;
import minechem.item.blueprint.MinechemBlueprint;
import minechem.sound.LoopingSound;
import minechem.tileentity.multiblock.MultiBlockStatusEnum;
import minechem.tileentity.multiblock.MultiBlockTileEntity;
import minechem.tileentity.multiblock.fusion.FusionTileEntity;
import minechem.tileentity.multiblock.ghostblock.GhostBlockTileEntity;
import minechem.tileentity.prefab.MinechemTileEntity;
import minechem.tileentity.prefab.TileEntityProxy;
import minechem.utils.LocalPosition;
import minechem.utils.MinechemUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class BlueprintProjectorTileEntity
extends MinechemTileEntity {
    private static int air;
    MinechemBlueprint blueprint;
    boolean isComplete = false;
    Integer[][][] structure;
    LoopingSound projectorSound = new LoopingSound("minechem:projector", 20);

    public BlueprintProjectorTileEntity() {
        this.projectorSound.setVolume(0.2f);
        this.inventory = new ItemStack[this.func_70302_i_()];
    }

    @Override
    public void func_145845_h() {
        if (this.blueprint != null && !this.isComplete) {
            this.projectBlueprint();
            this.projectorSound.play(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void projectBlueprint() {
        int facing = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ForgeDirection direction = MinechemUtil.getDirectionFromFacing(facing);
        LocalPosition position = new LocalPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e, direction);
        position.moveForwards(this.blueprint.zSize + 1);
        position.moveLeft(Math.floor(this.blueprint.xSize / 2));
        boolean shouldProjectGhostBlocks = true;
        int totalIncorrectCount = this.blueprint.getTotalSize();
        for (int x = 0; x < this.blueprint.xSize; ++x) {
            int verticalIncorrectCount = this.blueprint.getVerticalSliceSize();
            for (int y = 0; y < this.blueprint.ySize; ++y) {
                for (int z = 0; z < this.blueprint.zSize; ++z) {
                    if (shouldProjectGhostBlocks) {
                        MultiBlockStatusEnum multiBlockStatusEnum = this.isManagerBlock(x, y, z) ? MultiBlockStatusEnum.CORRECT : this.projectGhostBlock(x, y, z, position);
                        if (multiBlockStatusEnum != MultiBlockStatusEnum.CORRECT) continue;
                        --verticalIncorrectCount;
                        --totalIncorrectCount;
                        continue;
                    }
                    this.destroyGhostBlock(x, y, z, position);
                }
            }
            if (verticalIncorrectCount == 0) continue;
            shouldProjectGhostBlocks = false;
        }
        if (!(totalIncorrectCount != 0 || this.isComplete && this.field_145850_b.func_147438_o(this.blueprint.getManagerPosX(), this.blueprint.getManagerPosY(), this.blueprint.getManagerPosZ()) instanceof MultiBlockTileEntity)) {
            this.isComplete = true;
            this.buildStructure(position);
        }
    }

    private void buildStructure(LocalPosition position) {
        Integer[][][] resultStructure = this.blueprint.getResultStructure();
        HashMap<Integer, BlueprintBlock> blockLookup = this.blueprint.getBlockLookup();
        TileEntity managerTileEntity = this.buildManagerBlock(position);
        for (int x = 0; x < this.blueprint.xSize; ++x) {
            for (int y = 0; y < this.blueprint.ySize; ++y) {
                for (int z = 0; z < this.blueprint.zSize; ++z) {
                    if (this.isManagerBlock(x, y, z)) continue;
                    int structureId = resultStructure[y][x][z];
                    this.setBlock(x, y, z, position, structureId, blockLookup, managerTileEntity);
                }
            }
        }
    }

    private boolean isManagerBlock(int x, int y, int z) {
        return x == this.blueprint.getManagerPosX() && y == this.blueprint.getManagerPosY() && z == this.blueprint.getManagerPosZ();
    }

    private TileEntity buildManagerBlock(LocalPosition position) {
        BlueprintBlock managerBlock = this.blueprint.getManagerBlock();
        if (managerBlock != null) {
            LocalPosition.Pos3 worldPos = position.getLocalPos(this.blueprint.getManagerPosX(), this.blueprint.getManagerPosY(), this.blueprint.getManagerPosZ());
            this.field_145850_b.func_147465_d(worldPos.x, worldPos.y, worldPos.z, managerBlock.block, managerBlock.metadata, 3);
            if (this.blueprint == MinechemBlueprint.fusion && this.field_145850_b.func_147438_o(worldPos.x, worldPos.y, worldPos.z) == null) {
                FusionTileEntity fusion = new FusionTileEntity();
                fusion.func_145834_a(this.field_145850_b);
                fusion.field_145851_c = worldPos.x;
                fusion.field_145848_d = worldPos.y;
                fusion.field_145849_e = worldPos.z;
                fusion.field_145854_h = MinechemBlocksGeneration.fusion;
                this.field_145850_b.addTileEntity((TileEntity)fusion);
            }
            return this.field_145850_b.func_147438_o(worldPos.x, worldPos.y, worldPos.z);
        }
        return null;
    }

    private void setBlock(int x, int y, int z, LocalPosition position, int structureId, HashMap<Integer, BlueprintBlock> blockLookup, TileEntity managerTileEntity) {
        LocalPosition.Pos3 worldPos = position.getLocalPos(x, y, z);
        if (structureId == -1) {
            return;
        }
        if (structureId == air) {
            this.field_145850_b.func_147468_f(worldPos.x, worldPos.y, worldPos.z);
        } else {
            TileEntity te;
            BlueprintBlock blueprintBlock = blockLookup.get(structureId);
            if (blueprintBlock.type == BlueprintBlock.Type.MANAGER) {
                return;
            }
            this.field_145850_b.func_147465_d(worldPos.x, worldPos.y, worldPos.z, blueprintBlock.block, blueprintBlock.metadata, 3);
            if (blueprintBlock.type == BlueprintBlock.Type.PROXY && (te = this.field_145850_b.func_147438_o(worldPos.x, worldPos.y, worldPos.z)) instanceof TileEntityProxy) {
                TileEntityProxy proxy = (TileEntityProxy)te;
            }
        }
    }

    private MultiBlockStatusEnum projectGhostBlock(int x, int y, int z, LocalPosition position) {
        LocalPosition.Pos3 worldPos = position.getLocalPos(x, y, z);
        Integer structureID = this.structure[y][x][z];
        Block block = this.field_145850_b.func_147439_a(worldPos.x, worldPos.y, worldPos.z);
        int blockMetadata = this.field_145850_b.func_72805_g(worldPos.x, worldPos.y, worldPos.z);
        if (structureID == -1) {
            return MultiBlockStatusEnum.CORRECT;
        }
        if (structureID == air) {
            if (block.isAir((IBlockAccess)this.field_145850_b, x, y, z)) {
                return MultiBlockStatusEnum.CORRECT;
            }
            return MultiBlockStatusEnum.INCORRECT;
        }
        HashMap<Integer, BlueprintBlock> lut = this.blueprint.getBlockLookup();
        BlueprintBlock blueprintBlock = lut.get(structureID);
        if (block.isAir((IBlockAccess)this.field_145850_b, x, y, z)) {
            this.createGhostBlock(worldPos.x, worldPos.y, worldPos.z, structureID);
            return MultiBlockStatusEnum.INCORRECT;
        }
        if (block == blueprintBlock.block && (blockMetadata == blueprintBlock.metadata || blueprintBlock.metadata == -1)) {
            return MultiBlockStatusEnum.CORRECT;
        }
        return MultiBlockStatusEnum.INCORRECT;
    }

    private void createGhostBlock(int x, int y, int z, int blockID) {
        this.field_145850_b.func_147465_d(x, y, z, MinechemBlocksGeneration.ghostBlock, 0, 3);
        TileEntity tileEntity = this.field_145850_b.func_147438_o(x, y, z);
        if (tileEntity instanceof GhostBlockTileEntity) {
            GhostBlockTileEntity ghostBlock = (GhostBlockTileEntity)tileEntity;
            ghostBlock.setBlueprintAndID(this.blueprint, blockID);
        }
    }

    public void destroyProjection() {
        if (this.blueprint == null) {
            return;
        }
        int facing = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ForgeDirection direction = MinechemUtil.getDirectionFromFacing(facing);
        LocalPosition position = new LocalPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e, direction);
        position.moveForwards(this.blueprint.zSize + 1);
        position.moveLeft(Math.floor(this.blueprint.xSize / 2));
        for (int x = 0; x < this.blueprint.xSize; ++x) {
            for (int y = 0; y < this.blueprint.ySize; ++y) {
                for (int z = 0; z < this.blueprint.zSize; ++z) {
                    this.destroyGhostBlock(x, y, z, position);
                }
            }
        }
    }

    private void destroyGhostBlock(int x, int y, int z, LocalPosition position) {
        LocalPosition.Pos3 worldPos = position.getLocalPos(x, y, z);
        Block block = this.field_145850_b.func_147439_a(worldPos.x, worldPos.y, worldPos.z);
        if (block == MinechemBlocksGeneration.ghostBlock) {
            this.field_145850_b.func_147468_f(worldPos.x, worldPos.y, worldPos.z);
        }
    }

    public int getFacing() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setBlueprint(MinechemBlueprint blueprint) {
        if (blueprint != null) {
            this.blueprint = blueprint;
            this.structure = blueprint.getStructure();
        } else {
            this.destroyProjection();
            this.blueprint = null;
            this.structure = null;
            this.isComplete = false;
        }
    }

    public MinechemBlueprint takeBlueprint() {
        MinechemBlueprint blueprint = this.blueprint;
        this.setBlueprint(null);
        return blueprint;
    }

    public boolean hasBlueprint() {
        return this.blueprint != null;
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        this.setBlueprint(null);
        return super.func_70298_a(slot, amount);
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        super.func_70299_a(slot, itemstack);
        if (itemstack != null) {
            MinechemBlueprint blueprint = MinechemItemsRegistration.blueprint.getBlueprint(itemstack);
            this.setBlueprint(blueprint);
        }
    }

    public String func_145825_b() {
        return "container.blueprintProjector";
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        ItemStack blueprintStack = this.inventory[0];
        if (blueprintStack != null) {
            NBTTagCompound blueprintNBT = new NBTTagCompound();
            blueprintStack.func_77955_b(blueprintNBT);
            nbtTagCompound.func_74782_a("blueprint", (NBTBase)blueprintNBT);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.isComplete = false;
        NBTTagCompound blueprintNBT = (NBTTagCompound)nbtTagCompound.func_74781_a("blueprint");
        if (blueprintNBT != null) {
            ItemStack blueprintStack = ItemStack.func_77949_a((NBTTagCompound)blueprintNBT);
            MinechemBlueprint blueprint = MinechemItemsRegistration.blueprint.getBlueprint(blueprintStack);
            this.setBlueprint(blueprint);
            this.inventory[0] = blueprintStack;
        }
    }

    public MinechemBlueprint getBlueprint() {
        return this.blueprint;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return itemstack.func_77973_b() == MinechemItemsRegistration.blueprint;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

