/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.decomposer;

import java.util.ArrayList;
import java.util.List;
import minechem.Settings;
import minechem.api.INoDecay;
import minechem.api.IRadiationShield;
import minechem.slot.SlotOutput;
import minechem.tileentity.decomposer.DecomposerTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class DecomposerContainer
extends Container
implements IRadiationShield,
INoDecay {
    protected DecomposerTileEntity decomposer;
    protected final int kPlayerInventorySlotStart;
    protected final int kPlayerInventorySlotEnd;
    protected final int kDecomposerInventoryEnd;

    public DecomposerContainer(InventoryPlayer inventoryPlayer, DecomposerTileEntity decomposer) {
        this.decomposer = decomposer;
        this.kPlayerInventorySlotStart = decomposer.func_70302_i_();
        this.kPlayerInventorySlotEnd = this.kPlayerInventorySlotStart + 36;
        this.kDecomposerInventoryEnd = decomposer.func_70302_i_();
        this.func_75146_a(new Slot((IInventory)decomposer, decomposer.kInputSlot, 80, 16));
        this.bindOutputSlots();
        this.bindPlayerInventory(inventoryPlayer);
    }

    private void bindOutputSlots() {
        int x = 8;
        int y = 62;
        int j = 0;
        for (int i = 1; i < 10; ++i) {
            this.func_75146_a(new SlotOutput(this.decomposer, i, x + j * 18, y));
            ++j;
        }
    }

    private void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 142));
        }
    }

    public boolean func_75145_c(EntityPlayer entityPlayer) {
        return this.decomposer.func_70300_a(entityPlayer);
    }

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int slot) {
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        ItemStack stack = null;
        if (slotObject != null && slotObject.func_75216_d()) {
            ItemStack stackInSlot = slotObject.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (slot < this.kDecomposerInventoryEnd) {
                if (!this.func_75135_a(stackInSlot, this.kPlayerInventorySlotStart, this.field_75151_b.size(), true)) {
                    return null;
                }
            } else {
                if (this.decomposer.func_94041_b(0, stackInSlot) && !this.func_75135_a(stackInSlot, this.decomposer.kInputSlot, this.decomposer.kInputSlot + 1, false)) {
                    return null;
                }
                if (slot < 37 && stackInSlot.field_77994_a == stack.field_77994_a && !this.func_75135_a(stackInSlot, 37, 46, false)) {
                    return null;
                }
                if (slot > 36 && stackInSlot.field_77994_a == stack.field_77994_a && !this.func_75135_a(stackInSlot, 10, 37, false)) {
                    return null;
                }
            }
            if (stackInSlot.field_77994_a == 0) {
                slotObject.func_75215_d(null);
            } else {
                slotObject.func_75218_e();
            }
            if (stackInSlot.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slotObject.func_82870_a(entityPlayer, stackInSlot);
        }
        return stack;
    }

    @Override
    public float getRadiationReductionFactor(int baseDamage, ItemStack itemstack, EntityPlayer player) {
        return 0.4f;
    }

    @Override
    public List<ItemStack> getStorageInventory() {
        if (Settings.decaySafeMachines) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> storageInventory = new ArrayList<ItemStack>();
        for (int slot = 0; slot < 27; ++slot) {
            ItemStack stack = this.func_75139_a(slot).func_75211_c();
            if (stack == null) continue;
            storageInventory.add(stack);
        }
        return storageInventory;
    }

    @Override
    public List<ItemStack> getPlayerInventory() {
        if (Settings.decaySafeMachines) {
            ArrayList<ItemStack> inv = new ArrayList<ItemStack>();
            for (int slot = 0; slot < this.field_75151_b.size(); ++slot) {
                ItemStack stack = this.func_75139_a(slot).func_75211_c();
                if (stack == null) continue;
                inv.add(stack);
            }
            return inv;
        }
        ArrayList<ItemStack> playerInventory = new ArrayList<ItemStack>();
        for (int slot = 27; slot < this.field_75151_b.size(); ++slot) {
            ItemStack stack = this.func_75139_a(slot).func_75211_c();
            if (stack == null) continue;
            playerInventory.add(stack);
        }
        return playerInventory;
    }
}

