/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.decomposer;

import minechem.gui.GuiContainerTabbed;
import minechem.gui.GuiFluidTank;
import minechem.gui.GuiTabHelp;
import minechem.gui.GuiTabPatreon;
import minechem.reference.Resources;
import minechem.tileentity.decomposer.DecomposerContainer;
import minechem.tileentity.decomposer.DecomposerTabStateControl;
import minechem.tileentity.decomposer.DecomposerTileEntity;
import minechem.utils.MinechemUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.opengl.GL11;

public class DecomposerGui
extends GuiContainerTabbed {
    private DecomposerTileEntity decomposer;
    private GuiFluidTank guiFluidTank;
    private GuiButton dumpButton;
    int guiWidth = 176;
    int guiHeight = 166;

    public DecomposerGui(InventoryPlayer inventoryPlayer, DecomposerTileEntity decomposer) {
        super(new DecomposerContainer(inventoryPlayer, decomposer));
        this.decomposer = decomposer;
        this.addTab(new DecomposerTabStateControl((Gui)this, decomposer));
        this.addTab(new GuiTabHelp(this, MinechemUtil.getLocalString("help.decomposer")));
        this.addTab(new GuiTabPatreon(this));
        this.guiFluidTank = new GuiFluidTank(decomposer.capacity, 18, 16);
        this.dumpButton = new GuiButton(0, 20, 5, 12, 12, "x");
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        String info = MinechemUtil.getLocalString("gui.title.decomposer");
        int infoWidth = this.field_146289_q.func_78256_a(info);
        this.field_146289_q.func_78276_b(info, (this.guiWidth - infoWidth) / 2, 5, 0);
        this.guiFluidTank.drawTooltip(this.mouseX, this.mouseY, this.decomposer.tank);
        this.dumpButton.func_146112_a(this.field_146297_k, this.mouseX, this.mouseY);
        GL11.glDisable((int)3042);
        if (this.mouseInButton(this.mouseX, this.mouseY)) {
            this.drawHoveringText(MinechemUtil.getLocalString("gui.title.decomposer.dump"), this.mouseX, this.mouseY);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int mouseButton) {
        super.func_73864_a(x, y, mouseButton);
        if (this.mouseInButton(this.mouseX, this.mouseY)) {
            this.decomposer.dumpFluid();
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(Resources.Gui.DECOMPOSER);
        int x = (this.field_146294_l - this.guiWidth) / 2;
        int y = (this.field_146295_m - this.guiHeight) / 2;
        this.func_73729_b(x, y, 0, 0, this.guiWidth, this.guiHeight);
        this.guiFluidTank.draw(x, y, this.decomposer.tank);
    }

    private boolean mouseInButton(int x, int y) {
        return x >= this.dumpButton.field_146128_h && x < this.dumpButton.field_146128_h + this.dumpButton.field_146120_f && y >= this.dumpButton.field_146129_i && y < this.dumpButton.field_146129_i + this.dumpButton.field_146121_g;
    }
}

