/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.decomposer;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import minechem.Settings;
import minechem.api.IDecomposerControl;
import minechem.potion.PotionChemical;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.utils.LogHelper;
import minechem.utils.MapKey;
import minechem.utils.MinechemUtil;
import minechem.utils.Recipe;
import net.minecraft.item.ItemStack;

public class DecomposerRecipeSuper
extends DecomposerRecipe {
    static Random random = new Random();
    public Map<MapKey, Double> recipes = new Hashtable<MapKey, Double>();

    public DecomposerRecipeSuper(ItemStack input, ItemStack[] components, int level) {
        super(new PotionChemical[0]);
        this.input = input.func_77946_l();
        this.input.field_77994_a = 1;
        LogHelper.debug(input.toString());
        for (ItemStack component : components) {
            Recipe recipe;
            if (component == null || component.func_77973_b() == null || component.func_77973_b() instanceof IDecomposerControl && ((IDecomposerControl)component.func_77973_b()).getDecomposerMultiplier(component) == 0.0) continue;
            DecomposerRecipe decompRecipe = DecomposerRecipe.get(component);
            if (decompRecipe != null) {
                this.addDecompRecipe(decompRecipe, 1.0 / (double)Math.max(input.field_77994_a, 1));
                continue;
            }
            if (component.func_77969_a(input) && component.func_77960_j() == input.func_77960_j() || (recipe = Recipe.get(component)) == null || level >= Settings.recursiveDepth) continue;
            DecomposerRecipeSuper newSuper = new DecomposerRecipeSuper(recipe.output, recipe.inStacks, level + 1);
            DecomposerRecipe.add(newSuper);
            this.addDecompRecipe(newSuper, 1.0 / (double)recipe.getOutStackSize());
        }
    }

    private void addDecompRecipe(DecomposerRecipe decompRecipe, double d) {
        Double current;
        MapKey key = MapKey.getKey(decompRecipe.input);
        if (key != null && (current = this.recipes.put(key, d)) != null) {
            this.recipes.put(key, d + current);
        }
    }

    public DecomposerRecipeSuper(ItemStack input, ItemStack[] components) {
        this(input, components, 0);
    }

    public DecomposerRecipeSuper(ItemStack input, ItemStack[] components, ArrayList<PotionChemical> chemicals) {
        this(input, components, 0);
        this.addPotionChemical(chemicals);
    }

    private void addPotionChemical(ArrayList<PotionChemical> out) {
        if (out != null) {
            for (PotionChemical add : out) {
                super.addChemicals(add);
            }
        }
    }

    @Override
    public ArrayList<PotionChemical> getOutput() {
        ArrayList<PotionChemical> result = super.getOutput();
        for (MapKey currentKey : this.recipes.keySet()) {
            ArrayList<PotionChemical> partialResult;
            DecomposerRecipe current = DecomposerRecipe.get(currentKey);
            if (current == null) continue;
            Double i = this.recipes.get(currentKey);
            LogHelper.debug("getOutput :" + currentKey + " chance: " + i);
            while (i >= 1.0) {
                partialResult = current.getOutput();
                if (partialResult != null) {
                    result.addAll(partialResult);
                }
                Double d = i;
                Double d2 = i = Double.valueOf(i - 1.0);
            }
            if (!(random.nextDouble() < i) || (partialResult = current.getOutput()) == null) continue;
            result.addAll(partialResult);
        }
        return result;
    }

    @Override
    public ArrayList<PotionChemical> getOutputRaw() {
        ArrayList<PotionChemical> result = super.getOutputRaw();
        for (MapKey currentKey : this.recipes.keySet()) {
            DecomposerRecipe current = DecomposerRecipe.get(currentKey);
            LogHelper.debug("getOutputRaw: " + currentKey);
            if (current == null) continue;
            int i = 0;
            while ((double)i < this.recipes.get(currentKey)) {
                ArrayList<PotionChemical> partialResult = current.getOutputRaw();
                if ((partialResult = MinechemUtil.pushTogetherChemicals(partialResult)) != null) {
                    result.addAll(partialResult);
                }
                ++i;
            }
        }
        return MinechemUtil.pushTogetherChemicals(result);
    }

    public ArrayList<PotionChemical> getGuaranteedOutput() {
        return super.getOutput();
    }

    @Override
    public boolean isNull() {
        return super.getOutput() == null || this.recipes == null;
    }

    @Override
    public ArrayList<PotionChemical> getPartialOutputRaw(int f) {
        return super.getPartialOutputRaw(f);
    }

    @Override
    public boolean hasOutput() {
        return !this.recipes.values().isEmpty() || !this.output.isEmpty();
    }

    @Override
    public boolean outputContains(PotionChemical potionChemical) {
        boolean contains = super.outputContains(potionChemical);
        if (!contains) {
            for (MapKey key : this.recipes.keySet()) {
                DecomposerRecipe dr = DecomposerRecipe.get(key);
                LogHelper.debug("outputContains: " + key);
                if (dr == null || !(contains = dr.outputContains(potionChemical))) continue;
                break;
            }
        }
        return contains;
    }

    @Override
    public float getChance() {
        float chances = 1.0f;
        for (Map.Entry<MapKey, Double> entry : this.recipes.entrySet()) {
            DecomposerRecipe dr = DecomposerRecipe.get(entry.getKey());
            if (dr == null) continue;
            chances = (float)((double)chances * ((double)dr.getChance() / entry.getValue()));
        }
        return chances;
    }
}

