/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.decomposer;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Iterator;
import minechem.Settings;
import minechem.api.IDecomposerControl;
import minechem.network.MessageHandler;
import minechem.network.message.DecomposerUpdateMessage;
import minechem.potion.PotionChemical;
import minechem.tileentity.decomposer.DecomposerFluidRecipe;
import minechem.tileentity.decomposer.DecomposerModel;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.tileentity.decomposer.DecomposerRecipeHandler;
import minechem.tileentity.prefab.BoundedInventory;
import minechem.tileentity.prefab.MinechemTileEntityElectric;
import minechem.utils.Compare;
import minechem.utils.MinechemUtil;
import minechem.utils.Transactor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class DecomposerTileEntity
extends MinechemTileEntityElectric
implements ISidedInventory,
IFluidHandler {
    public static final int[] inputSlots = new int[]{0};
    public static final int[] outputSlots = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    private ItemStack activeStack;
    public FluidStack tank = null;
    public int capacity = 5000;
    private final BoundedInventory inputInventory = new BoundedInventory(this, inputSlots);
    private final Transactor inputTransactor = new Transactor(this.inputInventory);
    public final int kInputSlot = 0;
    public final int kOutputSlotEnd = 9;
    public final int kOutputSlotStart = 1;
    public DecomposerModel model;
    private ArrayList<ItemStack> outputBuffer;
    private final BoundedInventory outputInventory = new BoundedInventory(this, outputSlots);
    private final Transactor outputTransactor = new Transactor(this.outputInventory);
    public State state = State.idle;
    public State oldState = State.idle;
    public boolean bufferChanged = false;
    public boolean tankUpdate = false;
    private static ItemStack cheatTankStack = new ItemStack(Blocks.field_150350_a);

    public DecomposerTileEntity() {
        super(Settings.maxDecomposerStorage);
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.outputBuffer = new ArrayList();
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.model = new DecomposerModel();
        }
    }

    private boolean addStackToOutputSlots(ItemStack itemstack) {
        ItemStack stackInSlot;
        for (int outputSlot : outputSlots) {
            stackInSlot = this.func_70301_a(outputSlot);
            if (stackInSlot == null || !Compare.stacksAreSameKind(stackInSlot, itemstack) || stackInSlot.field_77994_a + itemstack.field_77994_a > this.func_70297_j_()) continue;
            stackInSlot.field_77994_a += itemstack.field_77994_a;
            return true;
        }
        itemstack.func_77973_b().func_77622_d(itemstack, this.field_145850_b, null);
        for (int outputSlot : outputSlots) {
            stackInSlot = this.func_70301_a(outputSlot);
            if (stackInSlot != null) continue;
            this.func_70299_a(outputSlot, itemstack);
            return true;
        }
        return false;
    }

    private boolean canDecomposeInput() {
        ItemStack inputStack = this.func_70301_a(inputSlots[0]);
        DecomposerRecipe recipe = null;
        if (inputStack != null) {
            recipe = DecomposerRecipe.get(inputStack);
        } else if (this.tank != null && (recipe = DecomposerRecipe.get(this.tank)) != null && ((DecomposerFluidRecipe)recipe).inputFluid.amount > this.tank.amount) {
            return false;
        }
        return recipe != null;
    }

    private boolean energyToDecompose() {
        return this.getEnergyStored() >= Settings.costDecomposition || !Settings.powerUseEnabled;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        if (itemstack == null) {
            return false;
        }
        return DecomposerRecipeHandler.instance.getRecipe(itemstack) != null;
    }

    public void func_70305_f() {
    }

    private void decomposeActiveStack() {
        try {
            ArrayList<PotionChemical> output;
            ItemStack inputStack = this.getActiveStack();
            DecomposerRecipe recipe = inputStack == cheatTankStack ? DecomposerRecipe.get(this.tank) : DecomposerRecipe.get(inputStack);
            if (recipe != null && this.useEnergy(this.getEnergyNeeded()) && (output = recipe.getOutput()) != null) {
                ArrayList<ItemStack> stacks = MinechemUtil.convertChemicalsIntoItemStacks(this.getBrokenOutput(output, this.getDecompositionMultiplier(inputStack)));
                this.placeStacksInBuffer(stacks);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double getDecompositionMultiplier(ItemStack stack) {
        if (stack.func_77973_b() instanceof IDecomposerControl) {
            return ((IDecomposerControl)stack.func_77973_b()).getDecomposerMultiplier(stack);
        }
        if (!stack.func_77942_o()) {
            return 1.0;
        }
        if (stack.func_77978_p().func_150297_b("damage", 3)) {
            return 1.0 - (double)stack.func_77978_p().func_74762_e("damage") / 100.0;
        }
        if (stack.func_77978_p().func_150297_b("broken", 1)) {
            return stack.func_77978_p().func_74767_n("broken") ? 0.0 : 1.0;
        }
        return 1.0;
    }

    private ArrayList<PotionChemical> getBrokenOutput(ArrayList<PotionChemical> output, double mult) {
        if (mult == 1.0) {
            return output;
        }
        if (mult <= 0.0) {
            return new ArrayList<PotionChemical>();
        }
        ArrayList<PotionChemical> result = new ArrayList<PotionChemical>();
        for (PotionChemical chemical : output) {
            PotionChemical addChemical = chemical.copy();
            addChemical.amount = (int)((double)addChemical.amount * mult);
            result.add(addChemical);
        }
        return result;
    }

    private State determineOperationalState() {
        Iterator<ItemStack> i$ = this.outputBuffer.iterator();
        if (i$.hasNext()) {
            ItemStack outputStack = i$.next();
            if (this.addStackToOutputSlots(outputStack.func_77946_l().func_77979_a(1))) {
                outputStack.func_77979_a(1);
                if (outputStack.field_77994_a == 0) {
                    this.outputBuffer.remove(outputStack);
                }
                this.bufferChanged = true;
                return State.active;
            }
            return State.jammed;
        }
        return State.finished;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || this.tank == null || resource.amount <= 0 || !this.tank.isFluidEqual(resource)) {
            return null;
        }
        if (!doDrain) {
            return new FluidStack(this.tank.fluidID, Math.min(this.tank.amount, resource.amount));
        }
        int drained = Math.min(this.tank.amount, resource.amount);
        this.tankUpdate = true;
        this.tank.amount -= drained;
        return new FluidStack(this.tank.fluidID, drained);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.tank == null || maxDrain <= 0) {
            return null;
        }
        if (!doDrain) {
            return new FluidStack(this.tank.fluidID, Math.min(this.tank.amount, maxDrain));
        }
        int drained = Math.min(this.tank.amount, maxDrain);
        this.tankUpdate = true;
        this.tank.amount -= drained;
        return new FluidStack(this.tank.fluidID, drained);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || this.tank != null && !this.tank.isFluidEqual(resource)) {
            return 0;
        }
        if (!doFill) {
            if (this.tank == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!this.tank.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.tank.amount, resource.amount);
        }
        this.tankUpdate = true;
        if (this.tank == null) {
            int maxFill = Math.min(this.capacity, resource.amount);
            this.tank = new FluidStack(resource.fluidID, maxFill);
            return maxFill;
        }
        if (!this.tank.isFluidEqual(resource)) {
            return 0;
        }
        int maxFill = Math.min(this.capacity - this.tank.amount, resource.amount);
        this.tank.amount += maxFill;
        return maxFill;
    }

    public int[] func_94128_d(int var1) {
        if (var1 == 1) {
            return inputSlots;
        }
        return outputSlots;
    }

    private ItemStack getActiveStack() {
        if (this.activeStack == null) {
            if (this.func_70301_a(inputSlots[0]) != null) {
                this.activeStack = this.func_70298_a(inputSlots[0], 1);
                this.bufferChanged = true;
            } else if (this.tank != null) {
                DecomposerFluidRecipe fluidRecipe = (DecomposerFluidRecipe)DecomposerRecipe.get(this.tank);
                if (fluidRecipe != null && this.tank.amount >= fluidRecipe.inputFluid.amount) {
                    this.tank.amount -= fluidRecipe.inputFluid.amount;
                    this.tankUpdate = true;
                    this.activeStack = cheatTankStack;
                    return cheatTankStack;
                }
            } else {
                return null;
            }
        }
        return this.activeStack;
    }

    public String func_145825_b() {
        return "container.decomposer";
    }

    public int func_70302_i_() {
        return 10;
    }

    public int[] getSizeInventorySide(int side) {
        switch (side) {
            case 1: {
                return inputSlots;
            }
        }
        return outputSlots;
    }

    public State getState() {
        return this.state;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] result = new FluidTankInfo[]{new FluidTankInfo(this.tank, this.capacity)};
        return result;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean isFluidValidForDecomposer(Fluid fluid) {
        return DecomposerRecipe.get(new FluidStack(fluid, 1)) != null;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        DecomposerRecipe recipe;
        return i == inputSlots[0] && (recipe = DecomposerRecipeHandler.instance.getRecipe(itemstack)) != null;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    private void placeStacksInBuffer(ArrayList<ItemStack> outputStacks) {
        if (outputStacks != null) {
            this.outputBuffer = outputStacks;
        } else {
            this.state = State.finished;
        }
        this.pushQueue();
    }

    private void pushQueue() {
        block0: for (int i = this.inventory.length - 1; i > 0; --i) {
            if (i == 1 || this.inventory[i] == null) continue;
            for (int j = 1; j < i; ++j) {
                if (this.inventory[j] == null) {
                    this.func_70299_a(j, this.inventory[i]);
                    this.func_70299_a(i, null);
                    continue block0;
                }
                if (!Compare.stacksAreSameKind(this.inventory[j], this.inventory[i])) continue;
                int spaceLeft = this.inventory[j].func_77976_d() - this.inventory[j].field_77994_a;
                if (spaceLeft >= this.inventory[i].field_77994_a) {
                    this.inventory[j].field_77994_a += this.inventory[i].field_77994_a;
                    this.inventory[i] = null;
                    continue block0;
                }
                this.inventory[j].field_77994_a += spaceLeft;
                this.inventory[i].field_77994_a -= spaceLeft;
                continue block0;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList inventoryTagList = nbt.func_150295_c("inventory", 10);
        NBTTagList buffer = nbt.func_150295_c("buffer", 10);
        this.outputBuffer = MinechemUtil.readTagListToItemStackList(buffer);
        this.inventory = MinechemUtil.readTagListToItemStackArray(inventoryTagList, new ItemStack[this.func_70302_i_()]);
        if (nbt.func_74781_a("activeStack") != null) {
            NBTTagCompound activeStackCompound = (NBTTagCompound)nbt.func_74781_a("activeStack");
            this.activeStack = ItemStack.func_77949_a((NBTTagCompound)activeStackCompound);
        }
        this.tank = nbt.func_74764_b("tank") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("tank")) : null;
        this.state = State.values()[nbt.func_74771_c("state")];
    }

    @Override
    public int getEnergyNeeded() {
        return Settings.powerUseEnabled ? Settings.costDecomposition : 0;
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        ItemStack oldStack;
        if (slot == outputSlots[0] && (oldStack = this.inventory[outputSlots[0]]) != null && itemstack != null && oldStack.func_77960_j() == itemstack.func_77960_j() && oldStack.func_77973_b() == itemstack.func_77973_b() && oldStack.field_77994_a > itemstack.field_77994_a) {
            this.func_70298_a(slot, oldStack.field_77994_a - itemstack.field_77994_a);
        }
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.inventory[slot] = itemstack;
    }

    public void setState(int state) {
        this.state = State.values()[state];
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.state = this.determineOperationalState();
        if ((this.state == State.idle || this.state == State.finished) && this.energyToDecompose() && this.canDecomposeInput()) {
            this.activeStack = null;
            this.decomposeActiveStack();
            this.state = State.active;
        } else if (this.state == State.finished) {
            this.activeStack = null;
            this.state = State.idle;
        }
        if (this.bufferChanged || this.state != this.oldState) {
            this.func_70296_d();
            this.bufferChanged = false;
        }
        this.updateStateHandler();
    }

    public void updateStateHandler() {
        if (this.state != this.oldState || this.oldEnergyStored != this.getEnergyStored() || this.tankUpdate) {
            this.oldState = this.state;
            this.oldEnergyStored = this.getEnergyStored();
            this.tankUpdate = false;
            DecomposerUpdateMessage message = new DecomposerUpdateMessage(this);
            MessageHandler.INSTANCE.sendToAllAround((IMessage)message, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)Settings.UpdateRadius));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList inventoryTagList = MinechemUtil.writeItemStackArrayToTagList(this.inventory);
        NBTTagList buffer = MinechemUtil.writeItemStackListToTagList(this.outputBuffer);
        nbt.func_74782_a("inventory", (NBTBase)inventoryTagList);
        nbt.func_74782_a("buffer", (NBTBase)buffer);
        if (this.activeStack != null) {
            NBTTagCompound activeStackCompound = new NBTTagCompound();
            this.activeStack.func_77955_b(activeStackCompound);
            nbt.func_74782_a("activeStack", (NBTBase)activeStackCompound);
        }
        if (this.tank != null) {
            NBTTagCompound tankTag = new NBTTagCompound();
            this.tank.writeToNBT(tankTag);
            nbt.func_74782_a("tank", (NBTBase)tankTag);
        }
        nbt.func_74774_a("state", (byte)this.state.ordinal());
    }

    @Override
    public Packet func_145844_m() {
        this.func_145841_b(new NBTTagCompound());
        return MessageHandler.INSTANCE.getPacketFrom((IMessage)new DecomposerUpdateMessage(this));
    }

    public String getStateString() {
        return this.activeStack == null || DecomposerRecipe.get(this.activeStack) == null ? "No Recipe" : (this.energyToDecompose() ? "Active" : "No Power");
    }

    public void dumpFluid() {
        this.tank = null;
        if (this.field_145850_b.field_72995_K) {
            MessageHandler.INSTANCE.sendToServer((IMessage)new DecomposerUpdateMessage(this));
        }
    }

    public static enum State {
        idle,
        active,
        finished,
        jammed;

    }
}

