/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.multiblock.fusion;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import minechem.MinechemItemsRegistration;
import minechem.Settings;
import minechem.item.blueprint.BlueprintFusion;
import minechem.item.element.ElementEnum;
import minechem.item.element.ElementItem;
import minechem.network.MessageHandler;
import minechem.network.message.FusionUpdateMessage;
import minechem.tileentity.multiblock.MultiBlockTileEntity;
import minechem.utils.MinechemUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class FusionTileEntity
extends MultiBlockTileEntity
implements ISidedInventory {
    public static boolean canProcess = false;
    public static int fusedResult = 0;
    public static int inputLeft = 0;
    public static int inputRight = 1;
    public static int output = 2;

    public FusionTileEntity() {
        super(Settings.maxFusionStorage);
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.setBlueprint(new BlueprintFusion());
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return false;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        return false;
    }

    private void fuseInputs() {
        if (this.inventory[output] == null) {
            this.inventory[FusionTileEntity.output] = new ItemStack((Item)MinechemItemsRegistration.element, 1, fusedResult);
        } else if (this.inventory[output].func_77960_j() == fusedResult) {
            ++this.inventory[FusionTileEntity.output].field_77994_a;
        } else {
            canProcess = false;
        }
    }

    public int[] func_94128_d(int var1) {
        int[] slots = new int[]{inputLeft, inputRight, output};
        return slots;
    }

    public String func_145825_b() {
        return "container.minechemFusion";
    }

    public int func_70302_i_() {
        return 4;
    }

    public boolean inputsCanBeFused() {
        if (this.inventory[inputLeft] != null && this.inventory[inputRight] != null && this.inventory[inputLeft].func_77973_b() instanceof ElementItem && this.inventory[inputRight].func_77973_b() instanceof ElementItem) {
            int left = this.inventory[inputLeft].func_77960_j();
            int right = this.inventory[inputRight].func_77960_j();
            fusedResult = left + right;
            return left > 0 && right > 0 && ElementEnum.getByID(fusedResult) != null;
        }
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return (slot == inputLeft || slot == inputRight) && itemstack.func_77973_b() instanceof ElementItem;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.completeStructure;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        fusedResult = nbtTagCompound.func_74762_e("fusedResult");
        canProcess = nbtTagCompound.func_74767_n("canProcess");
        this.inventory = new ItemStack[this.func_70302_i_()];
        MinechemUtil.readTagListToItemStackArray(nbtTagCompound.func_150295_c("inventory", 10), this.inventory);
    }

    private void removeInputs() {
        this.func_70298_a(inputLeft, 1);
        this.func_70298_a(inputRight, 1);
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.completeStructure) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!canProcess && this.getEnergyNeeded() < this.getEnergyStored() && this.inputsCanBeFused() && this.canOutput()) {
                canProcess = true;
            }
            if (canProcess && this.useEnergy(this.getEnergyNeeded())) {
                this.fuseInputs();
                this.removeInputs();
                canProcess = false;
            } else {
                fusedResult = 0;
            }
            FusionUpdateMessage message = new FusionUpdateMessage(this);
            MessageHandler.INSTANCE.sendToAllAround((IMessage)message, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)Settings.UpdateRadius));
        }
    }

    public boolean canOutput() {
        if (this.inventory[output] == null) {
            return true;
        }
        if (this.inventory[output].func_77960_j() == fusedResult) {
            return this.inventory[FusionTileEntity.output].field_77994_a < 64;
        }
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("fusedResult", fusedResult);
        nbtTagCompound.func_74757_a("canProcess", canProcess);
        NBTTagList inventoryTagList = MinechemUtil.writeItemStackArrayToTagList(this.inventory);
        nbtTagCompound.func_74782_a("inventory", (NBTBase)inventoryTagList);
    }

    @Override
    public int getEnergyNeeded() {
        if (this.inventory[inputLeft] != null && this.inventory[inputRight] != null && this.inputsCanBeFused()) {
            return (this.inventory[inputLeft].func_77960_j() + this.inventory[inputRight].func_77960_j()) * Settings.fusionMultiplier;
        }
        return 0;
    }
}

