/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.synthesis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import minechem.Settings;
import minechem.potion.PotionChemical;
import minechem.utils.MapKey;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SynthesisRecipe {
    public static Map<MapKey, SynthesisRecipe> recipes = new HashMap<MapKey, SynthesisRecipe>();
    private ItemStack output;
    private PotionChemical[] shapedRecipe;
    private ArrayList<PotionChemical> unshapedRecipe = new ArrayList();
    private int energyCost;
    private boolean isShaped;

    public static SynthesisRecipe add(SynthesisRecipe recipe) {
        if (recipe.getOutput() != null && recipe.getOutput().func_77973_b() != null) {
            if (SynthesisRecipe.isBlacklisted(recipe.getOutput())) {
                return null;
            }
            MapKey key = MapKey.getKey(recipe.output);
            if (key != null && recipes.get(key) == null) {
                recipes.put(key, recipe);
            }
        }
        return recipe;
    }

    public static void createAndAddRecipeSafely(String item, boolean shaped, int energyCost, PotionChemical ... chemicals) {
        for (ItemStack i : OreDictionary.getOres((String)item)) {
            SynthesisRecipe.add(new SynthesisRecipe(new ItemStack(i.func_77973_b(), 1, i.func_77960_j()), shaped, energyCost, chemicals));
        }
    }

    public static void remove(ItemStack itemStack) {
        ArrayList<SynthesisRecipe> recipes = SynthesisRecipe.search(itemStack);
        for (SynthesisRecipe recipe : recipes) {
            SynthesisRecipe.recipes.remove(MapKey.getKey(recipe.output));
        }
    }

    public static void removeRecipeSafely(String item) {
        for (ItemStack i : OreDictionary.getOres((String)item)) {
            SynthesisRecipe.remove(i);
        }
    }

    public static SynthesisRecipe remove(String string) {
        if (recipes.containsKey(string)) {
            return recipes.remove(string);
        }
        return null;
    }

    public static ArrayList<SynthesisRecipe> search(ItemStack itemStack) {
        ArrayList<SynthesisRecipe> results = new ArrayList<SynthesisRecipe>();
        for (SynthesisRecipe recipe : recipes.values()) {
            if (!itemStack.func_77969_a(recipe.output)) continue;
            results.add(recipe);
        }
        return results;
    }

    public SynthesisRecipe(ItemStack output, boolean isShaped, int energyCost, PotionChemical ... recipe) {
        this.output = output;
        this.isShaped = isShaped;
        this.energyCost = energyCost;
        if (isShaped) {
            this.shapedRecipe = recipe;
        }
        this.unshapedRecipe = new ArrayList();
        for (PotionChemical chemical : recipe) {
            if (chemical == null) continue;
            this.unshapedRecipe.add(chemical);
        }
    }

    public SynthesisRecipe(ItemStack output, boolean shaped, int energyCost, ArrayList<PotionChemical> recipe) {
        this.output = output;
        this.isShaped = shaped;
        this.energyCost = energyCost;
        this.shapedRecipe = recipe.toArray(new PotionChemical[recipe.size()]);
        this.unshapedRecipe = recipe;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public boolean isShaped() {
        return this.isShaped;
    }

    public int energyCost() {
        return this.energyCost * Settings.synthesisMultiplier;
    }

    public PotionChemical[] getShapedRecipe() {
        return this.shapedRecipe;
    }

    public PotionChemical[] getShapelessRecipe() {
        return this.unshapedRecipe.toArray(new PotionChemical[this.unshapedRecipe.size()]);
    }

    public int getIngredientCount() {
        int var1 = 0;
        for (PotionChemical var3 : this.unshapedRecipe) {
            var1 += var3.amount;
        }
        return var1;
    }

    public static boolean isBlacklisted(ItemStack itemStack) {
        for (ItemStack stack : Settings.synthesisBlacklist) {
            if (stack.func_77973_b() != itemStack.func_77973_b() || stack.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != itemStack.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public static SynthesisRecipe get(MapKey key) {
        return recipes.get(key);
    }
}

