/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.synthesis;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import minechem.MinechemItemsRegistration;
import minechem.Settings;
import minechem.network.MessageHandler;
import minechem.network.message.SynthesisUpdateMessage;
import minechem.tileentity.prefab.BoundedInventory;
import minechem.tileentity.prefab.MinechemTileEntityElectric;
import minechem.tileentity.synthesis.SynthesisModel;
import minechem.tileentity.synthesis.SynthesisRecipe;
import minechem.tileentity.synthesis.SynthesisRecipeHandler;
import minechem.utils.Compare;
import minechem.utils.MinechemUtil;
import minechem.utils.Transactor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SynthesisTileEntity
extends MinechemTileEntityElectric
implements ISidedInventory {
    public static final int[] kOutput = new int[]{0};
    public static final int[] kRecipe = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static final int[] kStorage = new int[]{10, 11, 12, 13, 14, 15, 16, 17, 18};
    public static final int[] kJournal = new int[]{19};
    public static int[] kRealSlots;
    private SynthesisRecipe currentRecipe;
    public SynthesisModel model;
    public static final int kSizeStorage = 9;
    public static final int kStartOutput = 0;
    public static final int kStartRecipe = 1;
    public static final int kStartStorage = 10;
    public static final int kStartJournal = 19;
    private final BoundedInventory recipeMatrix = new BoundedInventory(this, kRecipe);
    private ItemStack[] oldRecipeArray = new ItemStack[9];
    private final BoundedInventory storageInventory = new BoundedInventory(this, kStorage);
    private final BoundedInventory outputInventory = new BoundedInventory(this, kOutput);
    private final BoundedInventory journalInventory = new BoundedInventory(this, kJournal);
    private final Transactor storageTransactor = new Transactor(this.storageInventory);
    private final Transactor outputTransactor = new Transactor(this.outputInventory);
    private final Transactor journalTransactor = new Transactor(this.journalInventory, 1);

    public SynthesisTileEntity() {
        super(Settings.maxSynthesizerStorage);
        this.inventory = new ItemStack[this.func_70302_i_()];
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int v : kStorage) {
            l.add(v);
        }
        for (int v : kJournal) {
            l.add(v);
        }
        kRealSlots = new int[l.size()];
        for (int idx = 0; idx < l.size(); ++idx) {
            SynthesisTileEntity.kRealSlots[idx] = (Integer)l.get(idx);
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.model = new SynthesisModel();
        }
    }

    public boolean canTakeOutputStack(boolean doTake) {
        return this.inventory[kOutput[0]] != null && this.hasEnoughPowerForCurrentRecipe() && this.takeStacksFromStorage(doTake);
    }

    public void clearRecipeMatrix() {
        for (int slot : kRecipe) {
            this.inventory[slot] = null;
        }
    }

    private boolean valueIn(int value, int[] arr) {
        if (arr == null) {
            return false;
        }
        for (int v : arr) {
            if (value != v) continue;
            return true;
        }
        return false;
    }

    public boolean isGhostOutputSlot(int slotId) {
        return this.valueIn(slotId, kOutput);
    }

    public boolean isGhostCraftingRecipeSlot(int slotId) {
        return this.valueIn(slotId, kRecipe);
    }

    public boolean isGhostSlot(int slotId) {
        return this.isGhostOutputSlot(slotId) || this.isGhostCraftingRecipeSlot(slotId);
    }

    public boolean isRealItemSlot(int slotId) {
        return !this.isGhostSlot(slotId);
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        if (slot == kJournal[0]) {
            this.clearRecipeMatrix();
        }
        if (this.inventory[slot] != null) {
            if (slot == kOutput[0]) {
                int toRemove = amount;
                ItemStack result = this.func_70301_a(slot).func_77946_l();
                while (toRemove > 0) {
                    if (!this.takeInputStacks()) {
                        result.field_77994_a = amount - toRemove;
                        return result;
                    }
                    if ((toRemove -= amount) >= 1) continue;
                    return result;
                }
                return null;
            }
            if (this.inventory[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack[] extractOutput(boolean doRemove, int maxItemCount) {
        if (this.currentRecipe == null || !this.takeStacksFromStorage(false) || !this.canAffordRecipe(this.currentRecipe)) {
            return null;
        }
        ItemStack outputStack = this.currentRecipe.getOutput().func_77946_l();
        ItemStack[] output = new ItemStack[]{outputStack};
        if (doRemove) {
            this.takeStacksFromStorage(true);
        }
        return output;
    }

    public SynthesisRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public int getFacing() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String func_145825_b() {
        return "container.synthesis";
    }

    public ItemStack[] getRecipeMatrixItems() {
        return this.recipeMatrix.copyInventoryToArray();
    }

    public int func_70302_i_() {
        return 20;
    }

    public boolean hasEnoughPowerForCurrentRecipe() {
        if (!Settings.powerUseEnabled) {
            return true;
        }
        if (this.currentRecipe != null) {
            return this.canAffordRecipe(this.currentRecipe);
        }
        return true;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        double dist = entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : dist <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList inventoryTagList = nbt.func_150295_c("inventory", 10);
        this.inventory = MinechemUtil.readTagListToItemStackArray(inventoryTagList, new ItemStack[this.func_70302_i_()]);
    }

    @Override
    public int getEnergyNeeded() {
        if (this.currentRecipe != null && Settings.powerUseEnabled) {
            return this.currentRecipe.energyCost();
        }
        return 0;
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        if (slot == kOutput[0] && this.func_70301_a(slot) != null) {
            if (itemstack == null) {
                this.func_70298_a(slot, 1);
                return;
            }
            if (this.func_70301_a(slot).func_77973_b() == itemstack.func_77973_b()) {
                this.func_70298_a(slot, itemstack.field_77994_a);
                return;
            }
        }
        super.func_70299_a(slot, itemstack);
        if (slot == kJournal[0] && itemstack != null) {
            this.onPutJournal(itemstack);
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean takeStacksFromStorage(boolean doTake) {
        if (this.currentRecipe == null || !this.hasEnoughPowerForCurrentRecipe()) {
            return false;
        }
        ItemStack[] ingredients = MinechemUtil.convertChemicalArrayIntoItemStackArray(this.currentRecipe.getShapelessRecipe());
        ItemStack[] storage = this.storageInventory.copyInventoryToArray();
        for (ItemStack ingredient : ingredients) {
            if (this.takeStackFromStorage(ingredient, storage)) continue;
            return false;
        }
        if (doTake) {
            this.storageInventory.setInventoryStacks(storage);
            this.useEnergy(this.currentRecipe.energyCost());
        }
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.updateHandler();
        }
        if (this.currentRecipe != null && this.inventory[kOutput[0]] == null) {
            this.inventory[SynthesisTileEntity.kOutput[0]] = this.currentRecipe.getOutput().func_77946_l();
        } else {
            this.updateRecipe();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.getRecipeResult();
    }

    public void updateHandler() {
        if (!Settings.powerUseEnabled) {
            return;
        }
        int energyStored = this.getEnergyStored();
        if (this.oldEnergyStored != energyStored) {
            this.oldEnergyStored = energyStored;
            SynthesisUpdateMessage message = new SynthesisUpdateMessage(this);
            MessageHandler.INSTANCE.sendToAllAround((IMessage)message, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)Settings.UpdateRadius));
        }
    }

    public void updateRecipe() {
        for (int i = 0; i < this.oldRecipeArray.length; ++i) {
            if (ItemStack.func_77989_b((ItemStack)this.recipeMatrix.func_70301_a(i), (ItemStack)this.oldRecipeArray[i])) continue;
            this.oldRecipeArray = this.recipeMatrix.copyInventoryToArray();
            this.getRecipeResult();
            return;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList inventoryTagList = MinechemUtil.writeItemStackArrayToTagList(this.inventory);
        nbt.func_74782_a("inventory", (NBTBase)inventoryTagList);
    }

    public boolean canAffordRecipe(SynthesisRecipe recipe) {
        return this.getEnergyStored() >= recipe.energyCost();
    }

    private boolean getRecipeResult() {
        ItemStack[] recipeMatrixItems = this.getRecipeMatrixItems();
        SynthesisRecipe recipe = SynthesisRecipeHandler.instance.getRecipeFromInput(recipeMatrixItems);
        if (recipe != null) {
            this.inventory[SynthesisTileEntity.kOutput[0]] = recipe.getOutput().func_77946_l();
            this.currentRecipe = recipe;
            return true;
        }
        this.inventory[SynthesisTileEntity.kOutput[0]] = null;
        this.currentRecipe = null;
        return false;
    }

    private void onPutJournal(ItemStack itemstack) {
        SynthesisRecipe recipe;
        ItemStack activeItem = MinechemItemsRegistration.journal.getActiveStack(itemstack);
        if (activeItem != null && (recipe = SynthesisRecipeHandler.instance.getRecipeFromOutput(activeItem)) != null) {
            this.setRecipe(recipe);
        }
    }

    private boolean takeStackFromStorage(ItemStack ingredient, ItemStack[] storage) {
        if (ingredient == null) {
            return true;
        }
        int ingredientAmountLeft = ingredient.field_77994_a;
        for (int slot = 0; slot < storage.length; ++slot) {
            ItemStack storageItem = storage[slot];
            if (storageItem == null || !Compare.stacksAreSameKind(storageItem, ingredient)) continue;
            int amountToTake = Math.min(storageItem.field_77994_a, ingredientAmountLeft);
            ingredientAmountLeft -= amountToTake;
            storageItem.field_77994_a -= amountToTake;
            if (storageItem.field_77994_a <= 0) {
                storage[slot] = null;
            }
            if (ingredientAmountLeft <= 0) break;
        }
        return ingredientAmountLeft == 0;
    }

    private boolean takeInputStacks() {
        if (this.takeStacksFromStorage(false)) {
            this.takeStacksFromStorage(true);
            return true;
        }
        return false;
    }

    public ItemStack getOutputTemplate() {
        ItemStack template = null;
        ItemStack outputStack = this.inventory[kOutput[0]];
        if (outputStack != null) {
            template = outputStack.func_77946_l();
            if (template.field_77994_a == 0) {
                template.field_77994_a = this.getCurrentRecipe().getOutput().field_77994_a;
            }
        }
        return template;
    }

    public List<ItemStack> getOutput(int amount) {
        if (this.currentRecipe == null) {
            return null;
        }
        ItemStack template = this.getOutputTemplate();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ItemStack initialStack = template.func_77946_l();
        initialStack.field_77994_a = 0;
        outputs.add(initialStack);
        while (this.canTakeOutputStack(false) && amount >= template.field_77994_a && this.takeInputStacks()) {
            ItemStack output = (ItemStack)outputs.get(outputs.size() - 1);
            if (output.field_77994_a + template.field_77994_a > output.func_77976_d()) {
                int leftOverStackSize = template.field_77994_a - (output.func_77976_d() - output.field_77994_a);
                output.field_77994_a = output.func_77976_d();
                if (leftOverStackSize > 0) {
                    ItemStack newOutput = template.func_77946_l();
                    newOutput.field_77994_a = leftOverStackSize;
                    outputs.add(newOutput);
                }
            } else {
                output.field_77994_a += template.field_77994_a;
            }
            this.func_70296_d();
            amount -= template.field_77994_a;
        }
        return outputs;
    }

    public void setRecipe(SynthesisRecipe recipe) {
        this.clearRecipeMatrix();
        if (recipe != null) {
            ItemStack[] ingredients = MinechemUtil.convertChemicalArrayIntoItemStackArray(recipe.isShaped() ? recipe.getShapedRecipe() : recipe.getShapelessRecipe());
            for (int i = 0; i < Math.min(kRecipe.length, ingredients.length); ++i) {
                this.inventory[SynthesisTileEntity.kRecipe[i]] = ingredients[i];
            }
        }
    }

    public int[] getSizeInventorySide(int side) {
        switch (side) {
            case 1: {
                return kStorage;
            }
        }
        return kOutput;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int[] func_94128_d(int var1) {
        if (var1 != 1 && this.takeStacksFromStorage(false)) {
            return kOutput;
        }
        return kStorage;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        return Settings.AllowAutomation && slot > 0 && side > 0 && (itemstack.func_77973_b() == MinechemItemsRegistration.element || itemstack.func_77973_b() == MinechemItemsRegistration.molecule);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return Settings.AllowAutomation && side == 0 && slot == 0 && this.canTakeOutputStack(false);
    }

    public String getState() {
        return this.canTakeOutputStack(false) ? "Active" : (this.inventory[kOutput[0]] == null ? "No Recipe" : (!this.hasEnoughPowerForCurrentRecipe() ? "No Power" : "Not Enough Ingredients"));
    }
}

