/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cpw.mods.fml.server.FMLServerHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import minechem.MinechemItemsRegistration;
import minechem.Settings;
import minechem.fluid.FluidElement;
import minechem.fluid.FluidHelper;
import minechem.fluid.FluidMolecule;
import minechem.item.MinechemChemicalType;
import minechem.item.element.Element;
import minechem.item.element.ElementEnum;
import minechem.item.element.ElementItem;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.item.molecule.MoleculeItem;
import minechem.potion.PotionChemical;
import minechem.utils.Compare;
import minechem.utils.LogHelper;
import minechem.utils.Position;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public final class MinechemUtil {
    public static final Random random = new Random();

    private MinechemUtil() {
    }

    public static ItemStack addItemToInventory(IInventory inventory, ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        int l = inventory.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) {
                int append = itemStack.field_77994_a > inventory.func_70297_j_() ? inventory.func_70297_j_() : itemStack.field_77994_a;
                ItemStack newStack = itemStack.func_77946_l();
                newStack.field_77994_a = append;
                inventory.func_70299_a(i, newStack);
                itemStack.field_77994_a -= append;
            } else if (stack.func_77973_b() == itemStack.func_77973_b() && stack.func_77960_j() == itemStack.func_77960_j()) {
                int free = inventory.func_70297_j_() - stack.field_77994_a;
                int append = itemStack.field_77994_a > free ? free : itemStack.field_77994_a;
                itemStack.field_77994_a -= append;
                stack.field_77994_a += append;
                inventory.func_70299_a(i, stack);
            }
            if (itemStack.field_77994_a > 0) continue;
            itemStack = null;
            break;
        }
        return itemStack;
    }

    public static void throwItemStack(World world, ItemStack itemStack, double x, double y, double z) {
        if (itemStack != null) {
            float f = random.nextFloat() * 0.8f + 0.1f;
            float f1 = random.nextFloat() * 0.8f + 0.1f;
            float f2 = random.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), itemStack);
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)random.nextGaussian() * f3;
            entityitem.field_70181_x = (float)random.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)random.nextGaussian() * f3;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static ItemStack createItemStack(MinechemChemicalType chemical, int amount) {
        ItemStack itemStack = null;
        if (chemical instanceof ElementEnum) {
            itemStack = ElementItem.createStackOf(ElementEnum.getByID(((ElementEnum)chemical).atomicNumber()), amount);
        } else if (chemical instanceof MoleculeEnum) {
            itemStack = new ItemStack((Item)MinechemItemsRegistration.molecule, amount, ((MoleculeEnum)chemical).id());
        }
        return itemStack;
    }

    public static boolean canDrain(World world, Block block, int x, int y, int z) {
        if ((block == Blocks.field_150355_j || block == Blocks.field_150358_i) && world.func_72805_g(x, y, z) == 0) {
            return true;
        }
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).canDrain(world, x, y, z);
        }
        return false;
    }

    public static MinechemChemicalType getChemical(Block block) {
        MinechemChemicalType chemical = null;
        if (block instanceof IFluidBlock) {
            Fluid fluid = ((IFluidBlock)block).getFluid();
            chemical = MinechemUtil.getChemical(fluid);
        } else if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            chemical = MoleculeEnum.water;
        }
        return chemical;
    }

    public static MinechemChemicalType getChemical(Fluid fluid) {
        if (fluid instanceof FluidElement) {
            return ((FluidElement)fluid).element;
        }
        if (fluid instanceof FluidMolecule) {
            return ((FluidMolecule)fluid).molecule;
        }
        if (fluid == FluidRegistry.WATER) {
            return MoleculeEnum.water;
        }
        return null;
    }

    public static ElementEnum getElement(Fluid fluid) {
        for (Map.Entry<ElementEnum, FluidElement> entry : FluidHelper.elements.entrySet()) {
            if (entry.getValue() != fluid) continue;
            return entry.getKey();
        }
        return null;
    }

    public static MoleculeEnum getMolecule(Fluid fluid) {
        for (Map.Entry<MoleculeEnum, FluidMolecule> entry : FluidHelper.molecules.entrySet()) {
            if (entry.getValue() != fluid) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Fluid getFluid(IFluidHandler te) {
        FluidTankInfo[] tanks = null;
        for (int i = 0; i < 6; ++i) {
            tanks = te.getTankInfo(ForgeDirection.getOrientation((int)i));
            if (tanks == null) continue;
            for (FluidTankInfo tank : tanks) {
                if (tank == null || tank.fluid == null) continue;
                return tank.fluid.getFluid();
            }
        }
        return null;
    }

    public static void scanForMoreStacks(ItemStack current, EntityPlayer player) {
        int getMore = 8 - current.field_77994_a;
        InventoryPlayer inventory = player.field_71071_by;
        int maxSlot = player.field_71071_by.func_70302_i_() - 4;
        int slot = 0;
        do {
            ItemStack slotStack;
            if (slot == inventory.field_70461_c || (slotStack = inventory.func_70301_a(slot)) == null || !slotStack.func_77969_a(current)) continue;
            ItemStack addStack = inventory.func_70298_a(slot, getMore);
            current.field_77994_a += addStack.field_77994_a;
            getMore -= addStack.field_77994_a;
        } while (getMore > 0 && ++slot < maxSlot);
    }

    public static void incPlayerInventory(ItemStack current, int inc, EntityPlayer player, ItemStack give) {
        if (inc < 0) {
            current.func_77979_a(-inc);
        } else if (inc > 0) {
            if (current.field_77994_a + inc <= current.func_77976_d()) {
                current.field_77994_a += inc;
            } else {
                int added = current.func_77976_d() - current.field_77994_a;
                current.field_77994_a = current.func_77976_d();
                ItemStack extraStack = current.func_77946_l();
                extraStack.field_77994_a = inc - added;
                if (!player.field_71071_by.func_70441_a(extraStack)) {
                    player.func_71019_a(extraStack, false);
                }
            }
        }
        if (!player.field_71071_by.func_70441_a(give)) {
            player.func_71019_a(give, false);
        }
    }

    public static Set<ItemStack> findItemStacks(IInventory inventory, Item item, int damage) {
        HashSet<ItemStack> stacks = new HashSet<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item || stack.func_77960_j() != damage) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static void removeStackInInventory(IInventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (stack != inventory.func_70301_a(i)) continue;
            inventory.func_70299_a(i, null);
            break;
        }
    }

    public static String subscriptNumbers(String string) {
        string = string.replace('0', '\u2080');
        string = string.replace('1', '\u2081');
        string = string.replace('2', '\u2082');
        string = string.replace('3', '\u2083');
        string = string.replace('4', '\u2084');
        string = string.replace('5', '\u2085');
        string = string.replace('6', '\u2086');
        string = string.replace('7', '\u2087');
        string = string.replace('8', '\u2088');
        string = string.replace('9', '\u2089');
        return string;
    }

    public static void addDisabledStacks(String[] stringInputs, ArrayList<ItemStack> decomposerBlacklist, ArrayList<String> ids) {
        for (String string : stringInputs) {
            int meta;
            if (string == null || string.equals("")) continue;
            String[] splitString = string.split(":");
            ArrayList<String> wildcardMatch = new ArrayList<String>();
            if (splitString.length < 2 || splitString.length > 3) {
                LogHelper.debug(string + " is an invalid blacklist input");
                continue;
            }
            if (splitString[0].equals("ore")) {
                String itemID = splitString[1];
                if (itemID.contains("*")) {
                    itemID = itemID.replaceAll("\\*", ".*");
                }
                Pattern itemPattern = Pattern.compile(itemID, 2);
                for (String item : OreDictionary.getOreNames()) {
                    if (!itemPattern.matcher(item).matches()) continue;
                    wildcardMatch.add(item);
                }
                if (wildcardMatch.isEmpty()) {
                    LogHelper.debug(splitString[1] + " has no matches in the OreDictionary");
                    continue;
                }
                for (String key : wildcardMatch) {
                    decomposerBlacklist.addAll(OreDictionary.getOres((String)key));
                }
                continue;
            }
            try {
                meta = splitString.length == 3 ? Integer.valueOf(splitString[2]) : Short.MAX_VALUE;
            }
            catch (NumberFormatException e) {
                if (splitString[2].equals("*")) {
                    meta = Short.MAX_VALUE;
                }
                LogHelper.debug(splitString[2] + " is an invalid damage value - defaulting to all values");
                meta = Short.MAX_VALUE;
            }
            String itemID = splitString[0] + ":" + splitString[1];
            if (itemID.contains("*")) {
                itemID = itemID.replaceAll("\\*", ".*");
            }
            Pattern itemPattern = Pattern.compile(itemID, 2);
            for (String item : ids) {
                if (!itemPattern.matcher(item).matches()) continue;
                wildcardMatch.add(item);
            }
            if (wildcardMatch.isEmpty()) {
                LogHelper.debug(string + " has no matches in the ItemRegistry");
                continue;
            }
            for (String key : wildcardMatch) {
                Object disable = GameData.getItemRegistry().func_82594_a(key);
                if (disable instanceof Item) {
                    decomposerBlacklist.add(new ItemStack((Item)disable, 1, meta));
                    continue;
                }
                if (!(disable instanceof Block)) continue;
                decomposerBlacklist.add(new ItemStack((Block)disable, 1, meta));
            }
        }
    }

    public static void populateBlacklists() {
        Settings.decomposerBlacklist = new ArrayList();
        Settings.synthesisBlacklist = new ArrayList();
        Settings.decomposerBlacklist.add(MinechemItemsRegistration.emptyTube);
        ArrayList<String> registeredItems = new ArrayList<String>();
        for (Object key : GameData.getItemRegistry().func_148742_b()) {
            registeredItems.add((String)key);
        }
        MinechemUtil.addDisabledStacks(Settings.DecomposerBlacklist, Settings.decomposerBlacklist, registeredItems);
        MinechemUtil.addDisabledStacks(Settings.SynthesisMachineBlacklist, Settings.synthesisBlacklist, registeredItems);
    }

    public static int getSplitStringHeight(FontRenderer fontRenderer, String string, int width) {
        List stringRows = fontRenderer.func_78271_c(string, width);
        return stringRows.size() * fontRenderer.field_78288_b;
    }

    public static float translateValue(float value, float leftMin, float leftMax, float rightMin, float rightMax) {
        float leftRange = leftMax - leftMin;
        float rightRange = rightMax - rightMin;
        float valueScaled = (value - leftMin) / leftRange;
        return rightMin + valueScaled * rightRange;
    }

    public static String getLocalString(String key) {
        return MinechemUtil.getLocalString(key, false);
    }

    public static String getLocalString(String key, boolean capitalize) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            String localString = StatCollector.func_74838_a((String)key);
            return capitalize ? MinechemUtil.capitalizeFully(localString.replaceAll("molecule\\.", "")) : localString;
        }
        return key;
    }

    public static String capitalizeFully(String input) {
        String[] splitString = input.split(" ");
        String result = "";
        for (int i = 0; i < splitString.length; ++i) {
            char[] digit = splitString[i].toCharArray();
            digit[0] = Character.toUpperCase(digit[0]);
            for (int j = 1; j < digit.length; ++j) {
                digit[j] = Character.toLowerCase(digit[j]);
            }
            result = result + new String(digit) + (i < splitString.length - 1 ? " " : "");
        }
        return result;
    }

    public static NBTTagList writeItemStackArrayToTagList(ItemStack[] itemstacks) {
        NBTTagList taglist = new NBTTagList();
        for (int slot = 0; slot < itemstacks.length; ++slot) {
            ItemStack itemstack = itemstacks[slot];
            if (itemstack == null) continue;
            NBTTagCompound itemstackCompound = new NBTTagCompound();
            itemstackCompound.func_74774_a("slot", (byte)slot);
            itemstack.func_77955_b(itemstackCompound);
            taglist.func_74742_a((NBTBase)itemstackCompound);
        }
        return taglist;
    }

    public static ItemStack[] readTagListToItemStackArray(NBTTagList taglist, ItemStack[] itemstacks) {
        for (int i = 0; i < taglist.func_74745_c(); ++i) {
            NBTTagCompound itemstackCompound = taglist.func_150305_b(i);
            byte slot = itemstackCompound.func_74771_c("slot");
            itemstacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemstackCompound);
        }
        return itemstacks;
    }

    public static NBTTagList writeItemStackListToTagList(ArrayList<ItemStack> list) {
        NBTTagList taglist = new NBTTagList();
        for (ItemStack itemstack : list) {
            NBTTagCompound itemstackCompound = new NBTTagCompound();
            itemstack.func_77955_b(itemstackCompound);
            taglist.func_74742_a((NBTBase)itemstackCompound);
        }
        return taglist;
    }

    public static ArrayList<ItemStack> readTagListToItemStackList(NBTTagList taglist) {
        ArrayList<ItemStack> itemlist = new ArrayList<ItemStack>();
        for (int i = 0; i < taglist.func_74745_c(); ++i) {
            NBTTagCompound itemstackCompound = taglist.func_150305_b(i);
            ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)itemstackCompound);
            itemlist.add(itemstack);
        }
        return itemlist;
    }

    public static ArrayList<ItemStack> convertChemicalsIntoItemStacks(ArrayList<PotionChemical> potionChemicals) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (potionChemicals != null && potionChemicals.size() > 0) {
            for (PotionChemical potionChemical : potionChemicals) {
                if (potionChemical instanceof Element && ((Element)potionChemical).element != null) {
                    stacks.add(new ItemStack((Item)MinechemItemsRegistration.element, potionChemical.amount, ((Element)potionChemical).element.atomicNumber()));
                    continue;
                }
                if (!(potionChemical instanceof Molecule) || ((Molecule)potionChemical).molecule == null) continue;
                stacks.add(new ItemStack((Item)MinechemItemsRegistration.molecule, potionChemical.amount, ((Molecule)potionChemical).molecule.id()));
            }
        }
        return stacks;
    }

    public static List<ItemStack> pushTogetherStacks(List<ItemStack> stacks) {
        block0: for (int i = stacks.size() - 1; i >= 0; --i) {
            if (stacks.get(i) == null) continue;
            for (int j = 0; j < i; ++j) {
                if (stacks.get(j) == null) {
                    stacks.set(j, stacks.get(i));
                    stacks.set(j, null);
                    continue block0;
                }
                if (!stacks.get(j).func_77969_a(stacks.get(i))) continue;
                stacks.get((int)j).field_77994_a += stacks.get((int)i).field_77994_a;
                stacks.set(i, null);
                continue block0;
            }
        }
        stacks.removeAll(Collections.singleton(null));
        return stacks;
    }

    public static ItemStack[] convertChemicalArrayIntoItemStackArray(PotionChemical[] chemicals) {
        if (chemicals == null) {
            return new ItemStack[0];
        }
        ItemStack[] stacks = new ItemStack[chemicals.length];
        for (int i = 0; i < chemicals.length; ++i) {
            PotionChemical potionChemical = chemicals[i];
            if (potionChemical instanceof Element) {
                stacks[i] = new ItemStack((Item)MinechemItemsRegistration.element, potionChemical.amount, ((Element)potionChemical).element.atomicNumber());
                continue;
            }
            if (!(potionChemical instanceof Molecule)) continue;
            stacks[i] = new ItemStack((Item)MinechemItemsRegistration.molecule, potionChemical.amount, ((Molecule)potionChemical).molecule.id());
        }
        return stacks;
    }

    public static ArrayList<PotionChemical> pushTogetherChemicals(ArrayList<PotionChemical> oldList) {
        ArrayList<PotionChemical> list = new ArrayList<PotionChemical>();
        for (PotionChemical chemical : oldList) {
            list.add(chemical.copy());
        }
        block1: for (int i = list.size() - 1; i >= 0; --i) {
            if (list.get(i) == null) continue;
            for (int j = 0; j < i; ++j) {
                if (list.get(j) == null) {
                    list.set(j, list.get(i));
                    list.set(j, null);
                    continue block1;
                }
                if (!list.get(j).sameAs(list.get(i))) continue;
                list.get((int)j).amount += list.get((int)i).amount;
                list.set(i, null);
                continue block1;
            }
        }
        list.removeAll(Collections.singleton(null));
        return list;
    }

    public static boolean itemStackMatchesChemical(ItemStack itemstack, PotionChemical potionChemical) {
        return MinechemUtil.itemStackMatchesChemical(itemstack, potionChemical, 1);
    }

    public static boolean itemStackMatchesChemical(ItemStack itemstack, PotionChemical potionChemical, int factor) {
        if (potionChemical instanceof Element && itemstack.func_77973_b() == MinechemItemsRegistration.element) {
            Element element = (Element)potionChemical;
            return itemstack.func_77960_j() == element.element.atomicNumber() && itemstack.field_77994_a >= element.amount * factor;
        }
        if (potionChemical instanceof Molecule && itemstack.func_77973_b() == MinechemItemsRegistration.molecule) {
            Molecule molecule = (Molecule)potionChemical;
            return itemstack.func_77960_j() == molecule.molecule.id() && itemstack.field_77994_a >= molecule.amount * factor;
        }
        return false;
    }

    public static ForgeDirection getDirectionFromFacing(int facing) {
        switch (facing) {
            case 0: {
                return ForgeDirection.SOUTH;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.EAST;
            }
        }
        return null;
    }

    public static IInventory getInventory(IInventory inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inv;
            Position pos = new Position(chest.field_145851_c, chest.field_145848_d, chest.field_145849_e);
            IInventory chest2 = null;
            TileEntity tile = MinechemUtil.getTile(chest.func_145831_w(), pos, ForgeDirection.WEST);
            if (tile instanceof TileEntityChest) {
                chest2 = (IInventory)tile;
            }
            if ((tile = MinechemUtil.getTile(chest.func_145831_w(), pos, ForgeDirection.EAST)) instanceof TileEntityChest) {
                chest2 = (IInventory)tile;
            }
            if ((tile = MinechemUtil.getTile(chest.func_145831_w(), pos, ForgeDirection.NORTH)) instanceof TileEntityChest) {
                chest2 = (IInventory)tile;
            }
            if ((tile = MinechemUtil.getTile(chest.func_145831_w(), pos, ForgeDirection.SOUTH)) instanceof TileEntityChest) {
                chest2 = (IInventory)tile;
            }
            if (chest2 != null) {
                return new InventoryLargeChest("", inv, chest2);
            }
        }
        return inv;
    }

    public static TileEntity getTile(World world, Position pos, ForgeDirection dir) {
        Position tmp = new Position(pos);
        tmp.orientation = dir;
        tmp.moveForwards(1.0);
        return world.func_147438_o((int)tmp.x, (int)tmp.y, (int)tmp.z);
    }

    @SideOnly(value=Side.SERVER)
    public static WorldServer getDimension(int dimensionID) {
        WorldServer[] worlds;
        for (WorldServer world : worlds = FMLServerHandler.instance().getServer().field_71305_c) {
            if (world.field_73011_w.field_76574_g != dimensionID) continue;
            return world;
        }
        return null;
    }

    public static String getChemicalName(PotionChemical potionChemical) {
        if (potionChemical instanceof Element) {
            return MinechemUtil.getLocalString(((Element)potionChemical).element.name(), true);
        }
        return MinechemUtil.getLocalString(((Molecule)potionChemical).molecule.name(), true);
    }

    public static ItemStack chemicalToItemStack(PotionChemical potionChemical, int amount) {
        if (potionChemical instanceof Element) {
            return new ItemStack((Item)MinechemItemsRegistration.element, amount, ((Element)potionChemical).element.atomicNumber());
        }
        if (potionChemical instanceof Molecule) {
            return new ItemStack((Item)MinechemItemsRegistration.molecule, amount, ((Molecule)potionChemical).molecule.id());
        }
        return null;
    }

    public static PotionChemical itemStackToChemical(ItemStack itemstack) {
        if (Compare.isStackAnElement(itemstack)) {
            if (itemstack.func_77960_j() == 0) {
                return null;
            }
            return new Element(ElementItem.getElement(itemstack), itemstack.field_77994_a);
        }
        if (Compare.isStackAMolecule(itemstack)) {
            return new Molecule(MoleculeItem.getMolecule(itemstack), itemstack.field_77994_a);
        }
        return null;
    }

    public static int getNumberOfDigits(int n) {
        return (int)(Math.log10(n) + 1.0);
    }

    public static void openURL(String url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(url));
        }
        catch (Throwable throwable) {
            LogHelper.debug("Couldn't open link: " + url);
        }
    }
}

