/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import net.minecraft.world.World;

public class SafeTimeTracker {
    private long lastMark = Long.MIN_VALUE;
    private long duration = -1L;

    public boolean markTimeIfDelay(World world, long delay) {
        if (world == null) {
            return false;
        }
        long currentTime = world.func_82737_E();
        if (currentTime < this.lastMark) {
            this.lastMark = currentTime;
            return false;
        }
        if (this.lastMark + delay <= currentTime) {
            this.duration = currentTime - this.lastMark;
            this.lastMark = currentTime;
            return true;
        }
        return false;
    }

    public long durationOfLastDelay() {
        return this.duration > 0L ? this.duration : 0L;
    }

    public void markTime(World world) {
        this.lastMark = world.func_82737_E();
    }
}

