/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import cofh.api.item.IAugmentItem;
import cofh.lib.util.position.Area;
import cofh.lib.util.position.BlockPosition;
import cofh.lib.util.position.IRotateableTile;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class HarvestAreaManager<T extends TileEntity> {
    private T _owner;
    private int _originX;
    private int _originY;
    private int _originZ;
    private ForgeDirection _originOrientation;
    private ForgeDirection _overrideDirection;
    private Area _harvestArea;
    private int _radius;
    private int _areaUp;
    private int _areaDown;
    private int _originOffsetX;
    private int _originOffsetY;
    private int _originOffsetZ;
    private List<BlockPosition> _harvestedBlocks;
    private int _currentBlock;
    private boolean _usesBlocks;
    private boolean _upgradeVertical;
    private int _upgradeLevel;
    private float _upgradeModifier;

    public HarvestAreaManager(T t, int n, int n2, int n3, float f, boolean bl) {
        this._owner = t;
        this._overrideDirection = ForgeDirection.UNKNOWN;
        this._radius = n;
        this._areaUp = n2;
        this._areaDown = n3;
        this._upgradeModifier = f;
        this._originX = ((TileEntity)t).field_145851_c;
        this._originY = ((TileEntity)t).field_145848_d;
        this._originZ = ((TileEntity)t).field_145849_e;
        this._originOrientation = ((IRotateableTile)t).getDirectionFacing();
        this._usesBlocks = bl;
        this._upgradeVertical = false;
    }

    public String toString() {
        return String.format("%s-> %s:%s:%s:%s", this._owner, this._upgradeLevel, this._usesBlocks, this._upgradeVertical, Float.valueOf(this._upgradeModifier));
    }

    public void setOriginOffset(int n, int n2, int n3) {
        this._originOffsetX = n;
        this._originOffsetY = n2;
        this._originOffsetZ = n3;
        this.checkRecalculate();
    }

    public Area getHarvestArea() {
        this.checkRecalculate();
        return this._harvestArea;
    }

    public int getOriginX() {
        return this._originX;
    }

    public int getOriginY() {
        return this._originY;
    }

    public int getOriginZ() {
        return this._originZ;
    }

    public int getRadius() {
        return this._radius + this._upgradeLevel;
    }

    public BlockPosition getNextBlock() {
        this.checkRecalculate();
        BlockPosition blockPosition = this._harvestedBlocks.get(this._currentBlock);
        ++this._currentBlock;
        if (this._currentBlock >= this._harvestedBlocks.size()) {
            this._currentBlock = 0;
        }
        return blockPosition;
    }

    public void rewindBlock() {
        --this._currentBlock;
        if (this._currentBlock < 0) {
            this._currentBlock = this._harvestedBlocks.size() - 1;
        }
    }

    public void setOverrideDirection(ForgeDirection forgeDirection) {
        this._overrideDirection = forgeDirection;
    }

    public void setUpgradeVertical(boolean bl) {
        this._upgradeVertical = bl;
    }

    public void setUpgradeLevel(int n) {
        this._upgradeLevel = n;
        this.recalculateArea();
    }

    public void setAreaUp(int n) {
        this._areaUp = n;
    }

    public void setAreaDown(int n) {
        this._areaDown = n;
    }

    public int getUpgradeLevel() {
        return this._upgradeLevel;
    }

    public Packet getUpgradePacket() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74768_a("_upgradeLevel", this._upgradeLevel);
        return new S35PacketUpdateTileEntity(((TileEntity)this._owner).field_145851_c, ((TileEntity)this._owner).field_145848_d, ((TileEntity)this._owner).field_145849_e, 255, nBTTagCompound);
    }

    public void updateUpgradeLevel(ItemStack itemStack) {
        IAugmentItem iAugmentItem;
        int n;
        if (itemStack == null) {
            if (this._upgradeLevel != 0) {
                this.setUpgradeLevel(0);
            }
            return;
        }
        int n2 = 0;
        if (itemStack.func_77973_b() instanceof IAugmentItem && (n = (iAugmentItem = (IAugmentItem)itemStack.func_77973_b()).getAugmentLevel(itemStack, "radius")) != 0) {
            n2 = (int)((float)n * this._upgradeModifier);
        }
        if (n2 != this._upgradeLevel) {
            this.setUpgradeLevel(n2);
        }
    }

    private void checkRecalculate() {
        if (this._harvestArea == null) {
            this.recalculateArea();
            return;
        }
        if (this._overrideDirection != ForgeDirection.UNKNOWN && this._originOrientation != this._overrideDirection || this._overrideDirection == ForgeDirection.UNKNOWN && this._originOrientation != ((IRotateableTile)this._owner).getDirectionFacing() || this._originX != ((TileEntity)this._owner).field_145851_c + this._originOffsetX || this._originY != ((TileEntity)this._owner).field_145848_d + this._originOffsetY || this._originZ != ((TileEntity)this._owner).field_145849_e + this._originOffsetZ) {
            this.recalculateArea();
        }
    }

    private void recalculateArea() {
        BlockPosition blockPosition = BlockPosition.fromRotateableTile(this._owner);
        if (this._overrideDirection != ForgeDirection.UNKNOWN) {
            blockPosition.orientation = this._overrideDirection;
        }
        this._originX = blockPosition.x + this._originOffsetX;
        this._originY = blockPosition.y + this._originOffsetY;
        this._originZ = blockPosition.z + this._originOffsetZ;
        this._originOrientation = blockPosition.orientation;
        int n = this._radius + this._upgradeLevel;
        int n2 = this._areaUp;
        int n3 = this._areaDown;
        if (blockPosition.orientation == ForgeDirection.UP || blockPosition.orientation == ForgeDirection.DOWN) {
            if (this._upgradeVertical) {
                if (blockPosition.orientation == ForgeDirection.UP) {
                    n2 += this._upgradeLevel * 2;
                } else {
                    n3 += this._upgradeLevel * 2;
                }
            }
            blockPosition.moveForwards(1);
        } else {
            blockPosition.moveForwards(n + 1);
        }
        blockPosition.x += this._originOffsetX;
        blockPosition.y += this._originOffsetY;
        blockPosition.z += this._originOffsetZ;
        this._harvestArea = new Area(blockPosition, n, n3, n2);
        if (this._usesBlocks) {
            this._harvestedBlocks = this._harvestArea.getPositionsBottomFirst();
        }
        this._currentBlock = 0;
    }
}

