/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.gui.client;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButtonManaged;
import cofh.lib.gui.element.ElementListBox;
import cofh.lib.gui.element.ElementSlider;
import cofh.lib.gui.element.listbox.IListBoxElement;
import cofh.lib.gui.element.listbox.SliderHorizontal;
import cofh.lib.gui.element.listbox.SliderVertical;
import cofh.lib.util.position.BlockPosition;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.MineFactoryReloadedClient;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetLogicCircuit;
import powercrystals.minefactoryreloaded.gui.control.ButtonLogicBufferSelect;
import powercrystals.minefactoryreloaded.gui.control.ButtonLogicPinSelect;
import powercrystals.minefactoryreloaded.gui.control.ListBoxElementCircuit;
import powercrystals.minefactoryreloaded.gui.control.LogicButtonType;
import powercrystals.minefactoryreloaded.net.Packets;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetLogic;

public class GuiRedNetLogic
extends GuiBase {
    private static final int pinOffset = 13;
    private TileEntityRedNetLogic _logic;
    private int _selectedCircuit;
    private ElementListBox _circuitList;
    private ElementSlider _circuitScrollV;
    private ElementSlider _circuitScrollH;
    private ButtonLogicBufferSelect[] _inputIOBufferButtons = new ButtonLogicBufferSelect[16];
    private ButtonLogicBufferSelect[] _outputIOBufferButtons = new ButtonLogicBufferSelect[16];
    private ButtonLogicPinSelect[] _inputIOPinButtons = new ButtonLogicPinSelect[16];
    private ButtonLogicPinSelect[] _outputIOPinButtons = new ButtonLogicPinSelect[16];
    private ElementButtonManaged _nextCircuit;
    private ElementButtonManaged _prevCircuit;
    private ElementButtonManaged _reinit;
    private ElementButtonManaged _reinitConfirm;
    private boolean _listNeedsUpdated = true;
    private int _reinitCountdown;

    public GuiRedNetLogic(Container container, TileEntityRedNetLogic tileEntityRedNetLogic) {
        super(container, new ResourceLocation("minefactoryreloaded:textures/gui/rednetlogic.png"));
        ((GuiContainer)this).field_146999_f = 384;
        ((GuiContainer)this).field_147000_g = 231;
        this.drawInventory = false;
        this._logic = tileEntityRedNetLogic;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this._circuitList = new ElementListBox(this, 86, 17, 131, 198){

            protected void onSelectionChanged(int n, IListBoxElement iListBoxElement) {
            }

            protected void onElementClicked(IListBoxElement iListBoxElement) {
                Packets.sendToServer((short)7, GuiRedNetLogic.this._logic, GuiRedNetLogic.this._selectedCircuit, iListBoxElement.getValue().getClass().getName());
            }

            protected void onScrollV(int n) {
                GuiRedNetLogic.this._circuitScrollV.setValue(n);
            }

            protected void onScrollH(int n) {
                GuiRedNetLogic.this._circuitScrollH.setValue(n);
            }
        };
        LinkedList<IRedNetLogicCircuit> linkedList = new LinkedList<IRedNetLogicCircuit>(MFRRegistry.getRedNetLogicCircuits());
        Collections.sort(linkedList, new CircuitComparator());
        for (IRedNetLogicCircuit iRedNetLogicCircuit : linkedList) {
            this._circuitList.add((IListBoxElement)new ListBoxElementCircuit(iRedNetLogicCircuit));
        }
        this.addElement((ElementBase)this._circuitList);
        this._circuitScrollV = new SliderVertical(this, 218, 17, 10, 198, this._circuitList.getLastScrollPosition()){

            public void onValueChanged(int n) {
                GuiRedNetLogic.this._circuitList.scrollToV(n);
            }
        };
        this.addElement((ElementBase)this._circuitScrollV);
        this._circuitScrollH = new SliderHorizontal(this, 86, 215, 142, 10, this._circuitList.getLastScrollPositionH()){

            public void onValueChanged(int n) {
                GuiRedNetLogic.this._circuitList.scrollToH(n);
            }
        };
        this.addElement((ElementBase)this._circuitScrollH);
        this._prevCircuit = new ElementButtonManaged(this, 344, 16, 30, 30, "Prev"){

            public void onClick() {
                GuiRedNetLogic.this._selectedCircuit--;
                if (GuiRedNetLogic.this._selectedCircuit < 0) {
                    GuiRedNetLogic.this._selectedCircuit = GuiRedNetLogic.this._logic.getCircuitCount() - 1;
                }
                MineFactoryReloadedClient.prcPages.put(new BlockPosition((TileEntity)GuiRedNetLogic.this._logic), GuiRedNetLogic.this._selectedCircuit);
                GuiRedNetLogic.this.requestCircuit();
                GuiRedNetLogic.this._listNeedsUpdated = true;
            }
        };
        this._nextCircuit = new ElementButtonManaged(this, 344, 76, 30, 30, "Next"){

            public void onClick() {
                GuiRedNetLogic.this._selectedCircuit++;
                if (GuiRedNetLogic.this._selectedCircuit >= GuiRedNetLogic.this._logic.getCircuitCount()) {
                    GuiRedNetLogic.this._selectedCircuit = 0;
                }
                MineFactoryReloadedClient.prcPages.put(new BlockPosition((TileEntity)GuiRedNetLogic.this._logic), GuiRedNetLogic.this._selectedCircuit);
                GuiRedNetLogic.this.requestCircuit();
                GuiRedNetLogic.this._listNeedsUpdated = true;
            }
        };
        this.addElement((ElementBase)this._prevCircuit);
        this.addElement((ElementBase)this._nextCircuit);
        this._reinit = new ElementButtonManaged(this, 316, 205, 60, 20, "Reinitialize"){

            public void onClick() {
                GuiRedNetLogic.this._reinitCountdown = 55;
            }
        };
        this._reinitConfirm = new ElementButtonManaged(this, 316, 205, 60, 20, "Confirm"){

            public boolean isEnabled() {
                return super.isEnabled() && GuiRedNetLogic.this._reinitCountdown < 25;
            }

            public void onClick() {
                Packets.sendToServer((short)9, GuiRedNetLogic.this._logic, Minecraft.func_71410_x().field_71439_g.func_145782_y());
                GuiRedNetLogic.this._reinitCountdown = 0;
                GuiRedNetLogic.this._listNeedsUpdated = true;
            }
        };
        this.addElement((ElementBase)this._reinit);
        this.addElement((ElementBase)this._reinitConfirm);
        this._reinitConfirm.setVisible(false);
        int n = this._logic.func_145831_w().func_72805_g(this._logic.field_145851_c, this._logic.field_145848_d, this._logic.field_145849_e);
        for (int i = 0; i < this._inputIOPinButtons.length; ++i) {
            this._inputIOBufferButtons[i] = new ButtonLogicBufferSelect(this, 23, 16 + i * 13, i, LogicButtonType.Input, n);
            this._inputIOPinButtons[i] = new ButtonLogicPinSelect(this, 52, 16 + i * 13, i, LogicButtonType.Input);
            this._outputIOBufferButtons[i] = new ButtonLogicBufferSelect(this, 255, 16 + i * 13, i, LogicButtonType.Output, n);
            this._outputIOPinButtons[i] = new ButtonLogicPinSelect(this, 284, 16 + i * 13, i, LogicButtonType.Output);
            this.addElement(this._inputIOBufferButtons[i].setVisible(false));
            this.addElement(this._outputIOBufferButtons[i].setVisible(false));
            this.addElement(this._inputIOPinButtons[i].setVisible(false));
            this.addElement(this._outputIOPinButtons[i].setVisible(false));
        }
        Integer n2 = MineFactoryReloadedClient.prcPages.get(new BlockPosition((TileEntity)this._logic));
        if (n2 != null && n2 < this._logic.getCircuitCount()) {
            this._selectedCircuit = n2;
        }
        this.requestCircuit();
    }

    public void updateElementInformation() {
        IRedNetLogicCircuit iRedNetLogicCircuit = this._logic.getLastCircuit(this._selectedCircuit);
        if (iRedNetLogicCircuit != null && iRedNetLogicCircuit != this._logic.getCircuit(this._selectedCircuit)) {
            int n;
            if (this._listNeedsUpdated) {
                for (n = 0; n < this._circuitList.getElementCount(); ++n) {
                    if (((IRedNetLogicCircuit)this._circuitList.getElement(n).getValue()).getClass() != this._logic.getCircuit(this._selectedCircuit).getClass()) continue;
                    this._circuitList.setSelectedIndex(n);
                    this._circuitScrollV.setValue(Math.min(n, this._circuitList.getLastScrollPosition()));
                    break;
                }
                this._listNeedsUpdated = false;
            }
            for (n = 0; n < this._inputIOPinButtons.length; ++n) {
                if (n < this._logic.getCircuit(this._selectedCircuit).getInputCount()) {
                    this._inputIOPinButtons[n].setVisible(true);
                    this._inputIOBufferButtons[n].setVisible(true);
                    this._inputIOPinButtons[n].setPin(this._logic.getInputPinMapping((int)this._selectedCircuit, (int)n).pin);
                    this._inputIOPinButtons[n].setBuffer(this._logic.getInputPinMapping((int)this._selectedCircuit, (int)n).buffer);
                    this._inputIOBufferButtons[n].setBuffer(this._logic.getInputPinMapping((int)this._selectedCircuit, (int)n).buffer);
                    continue;
                }
                this._inputIOBufferButtons[n].setVisible(false);
                this._inputIOPinButtons[n].setVisible(false);
            }
            for (n = 0; n < this._outputIOPinButtons.length; ++n) {
                if (n < this._logic.getCircuit(this._selectedCircuit).getOutputCount()) {
                    this._outputIOBufferButtons[n].setVisible(true);
                    this._outputIOPinButtons[n].setVisible(true);
                    this._outputIOPinButtons[n].setPin(this._logic.getOutputPinMapping((int)this._selectedCircuit, (int)n).pin);
                    this._outputIOPinButtons[n].setBuffer(this._logic.getOutputPinMapping((int)this._selectedCircuit, (int)n).buffer);
                    this._outputIOBufferButtons[n].setBuffer(this._logic.getOutputPinMapping((int)this._selectedCircuit, (int)n).buffer);
                    continue;
                }
                this._outputIOBufferButtons[n].setVisible(false);
                this._outputIOPinButtons[n].setVisible(false);
            }
        }
        if (this._reinitCountdown > 0) {
            --this._reinitCountdown;
        }
        this._reinit.setVisible(this._reinitCountdown == 0);
        this._reinitConfirm.setVisible(this._reinitCountdown > 0);
    }

    protected void func_146979_b(int n, int n2) {
        int n3;
        super.func_146979_b(n, n2);
        ((GuiScreen)this).field_146289_q.func_78276_b("Programmable RedNet Controller", 8, 6, 0x404040);
        ((GuiScreen)this).field_146289_q.func_78276_b(this._selectedCircuit + 1 + " of " + this._logic.getCircuitCount(), 336, 60, 0x404040);
        for (n3 = 0; n3 < this._inputIOPinButtons.length; ++n3) {
            if (n3 >= this._logic.getCircuit(this._selectedCircuit).getInputCount()) continue;
            ((GuiScreen)this).field_146289_q.func_78276_b(this._logic.getCircuit(this._selectedCircuit).getInputPinLabel(n3), 4, 20 + n3 * 13, 0x404040);
        }
        for (n3 = 0; n3 < this._outputIOPinButtons.length; ++n3) {
            if (n3 >= this._logic.getCircuit(this._selectedCircuit).getOutputCount()) continue;
            ((GuiScreen)this).field_146289_q.func_78276_b(this._logic.getCircuit(this._selectedCircuit).getOutputPinLabel(n3), 232, 20 + n3 * 13, 0x404040);
        }
    }

    protected void func_146976_a(float f, int n, int n2) {
        this.mouseX = n - ((GuiContainer)this).field_147003_i;
        this.mouseY = n2 - ((GuiContainer)this).field_147009_r;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture);
        this.drawLargeTexturedModalRect(((GuiContainer)this).field_147003_i, ((GuiContainer)this).field_147009_r, 0, 0, ((GuiContainer)this).field_146999_f, ((GuiContainer)this).field_147000_g);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((GuiContainer)this).field_147003_i, (float)((GuiContainer)this).field_147009_r, (float)0.0f);
        this.drawElements(f, false);
        this.drawTabs(f, false);
        GL11.glPopMatrix();
    }

    public void drawLargeTexturedModalRect(int n, int n2, int n3, int n4, int n5, int n6) {
        float f = 0.0026041667f;
        float f2 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(n + 0), (double)(n2 + n6), (double)((Gui)this).field_73735_i, (double)((float)(n3 + 0) * f), (double)((float)(n4 + n6) * f2));
        tessellator.func_78374_a((double)(n + n5), (double)(n2 + n6), (double)((Gui)this).field_73735_i, (double)((float)(n3 + n5) * f), (double)((float)(n4 + n6) * f2));
        tessellator.func_78374_a((double)(n + n5), (double)(n2 + 0), (double)((Gui)this).field_73735_i, (double)((float)(n3 + n5) * f), (double)((float)(n4 + 0) * f2));
        tessellator.func_78374_a((double)(n + 0), (double)(n2 + 0), (double)((Gui)this).field_73735_i, (double)((float)(n3 + 0) * f), (double)((float)(n4 + 0) * f2));
        tessellator.func_78381_a();
    }

    public TileEntityRedNetLogic.PinMapping getInputPin(int n) {
        return this._logic.getInputPinMapping(this._selectedCircuit, n);
    }

    public TileEntityRedNetLogic.PinMapping getOutputPin(int n) {
        return this._logic.getOutputPinMapping(this._selectedCircuit, n);
    }

    private void requestCircuit() {
        Packets.sendToServer((short)6, this._logic, this._selectedCircuit);
    }

    public void setInputPinMapping(int n, int n2, int n3) {
        Packets.sendToServer((short)8, this._logic, (byte)0, this._selectedCircuit, n, n2, n3);
    }

    public void setOutputPinMapping(int n, int n2, int n3) {
        Packets.sendToServer((short)8, this._logic, (byte)1, this._selectedCircuit, n, n2, n3);
    }

    public int getVariableCount() {
        return this._logic.getVariableBufferSize();
    }

    private class CircuitComparator
    implements Comparator<IRedNetLogicCircuit> {
        private CircuitComparator() {
        }

        @Override
        public int compare(IRedNetLogicCircuit iRedNetLogicCircuit, IRedNetLogicCircuit iRedNetLogicCircuit2) {
            return StatCollector.func_74838_a((String)iRedNetLogicCircuit.getUnlocalizedName()).compareTo(StatCollector.func_74838_a((String)iRedNetLogicCircuit2.getUnlocalizedName()));
        }
    }
}

