/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.thaumcraft;

import cofh.asm.relauncher.Strippable;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableCocoa;
import powercrystals.minefactoryreloaded.farmables.fruits.FruitCocoa;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableCocoa;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStandard;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableWood;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableCocoa;
import powercrystals.minefactoryreloaded.modhelpers.thaumcraft.FertilizableTCSapling;
import powercrystals.minefactoryreloaded.modhelpers.thaumcraft.HarvestableThaumcraftLeaves;
import powercrystals.minefactoryreloaded.modhelpers.thaumcraft.HarvestableThaumcraftPlant;
import powercrystals.minefactoryreloaded.modhelpers.thaumcraft.PlantableThaumcraftTree;
import powercrystals.minefactoryreloaded.modhelpers.thaumcraft.SpawnablePech;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.setup.Machine;

@Mod(modid="MineFactoryReloaded|CompatThaumcraft", name="MFR Compat: Thaumcraft", version="1.7.10R2.8.0RC6", dependencies="after:MineFactoryReloaded;after:Thaumcraft", customProperties={@Mod.CustomProperty(k="cofhversion", v="true")})
public class Thaumcraft {
    private static LinkedHashMap<String, ? extends Object> aspects = null;
    private static Method registerItem = null;
    private static Method registerEntity = null;
    private static Class<?> AspectList = null;
    private static Constructor<?> newAspectList = null;
    private static Method addAspect = null;

    @Mod.EventHandler
    @Strippable(value={"mod:Thaumcraft"})
    public static void load(FMLInitializationEvent fMLInitializationEvent) {
        try {
            Block block = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockCustomPlant");
            final Block block2 = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockMagicalLog");
            Block block3 = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockMagicalLeaves");
            Block block4 = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockTaintFibres");
            Block block5 = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockManaPod");
            Item item = GameRegistry.findItem((String)"Thaumcraft", (String)"ItemManaBean");
            Class<?> clazz = Class.forName("thaumcraft.common.entities.golems.EntityGolemBase");
            Class<?> clazz2 = Class.forName("thaumcraft.common.entities.golems.EntityTravelingTrunk");
            Class<?> clazz3 = Class.forName("thaumcraft.common.entities.monster.EntityPech");
            MFRRegistry.registerAutoSpawnerBlacklistClass(clazz);
            MFRRegistry.registerAutoSpawnerBlacklistClass(clazz2);
            MFRRegistry.registerSpawnHandler(new SpawnablePech(clazz3));
            MFRRegistry.registerGrinderBlacklist(clazz);
            MFRRegistry.registerGrinderBlacklist(clazz2);
            if (MFRConfig.conveyorNeverCapturesTCGolems.getBoolean(false)) {
                MFRRegistry.registerConveyerBlacklist(clazz);
                MFRRegistry.registerConveyerBlacklist(clazz2);
            }
            MFRRegistry.registerHarvestable(new HarvestableWood(block2));
            MFRRegistry.registerHarvestable(new HarvestableStandard(block4, HarvestType.Normal));
            MFRRegistry.registerHarvestable(new HarvestableThaumcraftLeaves(block3, Item.func_150898_a((Block)block)));
            MFRRegistry.registerHarvestable(new HarvestableThaumcraftPlant(block));
            MFRRegistry.registerHarvestable(new HarvestableCocoa(block5));
            MFRRegistry.registerPlantable(new PlantableThaumcraftTree(block));
            MFRRegistry.registerPlantable(new PlantableCocoa(item, block5){

                @Override
                protected boolean isNextToAcceptableLog(World world, int n, int n2, int n3) {
                    boolean bl = false;
                    BiomeGenBase biomeGenBase = world.func_72807_a(n, n3);
                    if (biomeGenBase != null) {
                        bl = BiomeDictionary.isBiomeOfType((BiomeGenBase)biomeGenBase, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL);
                    }
                    return bl && this.isGoodLog(world, n + 1, n2, n3) || this.isGoodLog(world, n - 1, n2, n3) || this.isGoodLog(world, n, n2, n3 + 1) || this.isGoodLog(world, n, n2, n3 - 1);
                }

                @Override
                protected boolean isGoodLog(World world, int n, int n2, int n3) {
                    Block block = world.func_147439_a(n, n2, n3);
                    return block == block2 || block.equals(Blocks.field_150364_r);
                }
            });
            MFRRegistry.registerFruitLogBlock(block2);
            MFRRegistry.registerFruit(new FruitCocoa(block5));
            MFRRegistry.registerFertilizable(new FertilizableCocoa(block5, FertilizerType.GrowMagicalCrop));
            MFRRegistry.registerFertilizable(new FertilizableTCSapling(block));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Mod.EventHandler
    @Strippable(value={"api:Thaumcraft|API"})
    public static void load(FMLPostInitializationEvent fMLPostInitializationEvent) {
        try {
            Class<?> clazz = Class.forName("thaumcraft.api.aspects.Aspect");
            aspects = (LinkedHashMap)clazz.getDeclaredField("aspects").get(null);
            Class<?> clazz2 = Class.forName("thaumcraft.api.ThaumcraftApi");
            AspectList = Class.forName("thaumcraft.api.aspects.AspectList");
            registerItem = clazz2.getDeclaredMethod("registerObjectTag", ItemStack.class, AspectList);
            Class<?> clazz3 = Class.forName("[Lthaumcraft.api.ThaumcraftApi$EntityTagsNBT;");
            registerEntity = clazz2.getDeclaredMethod("registerEntityTag", String.class, AspectList, clazz3);
            addAspect = AspectList.getDeclaredMethod("add", clazz, Integer.TYPE);
            newAspectList = AspectList.getDeclaredConstructor(ItemStack.class);
            Thaumcraft.doAspects();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void parseAspects(ItemStack itemStack, String string, boolean bl) throws Throwable {
        Object obj = bl ? newAspectList.newInstance(itemStack) : AspectList.newInstance();
        if (!string.trim().isEmpty()) {
            String[] stringArray = string.split(",");
            int n = stringArray.length;
            while (n-- > 0) {
                String[] stringArray2 = stringArray[n].trim().split(" ");
                if (aspects.containsKey(stringArray2[1])) {
                    addAspect.invoke(obj, aspects.get(stringArray2[1]), Integer.parseInt(stringArray2[0], 10));
                    continue;
                }
                FMLLog.severe((String)"%s aspect missing.", (Object[])new Object[]{stringArray2[1]});
            }
        }
        registerItem.invoke(null, itemStack, obj);
    }

    private static void parseAspects(String string, String string2) throws Throwable {
        String[] stringArray = string2.split(",");
        Object obj = AspectList.newInstance();
        int n = stringArray.length;
        while (n-- > 0) {
            String[] stringArray2 = stringArray[n].trim().split(" ");
            if (!aspects.containsKey(stringArray2[1])) continue;
            addAspect.invoke(obj, aspects.get(stringArray2[1]), Integer.parseInt(stringArray2[0], 10));
        }
        registerEntity.invoke(null, string, obj, null);
    }

    private static void parseAspects(Item item, String string) throws Throwable {
        Thaumcraft.parseAspects(item, Short.MAX_VALUE, string, true);
    }

    private static void parseAspects(Item item, int n, String string) throws Throwable {
        Thaumcraft.parseAspects(item, n, string, true);
    }

    private static void parseAspects(Item item, int n, String string, boolean bl) throws Throwable {
        Thaumcraft.parseAspects(new ItemStack(item, 1, n), string, bl);
    }

    private static void parseAspects(Block block, int n, String string) throws Throwable {
        Thaumcraft.parseAspects(new ItemStack(block, 1, n), string, true);
    }

    private static void parseAspects(Block block, String string) throws Throwable {
        Thaumcraft.parseAspects(block, Short.MAX_VALUE, string);
    }

    private static void parseAspects(Block block, int n, String string, boolean bl) throws Throwable {
        Thaumcraft.parseAspects(new ItemStack(block, 1, n), string, bl);
    }

    private static void parseAspects(Block block, String string, boolean bl) throws Throwable {
        Thaumcraft.parseAspects(block, Short.MAX_VALUE, string, bl);
    }

    private static void parseAspects(Machine machine, String string) throws Throwable {
        Thaumcraft.parseAspects(new ItemStack(machine.getBlock(), 1, machine.getMeta()), string, true);
    }

    private static void doAspects() throws Throwable {
        Thaumcraft.parseAspects(Machine.AutoAnvil, "3 permutatio, 5 fabrico, 10 metallum, 5 machina");
        Thaumcraft.parseAspects(Machine.AutoBrewer, "4 ignis, 2 fabrico, 2 aqua, 2 praecantatio, 5 machina");
        Thaumcraft.parseAspects(Machine.AutoDisenchanter, "4 praecantatio, 4 permutatio, 5 machina");
        Thaumcraft.parseAspects(Machine.AutoEnchanter, "8 praecantatio, 4 cognitio, 4 fabrico, 5 machina");
        Thaumcraft.parseAspects(Machine.AutoJukebox, "4 sensus, 4 aer, 5 machina");
        Thaumcraft.parseAspects(Machine.AutoSpawner, "4 bestia, 4 exanimis, 7 praecantatio, 4 alienis, 5 machina, 10 permutatio");
        Thaumcraft.parseAspects(Machine.BioFuelGenerator, "15 potentia, 3 herba, 5 machina, 3 permutatio");
        Thaumcraft.parseAspects(Machine.BioReactor, "4 herba, 2 potentia, 5 machina, 5 permutatio");
        Thaumcraft.parseAspects(Machine.BlockBreaker, "15 perfodio, 5 machina, 5 metallum, 3 lucrum");
        Thaumcraft.parseAspects(Machine.BlockPlacer, "1 motus, 1 ordo, 5 machina, 5 metallum, 3 lucrum");
        Thaumcraft.parseAspects(Machine.BlockSmasher, "5 perditio, 5 machina, 3 permutatio, 3 praecantatio");
        Thaumcraft.parseAspects(Machine.Breeder, "2 bestia, 2 fames, 5 machina");
        Thaumcraft.parseAspects(Machine.Chronotyper, "3 tempus, 3 bestia, 5 machina, 3 sensus");
        Thaumcraft.parseAspects(Machine.ChunkLoader, "100 potentia, 30 alienis, 20 praecantatio, 10 iter, 10 vacuos, 5 machina, 5 instrumentum");
        Thaumcraft.parseAspects(Machine.Composter, "2 bestia, 2 aqua, 5 machina");
        Thaumcraft.parseAspects(Machine.DeepStorageUnit, "4971027 vacuos, 5 machina, 15 alienis, 1 praecantatio");
        Thaumcraft.parseAspects(Machine.Ejector, "4 motus, 5 machina");
        Thaumcraft.parseAspects(Machine.EnchantmentRouter, "1 motus, 4 iter, 2 sensus, 5 machina, 1 praecantatio");
        Thaumcraft.parseAspects(Machine.Fertilizer, "6 herba, 5 machina, 1 vitreus, 3 victus");
        Thaumcraft.parseAspects(Machine.Fisher, "3 aqua, 5 machina, 4 metallum, 2 instrumentum");
        Thaumcraft.parseAspects(Machine.Fountain, "10 aqua, 5 machina, 3 fabrico, 1 iter");
        Thaumcraft.parseAspects(Machine.FruitPicker, "2 herba, 4 meto, 5 machina");
        Thaumcraft.parseAspects(Machine.Grinder, "10 telum, 6 mortuus, 7 meto, 5 machina, 4 metallum, 2 lucrum");
        Thaumcraft.parseAspects(Machine.ItemCollector, "4 vacuos, 5 machina, 2 arbor, 4 motus");
        Thaumcraft.parseAspects(Machine.ItemRouter, "2 motus, 4 iter, 2 sensus,  5 machina");
        Thaumcraft.parseAspects(Machine.LaserDrill, "30 perfodio, 15 lux, 5 machina, 4 victus");
        Thaumcraft.parseAspects(Machine.LaserDrillPrecharger, "4 lux, 5 machina, 25 potentia, 2 victus");
        Thaumcraft.parseAspects(Machine.LavaFabricator, "4 ignis, 4 terra, 4 fabrico, 5 machina");
        Thaumcraft.parseAspects(Machine.LiquiCrafter, "5 aqua, 5 fabrico, 5 machina");
        Thaumcraft.parseAspects(Machine.LiquidRouter, "1 motus, 4 iter, 2 sensus, 5 machina, 1 aqua");
        Thaumcraft.parseAspects(Machine.MeatPacker, "2 ordo, 2 corpus, 2 fames, 5 machina");
        Thaumcraft.parseAspects(Machine.MobCounter, "5 ordo, 5 machina, 5 cognitio");
        Thaumcraft.parseAspects(Machine.MobRouter, "3 ordo, 3 bestia, 5 machina, 3 sensus");
        Thaumcraft.parseAspects(Machine.Planter, "4 herba, 2 arbor, 4 messis, 5 machina");
        Thaumcraft.parseAspects(Machine.Rancher, "6 meto, 5 machina, 4 metallum, 2 instrumentum");
        Thaumcraft.parseAspects(Machine.RedNote, "4 aer, 4 sensus, 5 machina");
        Thaumcraft.parseAspects(Machine.Sewer, "1 venenum, 3 aqua, 5 machina, 4 bestia");
        Thaumcraft.parseAspects(Machine.Slaughterhouse, "12 telum, 10 mortuus, 5 machina, 12 metallum, 6 lucrum");
        Thaumcraft.parseAspects(Machine.SludgeBoiler, "3 ordo, 3 venenum, 3 terra, 2 aqua, 5 machina, 2 ignis");
        Thaumcraft.parseAspects(Machine.SteamBoiler, "3 fabrico, 7 aqua, 5 machina, 10 ignis, 3 perditio");
        Thaumcraft.parseAspects(Machine.SteamTurbine, "3 vacuos, 3 aqua, 5 machina, 10 potentia, 1 fabrico, 3 ordo");
        Thaumcraft.parseAspects(Machine.Unifier, "5 ordo, 2 alienis, 5 machina");
        Thaumcraft.parseAspects(Machine.Vet, "4 sano, 5 machina, 4 bestia");
        Thaumcraft.parseAspects(Machine.WeatherCollector, " 4 vacuos, 5 machina, 5 metallum, 4 tempestas");
        Thaumcraft.parseAspects("mfrEntityPinkSlime", "1 aqua, 2 limus, 1 corpus, 1 bestia");
        Thaumcraft.parseAspects(MFRThings.machineItem, 0, "2 fabrico, 2 machina, 1 terra");
        Thaumcraft.parseAspects(MFRThings.machineItem, 1, "1 cognitio, 3 machina");
        Thaumcraft.parseAspects(MFRThings.rubberBarItem, "1 motus, 1 arbor, 1 ignis");
        Thaumcraft.parseAspects(MFRThings.rubberLeavesBlock, "1 herba");
        Thaumcraft.parseAspects((Block)MFRThings.rubberSaplingBlock, "1 arbor, 1 herba");
        Thaumcraft.parseAspects(MFRThings.rubberWoodBlock, 0, "3 arbor");
        Thaumcraft.parseAspects(MFRThings.rubberWoodBlock, 1, "3 arbor, 1 limus");
        Thaumcraft.parseAspects(MFRThings.rawRubberItem, "2 limus, 1 arbor");
        Thaumcraft.parseAspects(MFRThings.rawPlasticItem, "1 fabrico, 1 ignis, 1 ordo, 1 perditio");
        Thaumcraft.parseAspects(MFRThings.plasticSheetItem, "1 fabrico, 1 ignis, 2 ordo");
        Thaumcraft.parseAspects(MFRThings.factoryPlasticBlock, "1 iter, 1 fabrico, 1 sensus");
        Thaumcraft.parseAspects((Block)MFRThings.plasticPipeBlock, "1 aqua, 1 machina", true);
        Thaumcraft.parseAspects(MFRThings.plasticTank, "4 aqua, 4 vacuos");
        Thaumcraft.parseAspects(MFRThings.bioFuelBucketItem, "2 herba, 1 potentia, 1 aqua, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects((Block)MFRThings.biofuelLiquid, "4 herba, 2 potentia, 2 aqua");
        Thaumcraft.parseAspects(MFRThings.blankRecordItem, "4 sensus, 4 aer, 4 lucrum, 4 vacuos");
        Thaumcraft.parseAspects(MFRThings.ceramicDyeItem, "1 terra, 1 aqua, 1 sensus");
        Thaumcraft.parseAspects(MFRThings.chocolateMilkBucketItem, "2 fames, 1 motus, 1 potentia, 2 aqua, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects((Block)MFRThings.chocolateMilkLiquid, "4 fames, 2 motus, 2 potentia, 4 aqua");
        Thaumcraft.parseAspects(MFRThings.conveyorBlock, "3 motus, 1 iter, 1 machina");
        Thaumcraft.parseAspects((Block)MFRThings.essenceLiquid, "4 praecantatio, 2 cognitio, 2 aqua");
        Thaumcraft.parseAspects(MFRThings.factoryGlassBlock, "1 vitreus, 1 sensus");
        Thaumcraft.parseAspects(MFRThings.factoryHammerItem, "1 instrumentum, 2 fabrico, 2 ignis, 3 ordo");
        Thaumcraft.parseAspects(MFRThings.fertilizerItem, "1 arbor, 1 herba, 1 messis, 1 sensus");
        Thaumcraft.parseAspects(MFRThings.laserFocusItem, "1 ordo, 1 vitreus, 4 lucrum");
        Thaumcraft.parseAspects(MFRThings.meatBucketItem, "3 corpus, 1 bestia, 1 aqua, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects(MFRThings.meatIngotCookedItem, "3 corpus, 2 fames, 1 ignis");
        Thaumcraft.parseAspects(MFRThings.meatIngotRawItem, "3 corpus, 2 fames, 1 bestia");
        Thaumcraft.parseAspects((Block)MFRThings.meatLiquid, "6 corpus, 2 aqua, 2 bestia");
        Thaumcraft.parseAspects(MFRThings.meatNuggetCookedItem, "1 fames");
        Thaumcraft.parseAspects(MFRThings.meatNuggetRawItem, "1 corpus");
        Thaumcraft.parseAspects(MFRThings.milkBottleItem, "1 fames, 1 sano, 1 victus, 1 vitreus");
        Thaumcraft.parseAspects((Block)MFRThings.milkLiquid, "4 fames, 4 sano, 4 aqua, 2 victus");
        Thaumcraft.parseAspects(MFRThings.mobEssenceBucketItem, "2 praecantatio, 1 cognitio, 1 aqua, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects(MFRThings.mushroomSoupBucketItem, "2 fames, 2 herba, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects((Block)MFRThings.mushroomSoupLiquid, "4 fames, 4 herba, 1 aqua");
        Thaumcraft.parseAspects(MFRThings.pinkSlimeItem, "1 limus, 1 corpus");
        Thaumcraft.parseAspects(MFRThings.pinkSlimeBlock, "9 limus, 9 corpus, 2 aqua");
        Thaumcraft.parseAspects(MFRThings.pinkSlimeBucketItem, "2 limus, 2 corpus, 1 aqua, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects((Block)MFRThings.pinkSlimeLiquid, "4 limus, 4 corpus, 2 aqua");
        Thaumcraft.parseAspects(MFRThings.portaSpawnerItem, "8 alienis, 4 bestia, 4 exanimis, 4 iter, 8 praecantatio, 8 permutatio");
        Thaumcraft.parseAspects(MFRThings.rednetCableBlock, 0, "1 cognitio, 1 machina", true);
        Thaumcraft.parseAspects(MFRThings.rednetCableBlock, 1, "1 cognitio, 1 machina, 1 vitreus", true);
        Thaumcraft.parseAspects(MFRThings.rednetCableBlock, 2, "1 cognitio, 1 machina, 3 potentia", true);
        Thaumcraft.parseAspects(MFRThings.rednetCableBlock, 3, "1 cognitio, 1 machina, 3 potentia, 1 vitreus", true);
        Thaumcraft.parseAspects((Block)MFRThings.rednetLogicBlock, "15 cognitio, 5 machina", true);
        Thaumcraft.parseAspects(MFRThings.rednetMemoryCardItem, "3 cognitio, 1 machina");
        Thaumcraft.parseAspects(MFRThings.rednetMeterItem, 0, "1 instrumentum, 1 sensus, 1 machina");
        Thaumcraft.parseAspects(MFRThings.rednetMeterItem, 1, "4 instrumentum, 1 sensus, 2 machina");
        Thaumcraft.parseAspects(MFRThings.rednetPanelBlock, "2 sensus, 2 cognitio, 2 machina");
        Thaumcraft.parseAspects(MFRThings.rulerItem, "1 instrumentum, 1 sensus");
        Thaumcraft.parseAspects(MFRThings.safariNetItem, "4 spiritus, 8 alienis, 8 iter, 4 praecantatio, 8 vinculum, 4 fabrico");
        Thaumcraft.parseAspects(MFRThings.safariNetJailerItem, "10 vinculum, 1 praecantatio, 4 spiritus, 2 metallum, 1 fabrico");
        Thaumcraft.parseAspects(MFRThings.safariNetLauncherItem, "2 volatus, 2 instrumentum");
        Thaumcraft.parseAspects(MFRThings.safariNetSingleItem, "4 vinculum, 4 spiritus, 2 instrumentum");
        Thaumcraft.parseAspects(MFRThings.sewageBucketItem, "2 venenum, 1 bestia, 1 aqua, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects((Block)MFRThings.sewageLiquid, "4 venenum, 2 bestia, 2 aqua");
        Thaumcraft.parseAspects(MFRThings.sludgeBucketItem, "2 venenum, 1 terra, 1 aqua, 1 vitium, 8 metallum, 1 vacuos");
        Thaumcraft.parseAspects((Block)MFRThings.sludgeLiquid, "4 venenum, 2 terra, 2 aqua, 1 vitium");
        Thaumcraft.parseAspects(MFRThings.spyglassItem, "2 victus, 6 sensus");
        Thaumcraft.parseAspects(MFRThings.strawItem, "1 vacuos, 4 aqua, 4 fames, 1 instrumentum");
        Thaumcraft.parseAspects(MFRThings.sugarCharcoalItem, "2 potentia, 2 ignis");
        Thaumcraft.parseAspects(MFRThings.syringeCureItem, "2 sano, 1 exanimis, 1 humanus, 1 instrumentum");
        Thaumcraft.parseAspects(MFRThings.syringeEmptyItem, "1 vacuos, 1 sano, 1 instrumentum");
        Thaumcraft.parseAspects(MFRThings.syringeGrowthItem, "1 tempus, 2 sano, 1 instrumentum");
        Thaumcraft.parseAspects(MFRThings.syringeHealthItem, "2 sano, 1 instrumentum");
        Thaumcraft.parseAspects(MFRThings.syringeSlimeItem, "1 sano, 1 limus, 1 instrumentum");
        Thaumcraft.parseAspects(MFRThings.syringeZombieItem, "1 tempus, 1 sano, 1 exanimis, 1 instrumentum");
        Thaumcraft.parseAspects(MFRThings.vineScaffoldBlock, "1 herba, 1 fabrico");
        Thaumcraft.parseAspects(MFRThings.xpExtractorItem, "1 praecantatio, 1 permutatio, 1 vacuos, 1 instrumentum, 1 meto");
        Thaumcraft.parseAspects(MFRThings.upgradeItem, "2 cognitio");
        int n = 10;
        for (int i = 0; i <= n; ++i) {
            Thaumcraft.parseAspects(MFRThings.upgradeItem, i, "2 cognitio", true);
        }
        Thaumcraft.parseAspects(MFRThings.upgradeItem, 11, "1 cognitio", true);
        Thaumcraft.parseAspects(MFRThings.logicCardItem, 0, "4 cognitio", true);
        Thaumcraft.parseAspects(MFRThings.logicCardItem, 1, "7 cognitio", true);
        Thaumcraft.parseAspects(MFRThings.logicCardItem, 2, "10 cognitio", true);
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 0, "2 gelum, 1 terra");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 1, "1 terra, 3 lux, 2 sensus");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 2, "2 terra, 4 sensus");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 3, "2 terra, 3 ignis, 1 tenebrae");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 4, "2 terra, 1 ordo");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 5, "1 gelum, 1 terra");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 6, "2 gelum, 1 terra");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 7, "1 terra, 3 lux, 2 sensus");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 8, "2 terra, 4 sensus");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 9, "3 ignis, 2 terra, 1 tenebrae");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 10, "3 terra");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 12, "1 gelum, 1 terra");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 12, "3 corpus, 2 fames, 1 bestia", true);
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 13, "3 corpus, 2 fames, 1 ignis", true);
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 14, "4 terra, 4 ignis");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeBrickBlock, 15, "10 ignis, 10 potentia");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeStoneBlock, 0, "2 terra, 1 tenebrae");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeStoneBlock, 1, "2 terra, 1 victus");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeStoneBlock, 2, "1 perditio, 1 terra, 1 tenebrae");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeStoneBlock, 3, "1 perditio, 1 terra, 1 victus");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeStoneBlock, 4, "2 terra, 1 tenebrae");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeStoneBlock, 5, "2 terra, 1 victus");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeStoneBlock, 6, "3 terra, 1 tenebrae");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeStoneBlock, 7, "3 terra, 1 victus");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeStoneBlock, 8, "2 terra, 1 tenebrae");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeStoneBlock, 9, "2 terra, 1 victus");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeStoneBlock, 10, "3 terra, 1 tenebrae");
        Thaumcraft.parseAspects(MFRThings.factoryDecorativeStoneBlock, 11, "3 terra, 1 victus");
        Thaumcraft.parseAspects(MFRThings.factoryRoadBlock, 0, "3 iter, 1 terra, 1 sensus");
        Thaumcraft.parseAspects(MFRThings.factoryRoadBlock, 1, "3 iter, 1 terra, 1 sensus, 3 lux");
        Thaumcraft.parseAspects(MFRThings.factoryRoadBlock, 2, "3 iter, 1 terra, 1 sensus, 3 lux");
        Thaumcraft.parseAspects(MFRThings.factoryRoadBlock, 3, "3 iter, 1 terra, 1 sensus, 3 lux");
        Thaumcraft.parseAspects(MFRThings.factoryRoadBlock, 4, "3 iter, 1 terra, 1 sensus, 3 lux");
    }
}

