/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.net;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.LinkedHashSet;
import powercrystals.minefactoryreloaded.core.IGrid;
import powercrystals.minefactoryreloaded.core.IGridController;
import powercrystals.minefactoryreloaded.core.INode;
import powercrystals.minefactoryreloaded.tile.rednet.RedstoneEnergyNetwork;
import powercrystals.minefactoryreloaded.tile.rednet.RedstoneNetwork;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetCable;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetEnergy;
import powercrystals.minefactoryreloaded.tile.transport.FluidNetwork;
import powercrystals.minefactoryreloaded.tile.transport.TileEntityPlasticPipe;

public class GridTickHandler<G extends IGrid, N extends INode>
implements IGridController {
    public static final GridTickHandler<RedstoneEnergyNetwork, TileEntityRedNetEnergy> energy = new GridTickHandler("Energy");
    public static final GridTickHandler<RedstoneNetwork, TileEntityRedNetCable> redstone = new GridTickHandler("Redstone");
    public static final GridTickHandler<FluidNetwork, TileEntityPlasticPipe> fluid = new GridTickHandler("Fluid");
    private LinkedHashSet<G> tickingGridsToRegenerate = new LinkedHashSet();
    private LinkedHashSet<G> tickingGridsToAdd = new LinkedHashSet();
    private LinkedHashSet<G> tickingGrids = new LinkedHashSet();
    private LinkedHashSet<G> tickingGridsToRemove = new LinkedHashSet();
    private LinkedHashSet<N> conduit = new LinkedHashSet();
    private LinkedHashSet<N> conduitToAdd = new LinkedHashSet();
    private LinkedHashSet<N> conduitToUpd = new LinkedHashSet();
    private final String label;

    public GridTickHandler(String string) {
        string.hashCode();
        this.label = "GridTickHandler[" + string + "]";
    }

    public void addGrid(G g) {
        this.tickingGridsToAdd.add(g);
        this.tickingGridsToRemove.remove(g);
    }

    public void removeGrid(G g) {
        this.tickingGridsToRemove.add(g);
        this.tickingGridsToAdd.remove(g);
    }

    public void regenerateGrid(G g) {
        this.tickingGridsToRegenerate.add(g);
    }

    public boolean isGridTicking(G g) {
        return this.tickingGrids.contains(g);
    }

    public void addConduitForTick(N n) {
        this.conduitToAdd.add(n);
    }

    public void addConduitForUpdate(N n) {
        this.conduitToUpd.add(n);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent serverTickEvent) {
        if (serverTickEvent.phase == TickEvent.Phase.START) {
            this.tickStart();
        } else {
            this.tickEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickStart() {
        Object object2;
        if (!this.tickingGridsToRegenerate.isEmpty()) {
            object2 = this.tickingGridsToRegenerate;
            synchronized (object2) {
                for (IGrid iGrid : this.tickingGridsToRegenerate) {
                    iGrid.markSweep();
                }
                this.tickingGridsToRegenerate.clear();
            }
        }
        if (!this.conduitToUpd.isEmpty()) {
            object2 = this.conduitToUpd;
            synchronized (object2) {
                this.conduit.addAll(this.conduitToUpd);
                this.conduitToUpd.clear();
            }
        }
        if (!this.conduit.isEmpty()) {
            object2 = null;
            try {
                for (Object object2 : this.conduit) {
                    if (object2.isNotValid()) continue;
                    object2.updateInternalTypes(this);
                }
                this.conduit.clear();
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Crashing on conduit " + object2, throwable);
            }
        }
        if (!this.tickingGrids.isEmpty()) {
            for (Object object3 : this.tickingGrids) {
                object3.doGridPreUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickEnd() {
        Object object3;
        if (!this.tickingGridsToRemove.isEmpty()) {
            object3 = this.tickingGridsToRemove;
            synchronized (object3) {
                this.tickingGrids.removeAll(this.tickingGridsToRemove);
                this.tickingGridsToRemove.clear();
            }
        }
        if (!this.tickingGridsToAdd.isEmpty()) {
            object3 = this.tickingGridsToAdd;
            synchronized (object3) {
                this.tickingGrids.addAll(this.tickingGridsToAdd);
                this.tickingGridsToAdd.clear();
            }
        }
        if (!this.tickingGrids.isEmpty()) {
            for (Object object2 : this.tickingGrids) {
                object2.doGridUpdate();
            }
        }
        if (!this.conduitToAdd.isEmpty()) {
            object3 = this.conduitToAdd;
            synchronized (object3) {
                this.conduit.addAll(this.conduitToAdd);
                this.conduitToAdd.clear();
            }
        }
        if (!this.conduit.isEmpty()) {
            object3 = null;
            try {
                for (Object object3 : this.conduit) {
                    if (object3.isNotValid()) continue;
                    object3.firstTick(this);
                }
                this.conduit.clear();
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Crashing on conduit " + object3, throwable);
            }
        }
    }

    public String toString() {
        return this.label + "@" + this.hashCode();
    }
}

