/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.fluid.FluidTankAdv;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IMobSpawnHandler;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiAutoSpawner;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerAutoSpawner;
import powercrystals.minefactoryreloaded.item.ItemSafariNet;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityAutoSpawner
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    protected static final int _spawnRange = 4;
    protected boolean _spawnExact = false;
    protected int _spawnCost = 0;
    protected Entity _spawn = null;
    protected ItemStack _lastSpawnStack = null;

    public TileEntityAutoSpawner() {
        super(Machine.AutoSpawner);
        this.setManageSolids(true);
        TileEntityAutoSpawner.createHAM(this, 4, 0, 2, false);
        this._areaManager.setOverrideDirection(ForgeDirection.UP);
        this._tanks[0].setLock(FluidRegistry.getFluid((String)"mobessence"));
    }

    public boolean getSpawnExact() {
        return this._spawnExact;
    }

    public void setSpawnExact(boolean bl) {
        this._spawn = null;
        this._spawnExact = bl;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiAutoSpawner(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerAutoSpawner getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerAutoSpawner(this, inventoryPlayer);
    }

    public int func_70302_i_() {
        return 1;
    }

    protected int getSpawnCost() {
        return this._spawnExact ? MFRConfig.autospawnerCostExact.getInt() : MFRConfig.autospawnerCostStandard.getInt();
    }

    protected int getSpawnCost(Entity entity, String string) {
        int n = MFRRegistry.getBaseSpawnCost(string);
        if (entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)entity;
            int n2 = Math.abs(entityLiving.field_70728_aV) + 1;
            n += n2 + n2 / 3;
            ItemStack[] itemStackArray = entityLiving.func_70035_c();
            for (int i = 0; i < itemStackArray.length; ++i) {
                if (itemStackArray[i] == null || !(entityLiving.field_82174_bp[i] <= 1.0f)) continue;
                n += 5;
            }
            n = Math.max(n, 4);
        }
        return (int)((float)(Math.max(n - 1, 0) + 1) * 66.666664f * (float)this.getSpawnCost()) / 10;
    }

    @Override
    protected boolean activateMachine() {
        String string;
        ItemStack itemStack = this.func_70301_a(0);
        if (itemStack == null || !this.func_102007_a(0, itemStack, 6)) {
            this.setWorkDone(0);
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (this._spawn == null) {
            Class clazz;
            string = nBTTagCompound.func_74779_i("id");
            boolean bl = MFRRegistry.getAutoSpawnerBlacklist().contains(string);
            if (!bl) {
                clazz = (Class)EntityList.field_75625_b.get(string);
                if (clazz == null) {
                    bl = true;
                } else {
                    for (Class<?> object2 : MFRRegistry.getAutoSpawnerClassBlacklist()) {
                        if (!object2.isAssignableFrom(clazz)) continue;
                        bl = true;
                        break;
                    }
                }
            }
            if (bl) {
                this.setWorkDone(0);
                return false;
            }
            this._spawn = EntityList.func_75620_a((String)string, (World)this.field_145850_b);
            clazz = this._spawn;
            if (!(clazz instanceof EntityLivingBase)) {
                this._spawn = null;
                return false;
            }
            EntityLivingBase entityLivingBase = (EntityLivingBase)clazz;
            if (this._spawnExact) {
                NBTTagCompound d2 = (NBTTagCompound)nBTTagCompound.func_74737_b();
                entityLivingBase.func_70037_a(d2);
                for (int i = 0; i < 5; ++i) {
                    if (!(entityLivingBase instanceof EntityLiving)) continue;
                    ((EntityLiving)entityLivingBase).func_96120_a(i, Float.NEGATIVE_INFINITY);
                }
            }
            IMobSpawnHandler iMobSpawnHandler = MFRRegistry.getSpawnHandlers().get(entityLivingBase.getClass());
            if (!this._spawnExact) {
                if (entityLivingBase instanceof EntityLiving) {
                    ((EntityLiving)entityLivingBase).func_110161_a(null);
                }
                if (iMobSpawnHandler != null) {
                    iMobSpawnHandler.onMobSpawn(entityLivingBase);
                }
            } else if (iMobSpawnHandler != null) {
                iMobSpawnHandler.onMobExactSpawn(entityLivingBase);
            }
            this._spawnCost = this.getSpawnCost(this._spawn, string);
        }
        if (this.getWorkDone() < this.getWorkMax()) {
            if (this.drain(this._tanks[0], 10, false) == 10) {
                this.drain(this._tanks[0], 10, true);
                this.setWorkDone(this.getWorkDone() + 1);
                return true;
            }
            return false;
        }
        string = this._spawn;
        this._spawn = null;
        if (!(string instanceof EntityLivingBase)) {
            return false;
        }
        EntityLivingBase entityLivingBase = (EntityLivingBase)string;
        double d = (double)this.field_145851_c + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * 4.0;
        double d2 = this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(3) - 1;
        double d3 = (double)this.field_145849_e + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * 4.0;
        entityLivingBase.func_70012_b(d, d2, d3, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (!this.field_145850_b.func_72855_b(entityLivingBase.field_70121_D) || !this.field_145850_b.func_72945_a((Entity)entityLivingBase, entityLivingBase.field_70121_D).isEmpty() || this.field_145850_b.func_72953_d(entityLivingBase.field_70121_D) != entityLivingBase instanceof EntityWaterMob) {
            this.setIdleTicks(10);
            return false;
        }
        this.field_145850_b.func_72838_d((Entity)entityLivingBase);
        this.field_145850_b.func_72926_e(2004, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
        if (entityLivingBase instanceof EntityLiving) {
            ((EntityLiving)entityLivingBase).func_70656_aK();
            ((EntityLiving)entityLivingBase).func_98053_h(false);
        }
        this.setWorkDone(0);
        return true;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        if (!this.internalChange && !UtilInventory.stacksEqual(this._lastSpawnStack, this._inventory[0])) {
            this.setWorkDone(0);
            this.setIdleTicks(this.getIdleTicksMax());
        }
        this._lastSpawnStack = this._inventory[0];
    }

    @Override
    public void setWorkDone(int n) {
        if (n == 0) {
            this._spawn = null;
            this._spawnCost = 0;
        }
        super.setWorkDone(n);
    }

    @SideOnly(value=Side.CLIENT)
    public void setWorkMax(int n) {
        this._spawnCost = n;
    }

    @Override
    public int getWorkMax() {
        return this._spawnCost;
    }

    @Override
    public int getIdleTicksMax() {
        return 140;
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(4000)};
    }

    @Override
    public boolean allowBucketFill(ItemStack itemStack) {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.fill(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.drain(fluidStack, bl);
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return ItemSafariNet.isSafariNet(itemStack) && !ItemSafariNet.isSingleUse(itemStack) && !ItemSafariNet.isEmpty(itemStack);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this._spawnExact = nBTTagCompound.func_74767_n("spawnExact");
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        nBTTagCompound.func_74757_a("spawnExact", this._spawnExact);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }
}

