/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiLiquidRouter;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerLiquidRouter;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityLiquidRouter
extends TileEntityFactoryInventory
implements IFluidHandler {
    private static final ForgeDirection[] _outputDirections = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    protected boolean[] _filledDirection = new boolean[6];

    public TileEntityLiquidRouter() {
        super(Machine.LiquidRouter);
        for (int i = 0; i < 6; ++i) {
            this._filledDirection[i] = false;
        }
        this.setManageFluids(true);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        for (int i = 0; i < 6; ++i) {
            this._filledDirection[i] = false;
        }
    }

    private int pumpLiquid(FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || fluidStack.amount <= 0) {
            return 0;
        }
        int n = fluidStack.amount;
        int[] nArray = this.getRoutesForLiquid(fluidStack);
        int[] nArray2 = this.getDefaultRoutes();
        if (this.hasRoutes(nArray)) {
            n = this.weightedRouteLiquid(fluidStack, nArray, n, bl);
        } else if (this.hasRoutes(nArray2)) {
            n = this.weightedRouteLiquid(fluidStack, nArray2, n, bl);
        }
        return fluidStack.amount - n;
    }

    private int weightedRouteLiquid(FluidStack fluidStack, int[] nArray, int n, boolean bl) {
        TileEntity tileEntity;
        int n2;
        if (n >= this.totalWeight(nArray)) {
            n2 = n;
            for (int i = 0; i < nArray.length; ++i) {
                TileEntity tileEntity2 = BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)_outputDirections[i]);
                int n3 = n2 * nArray[i] / this.totalWeight(nArray);
                if (tileEntity2 instanceof IFluidHandler && n3 > 0 && (n -= ((IFluidHandler)tileEntity2).fill(_outputDirections[i].getOpposite(), new FluidStack(fluidStack.fluidID, n3), bl)) <= 0) break;
            }
        }
        if (0 < n && n < this.totalWeight(nArray) && (tileEntity = BlockPosition.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)_outputDirections[n2 = this.weightedRandomSide(nArray)])) instanceof IFluidHandler) {
            n -= ((IFluidHandler)tileEntity).fill(_outputDirections[n2].getOpposite(), new FluidStack(fluidStack.fluidID, n), bl);
        }
        return n;
    }

    private int weightedRandomSide(int[] nArray) {
        int n = this.field_145850_b.field_73012_v.nextInt(this.totalWeight(nArray));
        for (int i = 0; i < nArray.length; ++i) {
            if ((n -= nArray[i]) >= 0) continue;
            return i;
        }
        return -1;
    }

    private int totalWeight(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        return n;
    }

    private boolean hasRoutes(int[] nArray) {
        for (int n : nArray) {
            if (n <= 0) continue;
            return true;
        }
        return false;
    }

    private int[] getRoutesForLiquid(FluidStack fluidStack) {
        int[] nArray = new int[6];
        for (int i = 0; i < 6; ++i) {
            ItemStack itemStack = this._inventory[i];
            Item item = itemStack != null ? itemStack.func_77973_b() : null;
            nArray[i] = item != null && fluidStack.isFluidEqual(FluidContainerRegistry.getFluidForFilledItem((ItemStack)this._inventory[i])) || item instanceof IFluidContainerItem && fluidStack.isFluidEqual(((IFluidContainerItem)item).getFluid(itemStack)) ? this._inventory[i].field_77994_a : 0;
        }
        return nArray;
    }

    private int[] getDefaultRoutes() {
        int[] nArray = new int[6];
        for (int i = 0; i < 6; ++i) {
            nArray[i] = FluidContainerRegistry.isEmptyContainer((ItemStack)this._inventory[i]) ? this._inventory[i].field_77994_a : 0;
        }
        return nArray;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        int n = forgeDirection.ordinal();
        if (n >= this._filledDirection.length || this._filledDirection[n]) {
            return 0;
        }
        int n2 = this.pumpLiquid(fluidStack, bl);
        this._filledDirection[n] = bl & n2 > 0;
        return n2;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    public int func_70302_i_() {
        return 6;
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiLiquidRouter((ContainerFactoryInventory)this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerLiquidRouter getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerLiquidRouter(this, inventoryPlayer);
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }
}

