/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.PHNatura;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BerryBushGen
extends WorldGenerator {
    private int metadata;
    private int spawnHeight;

    public BerryBushGen(int meta, int range) {
        this.metadata = meta;
        this.spawnHeight = range;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int height = this.findGround(world, x, y, z);
        if (height != -1) {
            int type = random.nextInt(10);
            if (type == 9) {
                this.generateLargeNode(world, random, x, height, z);
            } else if (type >= 7) {
                this.generateShrub(world, random, x, height, z);
            } else if (type >= 3) {
                this.generateSmallNode(world, random, x, height, z);
            } else {
                this.generateTinyNode(world, random, x, height, z);
            }
        }
        return true;
    }

    int findGround(World world, int x, int y, int z) {
        int returnHeight = -1;
        Block blockID = world.func_147439_a(x, y - 1, z);
        if (!(world.func_147439_a(x, y, z).func_149662_c() || blockID != Blocks.field_150346_d && blockID != Blocks.field_150349_c)) {
            return y;
        }
        int height = this.spawnHeight;
        while (height >= PHNatura.seaLevel) {
            Block j1 = world.func_147439_a(x, height, z);
            if (j1 == Blocks.field_150346_d || j1 == Blocks.field_150349_c) {
                if (world.func_147439_a(x, height + 1, z).func_149662_c()) break;
                returnHeight = height + 1;
                break;
            }
            if (--height > 0) continue;
        }
        return returnHeight;
    }

    public void generateLargeNode(World world, Random random, int x, int y, int z) {
        int iterY;
        int iterZ;
        int iterX;
        for (iterX = x - 2; iterX <= x + 2; ++iterX) {
            for (iterZ = z - 1; iterZ <= z + 1; ++iterZ) {
                for (iterY = y - 1; iterY <= y; ++iterY) {
                    this.generateBerryBlock(world, iterX, iterY, iterZ, random);
                }
            }
        }
        for (iterX = x - 1; iterX <= x + 1; ++iterX) {
            for (iterZ = z - 2; iterZ <= z - 2; ++iterZ) {
                for (iterY = y - 1; iterY <= y; ++iterY) {
                    this.generateBerryBlock(world, iterX, iterY, iterZ, random);
                }
            }
        }
        for (iterX = x - 1; iterX <= x + 1; ++iterX) {
            for (iterZ = z + 2; iterZ <= z + 2; ++iterZ) {
                for (iterY = y - 1; iterY <= y; ++iterY) {
                    this.generateBerryBlock(world, iterX, iterY, iterZ, random);
                }
            }
        }
        for (iterX = x - 1; iterX <= x + 1; ++iterX) {
            for (iterZ = z - 1; iterZ <= z + 1; ++iterZ) {
                int yPos = y + 1;
                this.generateBerryBlock(world, iterX, yPos, iterZ, random);
                yPos = y - 2;
                this.generateBerryBlock(world, iterX, yPos, iterZ, random);
            }
        }
    }

    public void generateShrub(World world, Random random, int x, int y, int z) {
        Block block = null;
        do {
            block = world.func_147439_a(x, y, z);
        } while ((world.func_147437_c(x, y, z) || block.isLeaves((IBlockAccess)world, x, y, z)) && --y > 0);
        Block i1 = world.func_147439_a(x, y, z);
        if (i1 == Blocks.field_150346_d || i1 == Blocks.field_150349_c) {
            for (int yPos = ++y; yPos <= y + 2; ++yPos) {
                int k1 = yPos - y;
                int l1 = 2 - k1;
                for (int xPos = x - l1; xPos <= x + l1; ++xPos) {
                    int j2 = xPos - x;
                    for (int zPos = z - l1; zPos <= z + l1; ++zPos) {
                        int l2 = zPos - z;
                        block = world.func_147439_a(xPos, yPos, zPos);
                        if (Math.abs(j2) == l1 && Math.abs(l2) == l1 && random.nextInt(2) == 0 || block != null && !block.canBeReplacedByLeaves((IBlockAccess)world, xPos, yPos, zPos)) continue;
                        this.generateBerryBlock(world, xPos, yPos, zPos, random);
                    }
                }
            }
        }
    }

    public void generateSmallNode(World world, Random random, int x, int y, int z) {
        this.generateBerryBlock(world, x, y, z, random);
        if (random.nextBoolean()) {
            this.generateBerryBush(world, x + 1, y, z, random);
        }
        if (random.nextBoolean()) {
            this.generateBerryBush(world, x - 1, y, z, random);
        }
        if (random.nextBoolean()) {
            this.generateBerryBush(world, x, y, z + 1, random);
        }
        if (random.nextBoolean()) {
            this.generateBerryBush(world, x, y, z - 1, random);
        }
    }

    public void generateTinyNode(World world, Random random, int x, int y, int z) {
        this.generateBerryBush(world, x, y, z, random);
    }

    void generateBerryBlock(World world, int x, int y, int z, Random random) {
        if (!world.func_147439_a(x, y, z).func_149662_c()) {
            int metaOffset = random.nextInt(5) == 0 ? 1 : 0;
            world.func_147465_d(x, y, z, (Block)NContent.berryBush, this.metadata + 8 + metaOffset * 4, 0);
        }
    }

    void generateBerryBush(World world, int x, int y, int z, Random random) {
        if (!world.func_147439_a(x, y, z).func_149662_c()) {
            int metaOffset = random.nextInt(4);
            world.func_147465_d(x, y, z, (Block)NContent.berryBush, this.metadata + metaOffset * 4, 0);
        }
    }
}

