/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.netherores;

import cofh.lib.util.RegistryUtils;
import cofh.mod.BaseMod;
import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.UpdateManager;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.netherores.entity.EntityArmedOre;
import powercrystals.netherores.entity.EntityHellfish;
import powercrystals.netherores.net.ServerProxy;
import powercrystals.netherores.ores.BlockNetherOres;
import powercrystals.netherores.ores.BlockNetherOverrideOre;
import powercrystals.netherores.ores.ItemBlockNetherOre;
import powercrystals.netherores.ores.Ores;
import powercrystals.netherores.world.BlockHellfish;
import powercrystals.netherores.world.NetherOresWorldGenHandler;

@Mod(modid="NetherOres", name="Nether Ores", version="1.7.10R2.3.0RC3", dependencies="required-after:FML@[7.10.0.1197,7.11);required-after:Forge@[10.13.0.1197,10.14);;required-after:CoFHCore@[1.7.10R3.0.0B3,)")
public class NetherOresCore
extends BaseMod {
    public static final String modId = "NetherOres";
    public static final String modName = "Nether Ores";
    public static final String version = "1.7.10R2.3.0RC3";
    public static final String dependencies = "required-after:FML@[7.10.0.1197,7.11);required-after:Forge@[10.13.0.1197,10.14);;required-after:CoFHCore@[1.7.10R3.0.0B3,)";
    public static final String mobTextureFolder = "netherores:textures/mob/";
    public static Block[] blockNetherOres = new Block[(Ores.values().length + 15) / 16];
    public static Block blockHellfish;
    public static Property enableWorldGen;
    public static Property enableExplosions;
    public static Property explosionPower;
    public static Property explosionProbability;
    public static Property enableExplosionChainReactions;
    public static Property enableFortuneExplosions;
    public static Property enableAngryPigmen;
    public static Property silkyStopsPigmen;
    public static Property enableMobsAngerPigmen;
    public static Property enableHellfish;
    public static Property enableStandardFurnaceRecipes;
    public static Property enableMaceratorRecipes;
    public static Property enablePulverizerRecipes;
    public static Property enableInductionSmelterRecipes;
    public static Property enableGrinderRecipes;
    public static Property forceOreSpawn;
    public static Property worldGenAllDimensions;
    public static Property enableHellQuartz;
    public static Property hellFishFromOre;
    public static Property hellFishFromOreChance;
    public static Property hellFishPerChunk;
    public static Property hellFishPerGroup;
    public static Property hellFishMinY;
    public static Property hellFishMaxY;
    public static Property hellFishMaxHealth;
    public static ConfigCategory overrideOres;
    @SidedProxy(clientSide="powercrystals.netherores.net.ClientProxy", serverSide="powercrystals.netherores.net.ServerProxy")
    public static ServerProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        this.setConfigFolderBase(fMLPreInitializationEvent.getModConfigurationDirectory());
        this.loadConfig(this.getCommonConfig());
        this.loadLang();
        int n = blockNetherOres.length;
        for (int i = 0; i < n; ++i) {
            NetherOresCore.blockNetherOres[i] = new BlockNetherOres(i);
            BlockNetherOres blockNetherOres = NetherOresCore.blockNetherOres[i];
            GameRegistry.registerBlock((Block)blockNetherOres, ItemBlockNetherOre.class, (String)blockNetherOres.func_149739_a());
        }
        blockHellfish = new BlockHellfish();
        GameRegistry.registerBlock((Block)blockHellfish, ItemBlock.class, (String)"netherOresBlockHellfish");
        GameRegistry.registerCustomItemStack((String)"netherOresBlockHellfish", (ItemStack)new ItemStack(blockHellfish));
        if (enableHellQuartz.getBoolean(true)) {
            BlockNetherOverrideOre blockNetherOverrideOre = new BlockNetherOverrideOre(Blocks.field_150449_bY){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int func_149679_a(int n, Random random) {
                    Class<Blocks> clazz = Blocks.class;
                    synchronized (Blocks.class) {
                        Blocks.field_150449_bY = this._override;
                        int n2 = this._override.func_149679_a(n, random);
                        Blocks.field_150449_bY = this;
                        // ** MonitorExit[var4_3] (shouldn't be in output)
                        return n2;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void func_149690_a(World world, int n, int n2, int n3, int n4, float f, int n5) {
                    Class<Blocks> clazz = Blocks.class;
                    synchronized (Blocks.class) {
                        Blocks.field_150449_bY = this._override;
                        this._override.func_149690_a(world, n, n2, n3, n4, f, n5);
                        Blocks.field_150449_bY = this;
                        // ** MonitorExit[var8_8] (shouldn't be in output)
                        return;
                    }
                }
            };
            Blocks.field_150449_bY = blockNetherOverrideOre;
            RegistryUtils.overwriteEntry((RegistryNamespaced)Block.field_149771_c, (String)"minecraft:quartz_ore", (Object)blockNetherOverrideOre);
        }
        for (Ores ores : Ores.values()) {
            ores.load();
        }
        EntityRegistry.registerModEntity(EntityArmedOre.class, (String)"netherOresArmedOre", (int)0, (Object)((Object)this), (int)80, (int)5, (boolean)false);
        EntityRegistry.registerModEntity(EntityHellfish.class, (String)"netherOresHellfish", (int)1, (Object)((Object)this), (int)160, (int)5, (boolean)true);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent fMLInitializationEvent) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new NetherOresWorldGenHandler(), (int)10);
        proxy.load();
        UpdateManager.registerUpdater((UpdateManager)new UpdateManager((IUpdatableMod)this));
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent iMCEvent) {
        this.processIMC((List<FMLInterModComms.IMCMessage>)iMCEvent.getMessages());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        Ores.Coal.registerSmelting(new ItemStack(Blocks.field_150365_q));
        Ores.Gold.registerSmelting(new ItemStack(Blocks.field_150352_o));
        Ores.Iron.registerSmelting(new ItemStack(Blocks.field_150366_p));
        Ores.Lapis.registerSmelting(new ItemStack(Blocks.field_150369_x));
        Ores.Diamond.registerSmelting(new ItemStack(Blocks.field_150482_ag));
        Ores.Emerald.registerSmelting(new ItemStack(Blocks.field_150412_bA));
        Ores.Redstone.registerSmelting(new ItemStack(Blocks.field_150450_ax));
        Ores.Coal.registerPulverizing(new ItemStack(Items.field_151044_h));
        Ores.Diamond.registerPulverizing(new ItemStack(Items.field_151045_i));
        Ores.Emerald.registerPulverizing(new ItemStack(Items.field_151166_bC));
        Ores.Redstone.registerPulverizing(new ItemStack(Items.field_151137_ax));
        Ores.Lapis.registerPulverizing(new ItemStack(Items.field_151100_aR, 1, 4));
        for (Ores ores : Ores.values()) {
            String string = ores.getOreName();
            if (OreDictionary.getOres((String)string).size() > 0) {
                this.registerOreDictSmelt(ores, string, (ItemStack)OreDictionary.getOres((String)string).get(0));
            }
            if (OreDictionary.getOres((String)(string = ores.getDustName())).size() > 0) {
                this.registerOreDictDust(ores, string, (ItemStack)OreDictionary.getOres((String)string).get(0));
            }
            if (OreDictionary.getOres((String)(string = ores.getAltName())).size() <= 0) continue;
            this.registerOreDictGem(ores, string, (ItemStack)OreDictionary.getOres((String)string).get(0));
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent fMLLoadCompleteEvent) {
        this.processIMC((List<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)((Object)this)));
        for (Map.Entry entry : overrideOres.getValues().entrySet()) {
            String string = (String)entry.getKey();
            Block block = Block.func_149684_b((String)string);
            if (this.isBlockInvalid(block)) {
                overrideOres.remove((Object)string);
                continue;
            }
            if (!((Property)entry.getValue()).setRequiresMcRestart(true).getBoolean(true)) continue;
            RegistryUtils.overwriteEntry((RegistryNamespaced)Block.field_149771_c, (String)string, (Object)new BlockNetherOverrideOre(block));
        }
        this._log.info("Load Complete.");
    }

    private boolean isBlockInvalid(Block block) {
        return Block.func_149682_b((Block)block) <= 175;
    }

    private void processIMC(List<FMLInterModComms.IMCMessage> list) {
        for (FMLInterModComms.IMCMessage iMCMessage : list) {
            try {
                String string = iMCMessage.key;
                if ("registerOverrideOre".equals(string)) {
                    String string2 = iMCMessage.getStringValue();
                    Block block = Block.func_149684_b((String)string2);
                    if (this.isBlockInvalid(block)) {
                        throw new IllegalArgumentException("Cannot override vanilla blocks via IMC.");
                    }
                    Property property = overrideOres.get(string2);
                    property.getBoolean(true);
                    if (property.wasRead()) continue;
                    property.comment = "Override the '" + string2 + "' block (registered by '" + iMCMessage.getSender() + "')";
                    continue;
                }
                this._log.debug("Unknown IMC message (%s) from %s", new Object[]{string, iMCMessage.getSender()});
            }
            catch (Throwable throwable) {
                this._log.error("Bad IMC message (%s) from %s", new Object[]{iMCMessage.key, iMCMessage.getSender(), throwable});
            }
        }
    }

    public static Block getOreBlock(int n) {
        if (n >= 0 && n < blockNetherOres.length) {
            return blockNetherOres[n];
        }
        return null;
    }

    private void loadConfig(File file) {
        Configuration configuration = new Configuration(file);
        configuration.load();
        explosionPower = configuration.get("general", "ExplosionPower", 2);
        NetherOresCore.explosionPower.comment = "How powerful an explosion will be. Creepers are 3, TNT is 4, electrified creepers are 6. This affects both the ability of the explosion to punch through blocks as well as the blast radius.";
        explosionProbability = configuration.get("general", "ExplosionProbability", 75);
        NetherOresCore.explosionProbability.comment = "The likelyhood an adjacent netherore will turn into an armed ore when one is mined. Percent chance out of 1000 (lower is less likely).";
        enableExplosions = configuration.get("general", "ExplosionEnable", true);
        NetherOresCore.enableExplosions.comment = "NetherOres have a chance to explode when mined if true.";
        enableExplosionChainReactions = configuration.get("general", "ExplosionChainReactEnable", true);
        NetherOresCore.enableExplosionChainReactions.comment = "NetherOre explosions can trigger more explosions if true. Does nothing if ExplosionEnable is false.";
        enableFortuneExplosions = configuration.get("general", "FortuneExplosionEnable", true);
        NetherOresCore.enableFortuneExplosions.comment = "NetherOres have a higher chance to explode when mined with fortune if true.";
        enableAngryPigmen = configuration.get("general", "AngryPigmenEnable", true);
        NetherOresCore.enableAngryPigmen.comment = "If true, when NetherOres are mined, nearby pigmen become angry to the player.";
        silkyStopsPigmen = configuration.get("general", "SilkyAngryPigmenEnable", false);
        NetherOresCore.silkyStopsPigmen.comment = "If true, when NetherOres are mined with Silk Touch, nearby pigmen become angry to the player.";
        enableMobsAngerPigmen = configuration.get("general", "MobsAngerPigmen", true);
        NetherOresCore.enableMobsAngerPigmen.comment = "If true, any entity not a player exploding a NetherOre will anger nearby pigmen. This only accounts for exploding, entities breaking the blocks normally will still anger pigmen.";
        hellFishMaxHealth = configuration.get("general", "HellFish.MaxHealth", 12.5, null, 8.0, Double.MAX_VALUE);
        NetherOresCore.hellFishMaxHealth.comment = "The maximum health a HellFish will have when spawned.";
        enableStandardFurnaceRecipes = configuration.get("Processing.Enable", "StandardFurnaceRecipes", true);
        NetherOresCore.enableStandardFurnaceRecipes.comment = "Set this to false to remove the standard furnace recipes (i.e., nether iron ore -> normal iron ore).";
        enableMaceratorRecipes = configuration.get("Processing.Enable", "MaceratorRecipes", true);
        NetherOresCore.enableMaceratorRecipes.comment = "Set this to false to remove the IC2 Macerator recipes (i.e., nether iron ore -> 4x iron dust).";
        enablePulverizerRecipes = configuration.get("Processing.Enable", "PulverizerRecipes", true);
        NetherOresCore.enablePulverizerRecipes.comment = "Set this to false to remove the TE Pulvierzer recipes (i.e., nether iron ore -> 4x iron dust).";
        enableInductionSmelterRecipes = configuration.get("Processing.Enable", "InductionSmelterRecipes", true);
        NetherOresCore.enableInductionSmelterRecipes.comment = "Set this to false to remove the TE Induction Smelter recipes (i.e., nether iron ore -> 2x normal iron ore).";
        enableGrinderRecipes = configuration.get("Processing.Enable", "GrinderRecipes", true);
        NetherOresCore.enableGrinderRecipes.comment = "Set this to false to remove the AE Grind Stone recipes (i.e., nether iron ore -> 4x iron dust).";
        forceOreSpawn = configuration.get("WorldGen.Enable", "ForceOreSpawn", false);
        NetherOresCore.forceOreSpawn.comment = "If true, will spawn nether ores regardless of if a furnace or macerator recipe was found. If false, at least one of those two must be found to spawn the ore.";
        worldGenAllDimensions = configuration.get("WorldGen.Enable", "AllDimensionWorldGen", false);
        NetherOresCore.worldGenAllDimensions.comment = "If true, Nether Ores worldgen will run in all dimensions instead of just the Nether. It will still require netherrack to place ores.";
        enableWorldGen = configuration.get("WorldGen.Enable", "OreGen", true);
        NetherOresCore.enableWorldGen.comment = "If true, Nether Ores oregen will run and places ores in the world where appropriate. Only disable this if you intend to use the ores with a custom ore generator. (overrides per-ore forcing; hellfish still generate if enabled)";
        enableHellQuartz = configuration.get("WorldGen.Enable", "OverrideNetherQuartz", true).setRequiresMcRestart(true);
        NetherOresCore.enableHellQuartz.comment = "If true, Nether Quartz ore will be a NetherOre and will follow the same rules as all other NetherOres.";
        hellFishFromOre = configuration.get("WorldGen.HellFish", "EnableSpawningFromOre", false);
        NetherOresCore.hellFishFromOre.comment = "If true, Hellfish will spawn from broken NetherOres.";
        hellFishFromOreChance = configuration.get("WorldGen.HellFish", "SpawningFromOreChance", 1000);
        NetherOresCore.hellFishFromOreChance.comment = "The chance out of 10000 that a broken ore will spawn a hellfish.";
        hellFishPerChunk = configuration.get("WorldGen.HellFish", "GroupsPerChunk", 9);
        NetherOresCore.hellFishPerChunk.comment = "The maximum number of hellfish veins per chunk.";
        hellFishPerGroup = configuration.get("WorldGen.HellFish", "BlocksPerGroup", 12);
        NetherOresCore.hellFishPerGroup.comment = "The maximum number of hellfish blocks per vein.";
        enableHellfish = configuration.get("WorldGen.HellFish", "Enable", true);
        NetherOresCore.enableHellfish.comment = "If true, Hellfish will spawn in the Nether. Note that setting this false will not kill active Hellfish mobs.";
        hellFishMinY = configuration.get("WorldGen.HellFish", "MinY", 1);
        hellFishMaxY = configuration.get("WorldGen.HellFish", "MaxY", 127);
        if (hellFishMinY.getInt() <= hellFishMaxY.getInt()) {
            hellFishMinY.set(hellFishMaxY.getInt() - 1);
        }
        for (Ores ores : Ores.values()) {
            ores.loadConfig(configuration);
        }
        overrideOres = configuration.getCategory("Overrides");
        overrideOres.setComment("A set of blocks from other modes to override to act like NetherOres.\nThis does not include controling oregen, or recipes; only behavior when mined or destroyed.");
        configuration.save();
    }

    @SubscribeEvent
    public void registerOreEvent(OreDictionary.OreRegisterEvent oreRegisterEvent) {
        this.registerOreDictionaryEntry(oreRegisterEvent.Name, oreRegisterEvent.Ore);
    }

    private void registerOreDictionaryEntry(String string, ItemStack itemStack) {
        for (Ores ores : Ores.values()) {
            this.registerOreDictSmelt(ores, string, itemStack);
            this.registerOreDictDust(ores, string, itemStack);
            this.registerOreDictGem(ores, string, itemStack);
        }
    }

    private void registerOreDictSmelt(Ores ores, String string, ItemStack itemStack) {
        if (!ores.isRegisteredSmelting() && ores.getOreName().equals(string)) {
            ores.registerSmelting(itemStack);
        }
    }

    private void registerOreDictDust(Ores ores, String string, ItemStack itemStack) {
        if (!ores.isRegisteredMacerator() && ores.getDustName().equals(string)) {
            ores.registerPulverizing(itemStack);
        }
    }

    private void registerOreDictGem(Ores ores, String string, ItemStack itemStack) {
        if (!ores.isRegisteredMacerator() && ores.getAltName().equals(string)) {
            ores.registerPulverizing(itemStack);
        }
    }

    public String getModId() {
        return modId;
    }

    public String getModName() {
        return modName;
    }

    public String getModVersion() {
        return version;
    }
}

