/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.netherores.ores;

import appeng.api.AEApi;
import appeng.api.features.IGrinderEntry;
import appeng.api.features.IGrinderRegistry;
import cofh.api.modhelpers.ThermalExpansionHelper;
import cofh.asm.relauncher.Strippable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.Recipes;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.netherores.NetherOresCore;

public enum Ores {
    Coal(8, 16, 2, 4),
    Diamond(4, 3, 2, 5, true),
    Gold(8, 6, 2, 4),
    Iron(8, 8, 2, 4),
    Lapis(6, 6, 2, 24),
    Redstone(6, 8, 2, 21),
    Copper(8, 8, 2, 4),
    Tin(8, 8, 2, 4),
    Emerald(3, 2, 2, 5, true),
    Silver(6, 4, 2, 4),
    Lead(6, 6, 2, 4),
    Uranium(3, 2, 2, 4, "crushed"),
    Nikolite(8, 4, 2, 21),
    Ruby(6, 3, 2, 5, true),
    Peridot(6, 3, 2, 5, true),
    Sapphire(6, 3, 2, 5, true),
    Platinum(1, 3, 2, 4),
    Nickel(4, 6, 2, 4),
    Steel(3, 4, 2, 4),
    Iridium(1, 2, 2, 4, "drop"),
    Osmium(8, 7, 2, 4),
    Sulfur(12, 12, 2, 24, false),
    Titanium(3, 2, 2, 4),
    Mithril(6, 6, 2, 4),
    Adamantium(5, 4, 2, 4),
    Rutile(3, 4, 2, 4),
    Tungsten(8, 8, 2, 4),
    Amber(5, 6, 2, 5, true),
    Tennantite(8, 8, 2, 4),
    Salt(5, 5, 2, 12, "food"),
    Saltpeter(6, 4, 2, 10, false),
    Magnesium(4, 5, 2, 8, "crushed");

    private int _blockIndex;
    private int _metadata;
    private String _secondary;
    private boolean _registeredSmelting;
    private boolean _registeredMacerator;
    private int _oreGenMinY = 1;
    private int _oreGenMaxY = 127;
    private int _oreGenGroupsPerChunk = 6;
    private int _oreGenBlocksPerGroup = 14;
    private boolean _oreGenDisable = false;
    private boolean _oreGenForced = false;
    private int _smeltCount;
    private int _pulvCount;
    private int _miningLevel;

    private Ores(int n2, int n3, int n4, int n5, boolean bl) {
        this(n2, n3, n4, n5, bl ? "gem" : "crystal");
    }

    private Ores(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, "crystalline");
    }

    private Ores(int n2, int n3, int n4, int n5, String string2) {
        int n6 = this.ordinal();
        this._blockIndex = n6 / 16;
        this._metadata = n6 % 16;
        this._oreGenGroupsPerChunk = n2;
        this._oreGenBlocksPerGroup = n3;
        this._smeltCount = n4;
        this._pulvCount = n5;
        this._miningLevel = 2;
        this._secondary = string2;
    }

    public int getBlockIndex() {
        return this._blockIndex;
    }

    public int getMetadata() {
        return this._metadata;
    }

    public String getOreName() {
        return "ore" + this.name();
    }

    public String getDustName() {
        return "dust" + this.name();
    }

    public String getAltName() {
        return this._secondary + this.name();
    }

    public boolean isRegisteredSmelting() {
        return this._registeredSmelting;
    }

    public boolean isRegisteredMacerator() {
        return this._registeredMacerator;
    }

    public int getMaxY() {
        return this._oreGenMaxY;
    }

    public int getMinY() {
        return this._oreGenMinY;
    }

    public int getGroupsPerChunk() {
        return this._oreGenGroupsPerChunk;
    }

    public int getBlocksPerGroup() {
        return this._oreGenBlocksPerGroup;
    }

    public boolean getDisabled() {
        return this._oreGenDisable;
    }

    public boolean getForced() {
        return this._oreGenForced;
    }

    public int getSmeltCount() {
        return this._smeltCount;
    }

    public int getMaceCount() {
        return this._pulvCount;
    }

    public ItemStack getItemStack(int n) {
        return new ItemStack(NetherOresCore.getOreBlock(this._blockIndex), n, this._metadata);
    }

    public void load() {
        NetherOresCore.getOreBlock(this._blockIndex).setHarvestLevel("pickaxe", this._miningLevel, this._metadata);
        if (this._oreGenForced | !this._oreGenDisable) {
            ItemStack itemStack = this.getItemStack(1);
            OreDictionary.registerOre((String)("oreNether" + this.name()), (ItemStack)itemStack);
            GameRegistry.registerCustomItemStack((String)("netherOresBlock" + this.name()), (ItemStack)itemStack);
        }
    }

    public void registerSmelting(ItemStack itemStack) {
        ItemStack itemStack2;
        if (this._registeredSmelting) {
            return;
        }
        this._registeredSmelting = true;
        if (NetherOresCore.enableStandardFurnaceRecipes.getBoolean(true)) {
            itemStack2 = itemStack.func_77946_l();
            itemStack2.field_77994_a = this._smeltCount;
            FurnaceRecipes.func_77602_a().func_151394_a(this.getItemStack(1), itemStack2, 1.0f);
        }
        if (NetherOresCore.enableInductionSmelterRecipes.getBoolean(true) && Loader.isModLoaded((String)"ThermalExpansion")) {
            int n;
            itemStack2 = this.getItemStack(1);
            ItemStack itemStack3 = new ItemStack((Block)Blocks.field_150354_m);
            ItemStack itemStack4 = GameRegistry.findItemStack((String)"ThermalExpansion", (String)"slagRich", (int)1);
            ItemStack itemStack5 = GameRegistry.findItemStack((String)"ThermalExpansion", (String)"slag", (int)1);
            ItemStack itemStack6 = itemStack.func_77946_l();
            itemStack6.field_77994_a = this._smeltCount;
            ItemStack itemStack7 = itemStack.func_77946_l();
            itemStack7.field_77994_a = n = this._smeltCount + (int)Math.ceil((float)this._smeltCount / 3.0f);
            ThermalExpansionHelper.addSmelterRecipe((int)(1600 * this._smeltCount), (ItemStack)itemStack2, (ItemStack)itemStack3, (ItemStack)itemStack6, (ItemStack)itemStack4, (int)10);
            ThermalExpansionHelper.addSmelterRecipe((int)(2400 * n), (ItemStack)itemStack2, (ItemStack)itemStack4, (ItemStack)itemStack7, (ItemStack)itemStack5, (int)100);
        }
    }

    public void registerPulverizing(ItemStack itemStack) {
        if (this._registeredMacerator) {
            return;
        }
        this._registeredMacerator = true;
        if (NetherOresCore.enableMaceratorRecipes.getBoolean(true) && Loader.isModLoaded((String)"IC2")) {
            this.registerMacerator(itemStack);
        }
        if (NetherOresCore.enablePulverizerRecipes.getBoolean(true) && Loader.isModLoaded((String)"ThermalExpansion")) {
            ItemStack itemStack2 = this.getItemStack(1);
            ItemStack itemStack3 = itemStack.func_77946_l();
            ItemStack itemStack4 = new ItemStack(Blocks.field_150424_aL);
            itemStack3.field_77994_a = this._pulvCount;
            itemStack4.field_77994_a = 1;
            ThermalExpansionHelper.addPulverizerRecipe((int)3200, (ItemStack)itemStack2, (ItemStack)itemStack3, (ItemStack)itemStack4, (int)15);
        }
        if (NetherOresCore.enableGrinderRecipes.getBoolean(true) && Loader.isModLoaded((String)"appliedenergistics2")) {
            this.registerAEGrinder(itemStack.func_77946_l());
        }
    }

    @Strippable(value={"mod:IC2"})
    private void registerMacerator(ItemStack itemStack) {
        ItemStack itemStack2 = this.getItemStack(1);
        ItemStack itemStack3 = itemStack.func_77946_l();
        itemStack3.field_77994_a = this._pulvCount;
        Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputItemStack(itemStack2), null, new ItemStack[]{itemStack3.func_77946_l()});
    }

    @Strippable(value={"mod:appliedenergistics2"})
    private void registerAEGrinder(ItemStack itemStack) {
        ItemStack itemStack2 = itemStack.func_77946_l();
        itemStack2.field_77994_a = this._pulvCount;
        IGrinderRegistry iGrinderRegistry = AEApi.instance().registries().grinder();
        for (ItemStack itemStack3 : OreDictionary.getOres((String)this.getOreName())) {
            IGrinderEntry iGrinderEntry = iGrinderRegistry.getRecipeForInput(itemStack3);
            if (iGrinderEntry == null) continue;
            iGrinderRegistry.addRecipe(this.getItemStack(1), itemStack2, iGrinderEntry.getEnergyCost() * 2);
            return;
        }
        iGrinderRegistry.addRecipe(this.getItemStack(1), itemStack2, 16);
    }

    public void loadConfig(Configuration configuration) {
        String string = "WorldGen.Ores." + this.name();
        this._oreGenMaxY = configuration.get(string, "MaxY", this._oreGenMaxY).setRequiresMcRestart(true).getInt();
        this._oreGenMinY = configuration.get(string, "MinY", this._oreGenMinY).setRequiresMcRestart(true).getInt();
        if (this._oreGenMinY >= this._oreGenMaxY) {
            this._oreGenMinY = this._oreGenMaxY - 1;
            configuration.get(string, "MinY", this._oreGenMinY).set(this._oreGenMinY);
        }
        this._oreGenGroupsPerChunk = configuration.get(string, "GroupsPerChunk", this._oreGenGroupsPerChunk).setRequiresMcRestart(true).getInt();
        this._oreGenBlocksPerGroup = configuration.get(string, "BlocksPerGroup", this._oreGenBlocksPerGroup).setRequiresMcRestart(true).getInt();
        this._oreGenDisable = configuration.get(string, "Disable", false, "Disables generation of " + this.name() + " (overrides global ForceOreSpawn)").setRequiresMcRestart(true).getBoolean(false);
        this._oreGenForced = configuration.get(string, "Force", false, "Force " + this.name() + " to generate (overrides Disable)").setRequiresMcRestart(true).getBoolean(false);
        this._miningLevel = configuration.get(string, "MiningLevel", this._miningLevel, "The pickaxe level required to mine " + this.name()).setRequiresMcRestart(true).getInt();
        string = "Processing.Ores." + this.name();
        this._smeltCount = configuration.get(string, "SmeltedCount", this._smeltCount, "Output from smelting " + this.name()).setRequiresMcRestart(true).getInt();
        this._pulvCount = configuration.get(string, "PulverizedCount", this._pulvCount, "Output from grinding " + this.name()).setRequiresMcRestart(true).getInt();
        this._secondary = configuration.get(string, "AlternateOrePrefix", this._secondary, "Output from grinding " + this.name() + " if dust" + this.name() + " is not found (i.e., " + this._secondary + this.name() + ")").setRequiresMcRestart(true).getString();
    }
}

