/*
 * Decompiled with CFR 0.152.
 */
package openblocks.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import openblocks.api.IFlimFlamAction;
import openblocks.api.IFlimFlamEffect;

public class FlimFlamRegistry {
    private static final List<IFlimFlamEffect> flimFlams = Lists.newArrayList();
    private static final List<IFlimFlamEffect> unmodifiableView = Collections.unmodifiableList(flimFlams);
    private static final Map<String, IFlimFlamEffect> flimFlamsByName = Maps.newHashMap();

    public static FlimFlamMeta registerFlimFlam(String name, int cost, int weight, IFlimFlamAction effect) {
        FlimFlamMeta meta = new FlimFlamMeta(name, cost, weight, effect);
        FlimFlamRegistry.registerFlimFlam(name, meta);
        return meta;
    }

    protected static IFlimFlamEffect registerFlimFlam(String name, IFlimFlamEffect meta) {
        flimFlams.add(meta);
        flimFlamsByName.put(name, meta);
        return meta;
    }

    public static List<IFlimFlamEffect> getFlimFlams() {
        return unmodifiableView;
    }

    public static IFlimFlamEffect getFlimFlamByName(String name) {
        return flimFlamsByName.get(name);
    }

    public static List<String> getAllFlimFlamsNames() {
        return ImmutableList.copyOf(flimFlamsByName.keySet());
    }

    public static class FlimFlamMeta
    implements IFlimFlamEffect {
        private boolean isSilent;
        private boolean isSafe;
        private final String name;
        private final int cost;
        private final int weight;
        private int lowerLuck;
        private int upperLuck;
        private final IFlimFlamAction effect;

        public FlimFlamMeta(String name, int cost, int weight, IFlimFlamAction effect) {
            this.name = name;
            this.cost = cost;
            this.weight = weight;
            this.effect = effect;
            if (cost < 0) {
                this.setRange(Integer.MIN_VALUE, cost);
            } else {
                this.setRange(cost, Integer.MAX_VALUE);
            }
        }

        public FlimFlamMeta markSafe() {
            this.isSafe = true;
            return this;
        }

        public FlimFlamMeta markSilent() {
            this.isSilent = true;
            return this;
        }

        public FlimFlamMeta setRange(int a, int b) {
            if (a < b) {
                this.lowerLuck = a;
                this.upperLuck = b;
            } else {
                this.lowerLuck = b;
                this.upperLuck = a;
            }
            return this;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int weight() {
            return this.weight;
        }

        @Override
        public int cost() {
            return this.cost;
        }

        @Override
        public boolean isSafe() {
            return this.isSafe;
        }

        @Override
        public boolean isSilent() {
            return this.isSilent;
        }

        @Override
        public IFlimFlamAction action() {
            return this.effect;
        }

        @Override
        public boolean canApply(int luck) {
            return this.lowerLuck <= luck && luck <= this.upperLuck;
        }
    }
}

