/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client;

import com.google.common.base.Preconditions;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import openmods.Log;
import org.lwjgl.opengl.GL11;

public class Icons {
    public static final int ICON_TYPE_BLOCK = 0;
    public static final int ICON_TYPE_ITEM = 1;

    private static void bindIconSheet(TextureManager tex, int type) {
        switch (type) {
            case 0: {
                tex.func_110577_a(TextureMap.field_110575_b);
                break;
            }
            case 1: {
                tex.func_110577_a(TextureMap.field_110576_c);
                break;
            }
            default: {
                Log.warn((String)"Unknown icon sheet: %d", (Object[])new Object[]{type});
            }
        }
    }

    public static void renderQuad(Tessellator tes, double scale, IIcon icon) {
        tes.func_78374_a(scale, scale, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tes.func_78374_a(scale, -scale, 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tes.func_78374_a(-scale, -scale, 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tes.func_78374_a(-scale, scale, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
    }

    public static IDrawableIcon itemIcon(String iconId, int color) {
        return new LoadableSingleIcon(iconId, color, 1);
    }

    public static IDrawableIcon itemIcon(String iconId) {
        return Icons.itemIcon(iconId, 0xFFFFFF);
    }

    public static IDrawableIcon blockIcon(String iconId, int color) {
        return new LoadableSingleIcon(iconId, color, 0);
    }

    public static IDrawableIcon blockIcon(String iconId) {
        return Icons.blockIcon(iconId, 0xFFFFFF);
    }

    public static class DisplayListWrapper
    implements IDrawableIcon {
        private final IDrawableIcon wrappedIcon;
        private Integer displayList;

        public DisplayListWrapper(IDrawableIcon wrappedIcon) {
            this.wrappedIcon = wrappedIcon;
        }

        @Override
        public void draw(TextureManager tex, double alpha, double scale) {
            if (this.displayList == null) {
                this.displayList = GL11.glGenLists((int)1);
                GL11.glNewList((int)this.displayList, (int)4864);
                this.wrappedIcon.draw(tex, alpha, scale);
                GL11.glEndList();
            }
            GL11.glCallList((int)this.displayList);
        }

        @Override
        public void registerIcons(int type, IIconRegister registry) {
            this.wrappedIcon.registerIcons(type, registry);
        }

        protected void finalize() throws Throwable {
            if (this.displayList != null) {
                GL11.glDeleteLists((int)this.displayList, (int)1);
            }
        }
    }

    public static class ComposedIcon
    implements IDrawableIcon {
        private final IDrawableIcon front;
        private final IDrawableIcon back;
        private final double scaleRatio;
        private final double distance;

        public ComposedIcon(IDrawableIcon front, IDrawableIcon back, double scaleRatio, double distance) {
            this.front = front;
            this.back = back;
            this.scaleRatio = scaleRatio;
            this.distance = distance;
        }

        @Override
        public void draw(TextureManager tex, double alpha, double scale) {
            this.back.draw(tex, alpha, scale * this.scaleRatio);
            GL11.glTranslated((double)0.0, (double)0.0, (double)(-this.distance));
            this.front.draw(tex, alpha, scale);
        }

        @Override
        public void registerIcons(int type, IIconRegister registry) {
            this.front.registerIcons(type, registry);
            this.back.registerIcons(type, registry);
        }
    }

    private static class LoadableSingleIcon
    extends SingleIcon {
        private final String iconId;

        private LoadableSingleIcon(String iconId, int color, int type) {
            super(color, type);
            this.iconId = iconId;
        }

        @Override
        public void registerIcons(int type, IIconRegister registry) {
            if (this.type == type) {
                this.icon = registry.func_94245_a(this.iconId);
            }
        }
    }

    public static class SingleIcon
    implements IDrawableIcon {
        protected IIcon icon;
        public final int color;
        public final int type;

        protected SingleIcon(int color, int type) {
            this.color = color;
            this.type = type;
        }

        public SingleIcon(IIcon icon, int color, int type) {
            this(color, type);
            this.icon = icon;
        }

        @Override
        public void draw(TextureManager tex, double alpha, double scale) {
            Preconditions.checkNotNull((Object)this.icon);
            Icons.bindIconSheet(tex, this.type);
            Tessellator tes = Tessellator.field_78398_a;
            tes.func_78382_b();
            tes.func_78373_b(0.0, 0.0, 0.0);
            tes.func_78384_a(this.color, MathHelper.func_76128_c((double)(255.0 * alpha)));
            Icons.renderQuad(tes, scale, this.icon);
            tes.func_78381_a();
        }

        @Override
        public void registerIcons(int type, IIconRegister registry) {
        }
    }

    public static interface IDrawableIcon {
        public void draw(TextureManager var1, double var2, double var4);

        public void registerIcons(int var1, IIconRegister var2);
    }
}

