/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client;

import com.google.common.collect.Lists;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import net.minecraftforge.common.MinecraftForge;
import openblocks.Config;
import openblocks.client.Icons;
import openblocks.client.SoundIconRegistry;
import openblocks.common.item.ItemSonicGlasses;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public class SoundEventsManager {
    public static final SoundEventsManager instance = new SoundEventsManager();
    public final SoundIconRegistry icons = new SoundIconRegistry();
    private final List<SoundEvent> events = Lists.newLinkedList();
    private Integer renderNotPumpkin;
    private static final ResourceLocation notPumpkin = new ResourceLocation("openblocks:textures/misc/glasses_obsidian.png");

    private SoundEventsManager() {
    }

    public void init() {
        this.icons.registerDefaults();
        MinecraftForge.EVENT_BUS.register((Object)this.icons);
    }

    public static boolean isEntityWearingGlasses(Entity e) {
        if (e instanceof EntityPlayer) {
            ItemStack helmet = ((EntityPlayer)e).field_71071_by.func_70440_f(3);
            return helmet != null && helmet.func_77973_b() instanceof ItemSonicGlasses;
        }
        return false;
    }

    public static boolean isPlayerWearingGlasses() {
        EntityLivingBase e = FMLClientHandler.instance().getClient().field_71451_h;
        return SoundEventsManager.isEntityWearingGlasses((Entity)e);
    }

    private void addEvent(float x, float y, float z, String soundId, double size, double time) {
        Icons.IDrawableIcon icon = this.icons.getIcon(soundId);
        this.events.add(new SoundEvent(x, y, z, icon, size, time));
    }

    @SubscribeEvent
    public void onSoundEvent(PlaySoundEvent17 evt) {
        if (SoundEventsManager.isPlayerWearingGlasses()) {
            ISound sound = evt.sound;
            this.addEvent(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i(), evt.name, Math.log(sound.func_147653_e() + 1.0f), 5.0f * sound.func_147655_f());
        }
    }

    public void tickUpdate() {
        Iterator<SoundEvent> it = this.events.iterator();
        while (it.hasNext()) {
            SoundEvent evt = it.next();
            evt.update();
            if (evt.isAlive()) continue;
            it.remove();
        }
    }

    private void dimWorld(TextureManager tex, Minecraft mc) {
        double level = Config.sonicGlassesOpacity;
        if (level <= 0.0) {
            return;
        }
        if (level >= 1.0 && !Config.sonicGlassesUseTexture) {
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glClear((int)16384);
            return;
        }
        if (this.renderNotPumpkin == null) {
            this.renderNotPumpkin = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.renderNotPumpkin, (int)4864);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glOrtho((double)-1.0, (double)1.0, (double)-1.0, (double)1.0, (double)-1.0, (double)1.0);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Tessellator tes = new Tessellator();
            tes.func_78382_b();
            double maxU = (double)mc.field_71443_c / 1024.0;
            double maxV = (double)mc.field_71440_d / 1024.0;
            if (Config.sonicGlassesUseTexture) {
                tes.func_78369_a(1.0f, 1.0f, 1.0f, (float)level);
                tex.func_110577_a(notPumpkin);
                tes.func_78374_a(-1.0, -1.0, 0.0, 0.0, 0.0);
                tes.func_78374_a(1.0, -1.0, 0.0, maxU, 0.0);
                tes.func_78374_a(1.0, 1.0, 0.0, maxU, maxV);
                tes.func_78374_a(-1.0, 1.0, 0.0, 0.0, maxV);
                tes.func_78381_a();
            } else {
                tes.func_78369_a(0.085f, 0.074f, 0.129f, (float)level);
                tes.func_78377_a(-1.0, -1.0, 0.0);
                tes.func_78377_a(1.0, -1.0, 0.0);
                tes.func_78377_a(1.0, 1.0, 0.0);
                tes.func_78377_a(-1.0, 1.0, 0.0);
                GL11.glDisable((int)3553);
                tes.func_78381_a();
                GL11.glEnable((int)3553);
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            GL11.glEndList();
        }
        GL11.glCallList((int)this.renderNotPumpkin);
    }

    protected void finalize() throws Throwable {
        if (this.renderNotPumpkin != null) {
            GL11.glDeleteLists((int)this.renderNotPumpkin, (int)1);
        }
    }

    @SubscribeEvent
    public void renderEvents(RenderWorldLastEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74320_O != 0) {
            return;
        }
        TextureManager tex = mc.field_71446_o;
        EntityLivingBase rve = mc.field_71451_h;
        if (!SoundEventsManager.isEntityWearingGlasses((Entity)rve)) {
            return;
        }
        GL11.glDisable((int)2912);
        GL11.glClear((int)256);
        this.dimWorld(tex, mc);
        double interpX = rve.field_70169_q + (rve.field_70165_t - rve.field_70169_q) * (double)evt.partialTicks;
        double interpY = rve.field_70167_r + (rve.field_70163_u - rve.field_70167_r) * (double)evt.partialTicks;
        double interpZ = rve.field_70166_s + (rve.field_70161_v - rve.field_70166_s) * (double)evt.partialTicks;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        for (SoundEvent snd : this.events) {
            double px = (double)snd.x - interpX;
            double py = (double)snd.y - interpY;
            double pz = (double)snd.z - interpZ;
            GL11.glPushMatrix();
            GL11.glTranslated((double)px, (double)py, (double)pz);
            RenderUtils.setupBillboard((Entity)rve);
            snd.icon.draw(tex, snd.getTime(evt.partialTicks), snd.size);
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    private static class SoundEvent {
        public final float x;
        public final float y;
        public final float z;
        public final Icons.IDrawableIcon icon;
        public final double size;
        private double time;
        private final double timeDeltaPerTick;

        private SoundEvent(float x, float y, float z, Icons.IDrawableIcon icon, double size, double TTL) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.icon = icon;
            this.size = size;
            this.time = 1.0;
            this.timeDeltaPerTick = 1.0 / (TTL * 20.0);
        }

        public void update() {
            this.time -= this.timeDeltaPerTick;
        }

        public boolean isAlive() {
            return this.time >= 0.0;
        }

        public double getTime(double partialTick) {
            return this.time - this.timeDeltaPerTick * partialTick;
        }
    }
}

