/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import com.google.common.collect.ImmutableList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import openblocks.client.gui.StandardPalette;
import openblocks.common.container.ContainerAutoEnchantmentTable;
import openblocks.common.tileentity.TileEntityAutoEnchantmentTable;
import openblocks.rpc.ILevelChanger;
import openmods.api.IValueReceiver;
import openmods.container.ContainerBase;
import openmods.gui.GuiConfigurableSlots;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.BaseComposite;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentSlider;
import openmods.gui.component.GuiComponentTab;
import openmods.gui.component.GuiComponentTankLevel;
import openmods.gui.listener.IValueChangedListener;
import openmods.gui.logic.IValueUpdateAction;
import openmods.gui.logic.ValueCopyAction;
import openmods.utils.MiscUtils;

public class GuiAutoEnchantmentTable
extends GuiConfigurableSlots<TileEntityAutoEnchantmentTable, ContainerAutoEnchantmentTable, TileEntityAutoEnchantmentTable.AutoSlots> {
    public GuiAutoEnchantmentTable(ContainerAutoEnchantmentTable container) {
        super((ContainerBase)container, 176, 175, "openblocks.gui.autoenchantmenttable");
    }

    protected Iterable<TileEntityAutoEnchantmentTable.AutoSlots> getSlots() {
        return ImmutableList.of((Object)((Object)TileEntityAutoEnchantmentTable.AutoSlots.input), (Object)((Object)TileEntityAutoEnchantmentTable.AutoSlots.xp), (Object)((Object)TileEntityAutoEnchantmentTable.AutoSlots.output));
    }

    protected void addCustomizations(BaseComposite root) {
        TileEntityAutoEnchantmentTable te = (TileEntityAutoEnchantmentTable)((ContainerAutoEnchantmentTable)this.getContainer()).getOwner();
        final ILevelChanger rpc = (ILevelChanger)te.createRpcProxy(ILevelChanger.class, new Class[0]);
        GuiComponentSlider slider = new GuiComponentSlider(44, 39, 45, 1, 30, 0);
        slider.setListener((IValueChangedListener)new IValueChangedListener<Integer>(){

            public void valueChanged(Integer value) {
                rpc.changeLevel(value);
            }
        });
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(te.getLevelProvider(), (IValueReceiver)slider));
        root.addComponent((BaseComponent)slider);
        final GuiComponentLabel maxLevel = new GuiComponentLabel(40, 25, "0");
        maxLevel.setMaxWidth(100);
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(te.getMaxLevelProvider(), (IValueReceiver)new IValueReceiver<Integer>(){

            public void setValue(Integer value) {
                maxLevel.setText(StatCollector.func_74837_a((String)"openblocks.gui.max_level", (Object[])new Object[]{value}));
            }
        }));
        root.addComponent((BaseComponent)maxLevel);
        GuiComponentTankLevel tankLevel = new GuiComponentTankLevel(140, 30, 17, 37, TileEntityAutoEnchantmentTable.TANK_CAPACITY);
        this.addSyncUpdateListener((IValueUpdateAction)ValueCopyAction.create(te.getFluidProvider(), (IValueReceiver)tankLevel.fluidReceiver()));
        root.addComponent((BaseComponent)tankLevel);
    }

    protected GuiComponentTab createTab(TileEntityAutoEnchantmentTable.AutoSlots slot) {
        switch (slot) {
            case input: {
                return new GuiComponentTab(StandardPalette.blue.getColor(), new ItemStack(Items.field_151046_w, 1), 100, 100);
            }
            case output: {
                ItemStack enchantedAxe = new ItemStack(Items.field_151046_w, 1);
                enchantedAxe.func_77966_a(Enchantment.field_77346_s, 1);
                return new GuiComponentTab(StandardPalette.lightblue.getColor(), enchantedAxe, 100, 100);
            }
            case xp: {
                return new GuiComponentTab(StandardPalette.green.getColor(), new ItemStack(Items.field_151133_ar, 1), 100, 100);
            }
        }
        throw MiscUtils.unhandledEnum((Enum)slot);
    }

    protected GuiComponentLabel createLabel(TileEntityAutoEnchantmentTable.AutoSlots slot) {
        switch (slot) {
            case input: {
                return new GuiComponentLabel(22, 82, StatCollector.func_74838_a((String)"openblocks.gui.autoextract"));
            }
            case output: {
                return new GuiComponentLabel(22, 82, StatCollector.func_74838_a((String)"openblocks.gui.autoeject"));
            }
            case xp: {
                return new GuiComponentLabel(22, 82, StatCollector.func_74838_a((String)"openblocks.gui.autodrink"));
            }
        }
        throw MiscUtils.unhandledEnum((Enum)slot);
    }
}

