/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import openblocks.OpenBlocks;
import openblocks.common.block.BlockGuide;
import openblocks.common.tileentity.TileEntityGuide;
import openmods.renderer.DisplayListWrapper;
import openmods.utils.Coord;
import openmods.utils.TextureUtils;
import org.lwjgl.opengl.GL11;

public class TileEntityGuideRenderer
extends TileEntitySpecialRenderer {
    private final DisplayListWrapper wrapper = new DisplayListWrapper(){

        public void compile() {
            Tessellator t = Tessellator.field_78398_a;
            RenderBlocks renderBlocks = new RenderBlocks();
            renderBlocks.func_147782_a(0.05, 0.05, 0.05, 0.95, 0.95, 0.95);
            t.func_78382_b();
            t.func_78380_c(200);
            renderBlocks.func_147798_e((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, BlockGuide.Icons.marker);
            renderBlocks.func_147764_f((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, BlockGuide.Icons.marker);
            renderBlocks.func_147768_a((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, BlockGuide.Icons.marker);
            renderBlocks.func_147806_b((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, BlockGuide.Icons.marker);
            renderBlocks.func_147761_c((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, BlockGuide.Icons.marker);
            renderBlocks.func_147734_d((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, BlockGuide.Icons.marker);
            t.func_78381_a();
        }
    };

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        TileEntityGuide guide = (TileEntityGuide)tileentity;
        if (guide.shouldRender()) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            float scaleDelta = guide.getTimeSinceChange();
            this.renderShape(guide.getShape(), guide.getColor(), scaleDelta);
            if ((double)scaleDelta < 1.0) {
                this.renderShape(guide.getPreviousShape(), guide.getColor(), 1.0f - scaleDelta);
            }
            GL11.glPopMatrix();
        }
    }

    private void renderShape(Collection<Coord> shape, int color, float scale) {
        if (shape == null) {
            return;
        }
        TextureUtils.bindDefaultTerrainTexture();
        GL11.glColor3ub((byte)((byte)(color >> 16)), (byte)((byte)(color >> 8)), (byte)((byte)(color >> 0)));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)2896);
        for (Coord coord : shape) {
            this.renderAt(coord.x, coord.y, coord.z, scale);
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    private void renderAt(double x, double y, double z, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.wrapper.render();
        GL11.glPopMatrix();
    }
}

