/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.eventhandler.ASMEventHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.IEventListener;
import cpw.mods.fml.common.eventhandler.ListenerList;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.TileEntityGrave;
import openmods.Log;
import openmods.inventory.GenericInventory;
import openmods.utils.InventoryUtils;
import openmods.world.DelayedActionTickHandler;
import org.apache.logging.log4j.Level;

public class PlayerDeathHandler {
    private static final IGravePlacementChecker POLITE = new IGravePlacementChecker(){

        @Override
        public boolean canPlaceGrave(World world, int x, int y, int z) {
            if (!world.func_72899_e(x, y, z)) {
                return false;
            }
            Block block = world.func_147439_a(x, y, z);
            return block.isAir((IBlockAccess)world, x, y, z) || block.isReplaceable((IBlockAccess)world, x, y, z);
        }
    };
    private static final IGravePlacementChecker BRUTAL = new IGravePlacementChecker(){

        @Override
        public boolean canPlaceGrave(World world, int x, int y, int z) {
            if (!world.func_72899_e(x, y, z)) {
                return false;
            }
            Block block = world.func_147439_a(x, y, z);
            return block.func_149712_f(world, x, y, z) >= 0.0f && world.func_147438_o(x, y, z) == null;
        }
    };

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerDrops(PlayerDropsEvent event) {
        if (OpenBlocks.Blocks.grave == null) {
            return;
        }
        ArrayList drops = event.drops;
        if (drops.isEmpty()) {
            return;
        }
        EntityLivingBase entity = event.entityLiving;
        if (!(entity instanceof EntityPlayer) || entity instanceof FakePlayer) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        World world = player.field_70170_p;
        if (world.field_72995_K || world.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        Log.debug((String)"Scheduling grave placement for player '%s' with %d items", (Object[])new Object[]{player.func_146103_bH(), drops.size()});
        if (Config.debugGraves) {
            PlayerDeathHandler.dumpDebugInfo(event);
        }
        DelayedActionTickHandler.INSTANCE.addTickCallback(world, (Runnable)new GraveCallable(world, player, drops));
        drops.clear();
        event.setCanceled(true);
    }

    private static void dumpDebugInfo(PlayerDropsEvent event) {
        int i = 0;
        for (EntityItem e : event.drops) {
            Log.debug((String)"\tGrave drop %d: %s -> %s", (Object[])new Object[]{i++, e.getClass(), e.func_92059_d()});
        }
        ListenerList listeners = event.getListenerList();
        try {
            int busId = 0;
            while (true) {
                Log.debug((String)"Dumping event %s listeners on bus %d", (Object[])new Object[]{event.getClass(), busId});
                for (IEventListener listener : listeners.getListeners(busId)) {
                    if (listener instanceof ASMEventHandler) {
                        try {
                            Object o = ReflectionHelper.getPrivateValue(ASMEventHandler.class, (Object)((ASMEventHandler)listener), (String[])new String[]{"handler"});
                            Log.debug((String)"\t%s", (Object[])new Object[]{o.getClass()});
                            continue;
                        }
                        catch (Throwable e) {
                            Log.log((Level)Level.DEBUG, (Throwable)e, (String)"Exception while getting field", (Object[])new Object[0]);
                        }
                    }
                    Log.debug((String)"\t%s", (Object[])new Object[]{listener.getClass()});
                }
                ++busId;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    private static class GraveCallable
    implements Runnable {
        private final String stiffName;
        private final int posX;
        private final int posY;
        private final int posZ;
        private final List<EntityItem> loot;
        private final WeakReference<World> world;

        public GraveCallable(World world, EntityPlayer exPlayer, List<EntityItem> loot) {
            this.stiffName = exPlayer.func_70005_c_();
            this.posX = MathHelper.func_76128_c((double)exPlayer.field_70165_t);
            this.posY = MathHelper.func_76128_c((double)exPlayer.field_70163_u);
            this.posZ = MathHelper.func_76128_c((double)exPlayer.field_70161_v);
            this.world = new WeakReference<World>(world);
            this.loot = ImmutableList.copyOf(loot);
        }

        private boolean tryPlaceGrave(World world, int x, int y, int z) {
            world.func_147465_d(x, y, z, (Block)OpenBlocks.Blocks.grave, 0, 3);
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile == null || !(tile instanceof TileEntityGrave)) {
                return false;
            }
            TileEntityGrave grave = (TileEntityGrave)tile;
            GenericInventory loot = new GenericInventory("tmpplayer", false, this.loot.size());
            for (EntityItem entityItem : this.loot) {
                ItemStack stack = entityItem.func_92059_d();
                if (stack == null) continue;
                InventoryUtils.insertItemIntoInventory((IInventory)loot, (ItemStack)stack.func_77946_l());
            }
            grave.setUsername(this.stiffName);
            grave.setLoot((IInventory)loot);
            return true;
        }

        private boolean tryPlaceGrave(World world, IGravePlacementChecker checker) {
            for (int distance = 0; distance < 5; ++distance) {
                for (int checkX = this.posX - distance; checkX <= this.posX + distance; ++checkX) {
                    for (int checkY = this.posY - distance; checkY <= this.posY + distance; ++checkY) {
                        for (int checkZ = this.posZ - distance; checkZ <= this.posZ + distance; ++checkZ) {
                            if (!checker.canPlaceGrave(world, checkX, checkY, checkZ) || !this.tryPlaceGrave(world, checkX, checkY, checkZ)) continue;
                            Log.debug((String)"Placing grave for player '%s' @ (%d,%d,%d)", (Object[])new Object[]{this.stiffName, checkX, checkY, checkZ});
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public void run() {
            World world = (World)this.world.get();
            if (world == null) {
                Log.warn((String)"Lost world while placing player %s grave", (Object[])new Object[]{this.stiffName});
                return;
            }
            if (this.tryPlaceGrave(world, POLITE)) {
                return;
            }
            if (Config.destructiveGraves) {
                Log.warn((String)"Failed to place grave for player %s, going berserk", (Object[])new Object[]{this.stiffName});
                if (this.tryPlaceGrave(world, BRUTAL)) {
                    return;
                }
            }
            for (EntityItem drop : this.loot) {
                world.func_72838_d((Entity)drop);
            }
        }
    }

    private static interface IGravePlacementChecker {
        public boolean canPlaceGrave(World var1, int var2, int var3, int var4);
    }
}

