/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.common.Stencil;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityCanvas;

public class BlockCanvas
extends OpenBlock {
    private int layer = 0;
    private int renderSide = 0;
    public IIcon baseIcon;
    public IIcon wallpaper;

    public BlockCanvas() {
        this(Material.field_151576_e);
    }

    public BlockCanvas(Material material) {
        super(material);
    }

    public void func_149651_a(IIconRegister registry) {
        this.field_149761_L = this.baseIcon = registry.func_94245_a("openblocks:canvas");
        this.wallpaper = registry.func_94245_a("openblocks:wallpaper");
        for (Stencil stencil : Stencil.values()) {
            stencil.registerBlockIcons(registry);
        }
    }

    protected void getCustomTileEntityDrops(TileEntity te, List<ItemStack> result, int fortune) {
        if (!(te instanceof TileEntityCanvas)) {
            return;
        }
        TileEntityCanvas tile = (TileEntityCanvas)te;
        if (tile.paintedBlock.containsValidBlock()) {
            Block paintedBlock = tile.paintedBlock.getValue();
            int paintedBlockMeta = tile.paintedBlockMeta.get();
            Random rand = te.func_145831_w().field_73012_v;
            int count = paintedBlock.quantityDropped(paintedBlockMeta, fortune, rand);
            int damageDropped = paintedBlock.func_149692_a(paintedBlockMeta);
            for (int i = 0; i < count; ++i) {
                Item item = paintedBlock.func_149650_a(paintedBlockMeta, rand, fortune);
                if (item == null) continue;
                result.add(new ItemStack(item, 1, damageDropped));
            }
        } else {
            result.add(new ItemStack((Block)this));
        }
    }

    protected boolean hasNormalDrops() {
        return false;
    }

    public void setLayerForRender(int layer) {
        this.layer = layer;
    }

    public void setSideForRender(int side) {
        this.renderSide = side;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return side == this.renderSide && super.func_149646_a(world, x, y, z, side);
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileEntityCanvas tile = (TileEntityCanvas)((Object)BlockCanvas.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityCanvas.class));
        return tile != null ? tile.getColorForRender(this.renderSide, this.layer) : -1;
    }

    public IIcon getUnrotatedTexture(ForgeDirection direction, IBlockAccess world, int x, int y, int z) {
        TileEntityCanvas tile = (TileEntityCanvas)((Object)BlockCanvas.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityCanvas.class));
        if (tile != null) {
            return tile.getTextureForRender(this.renderSide, this.layer);
        }
        return super.getUnrotatedTexture(direction, world, x, y, z);
    }

    public static void replaceBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block.func_149688_o() == Material.field_151592_s) {
            world.func_147449_b(x, y, z, (Block)OpenBlocks.Blocks.canvasGlass);
        } else {
            world.func_147449_b(x, y, z, (Block)OpenBlocks.Blocks.canvas);
        }
        TileEntityCanvas tile = (TileEntityCanvas)world.func_147438_o(x, y, z);
        tile.paintedBlock.setValue(block);
        tile.paintedBlockMeta.set(meta);
    }
}

