/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityFlag;
import openmods.block.BlockRotationMode;
import openmods.block.OpenBlock;

public class BlockFlag
extends OpenBlock {
    public static final int[] COLORS = new int[16];

    private static void setColor(int index, int red, int green, int blue) {
        BlockFlag.COLORS[index] = red % 256 << 16 | green % 256 << 8 | blue % 256;
    }

    public BlockFlag() {
        super(Material.field_151594_q);
        this.setupDimensionsFromCenter(0.5f, 0.0f, 0.5f, 0.0625f, 1.0f, 0.0625f);
        this.setRotationMode(BlockRotationMode.SIX_DIRECTIONS);
        this.setPlacementMode(OpenBlock.BlockPlacementMode.SURFACE);
        this.setInventoryRenderRotation(ForgeDirection.DOWN);
        this.setRenderMode(OpenBlock.RenderMode.TESR_ONLY);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149747_d(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntityFlag flag = (TileEntityFlag)((Object)BlockFlag.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityFlag.class));
        if (flag != null) {
            ForgeDirection onSurface = flag.getSurfaceDirection();
            if (onSurface == ForgeDirection.DOWN) {
                this.setupDimensionsFromCenter(0.5f, 0.0f, 0.5f, 0.0625f, 1.0f, 0.0625f);
            } else if (onSurface == ForgeDirection.EAST || onSurface == ForgeDirection.WEST) {
                this.setupDimensionsFromCenter(0.5f, 0.0f, 0.5f, 0.3125f, 1.0f, 0.0625f);
            } else {
                this.setupDimensionsFromCenter(0.5f, 0.0f, 0.5f, 0.0625f, 1.0f, 0.3125f);
            }
        }
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            Block belowBlock = world.func_147439_a(x, y - 1, z);
            if (belowBlock != null) {
                TileEntityFlag flag;
                if (belowBlock == Blocks.field_150422_aJ) {
                    return true;
                }
                if (belowBlock == this && (flag = (TileEntityFlag)((Object)BlockFlag.getTileEntity((IBlockAccess)world, (int)x, (int)(y - 1), (int)z, TileEntityFlag.class))) != null && flag.getSurfaceDirection().equals((Object)ForgeDirection.DOWN)) {
                    return true;
                }
            }
        } else if (side == ForgeDirection.UP) {
            return false;
        }
        return BlockFlag.isNeighborBlockSolid((IBlockAccess)world, (int)x, (int)y, (int)z, (ForgeDirection)side);
    }

    public boolean canRotateWithTool() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister registry) {
        this.field_149761_L = registry.func_94245_a("planks_oak");
    }

    static {
        BlockFlag.setColor(0, 20, 198, 0);
        BlockFlag.setColor(1, 41, 50, 156);
        BlockFlag.setColor(2, 221, 0, 0);
        BlockFlag.setColor(3, 255, 174, 201);
        BlockFlag.setColor(4, 185, 122, 87);
        BlockFlag.setColor(5, 181, 230, 29);
        BlockFlag.setColor(6, 0, 162, 232);
        BlockFlag.setColor(7, 128, 0, 64);
        BlockFlag.setColor(8, 255, 242, 0);
        BlockFlag.setColor(9, 255, 127, 39);
        BlockFlag.setColor(10, 255, 45, 45);
        BlockFlag.setColor(11, 255, 23, 151);
        BlockFlag.setColor(12, 195, 195, 195);
        BlockFlag.setColor(13, 163, 73, 164);
        BlockFlag.setColor(14, 0, 0, 0);
        BlockFlag.setColor(15, 255, 255, 255);
    }
}

