/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity.ai;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import openmods.OpenMods;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.utils.BlockProperties;
import openmods.utils.Coord;

public class EntityAIBreakBlock
extends EntityAIBase {
    private EntityLiving entity;
    private PathNavigate pathFinder;
    private Coord blockCoord;
    private int tickOffset = 0;
    private Random rand;

    public EntityAIBreakBlock(EntityLiving minime) {
        this.entity = minime;
        this.pathFinder = minime.func_70661_as();
        this.func_75248_a(3);
        this.rand = new Random(minime.func_145782_y());
        this.tickOffset = this.rand.nextInt(10);
    }

    public boolean func_75250_a() {
        boolean hasTicked;
        if (!this.pathFinder.func_75500_f()) {
            return false;
        }
        boolean bl = hasTicked = (OpenMods.proxy.getTicks(this.entity.field_70170_p) + (long)this.tickOffset) % 4L == 0L;
        if (hasTicked && this.entity.field_70170_p != null && !this.entity.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                int x = this.rand.nextInt(16) - 8;
                int y = this.rand.nextInt(3) - 1;
                int z = this.rand.nextInt(16) - 8;
                this.blockCoord = new Coord((int)((double)x + this.entity.field_70165_t), (int)((double)y + this.entity.field_70163_u), (int)((double)z + this.entity.field_70161_v));
                if (this.canHarvestBlock(this.blockCoord)) {
                    return true;
                }
                this.blockCoord = null;
            }
        }
        return false;
    }

    public void func_75251_c() {
        this.pathFinder.func_75499_g();
        this.blockCoord = null;
    }

    public boolean func_75253_b() {
        return this.entity.func_70089_S() && !this.pathFinder.func_75500_f() && this.blockCoord != null && this.canHarvestBlock(this.blockCoord);
    }

    public void func_75249_e() {
        if (this.blockCoord != null) {
            this.pathFinder.func_75492_a((double)this.blockCoord.x, (double)this.blockCoord.y, (double)this.blockCoord.z, 1.0);
        }
    }

    public void func_75246_d() {
        super.func_75246_d();
        final World world = this.entity.field_70170_p;
        if (world instanceof WorldServer && this.blockCoord != null && this.canHarvestBlock(this.blockCoord) && this.entity.func_70011_f(0.5 + (double)this.blockCoord.x, 0.5 + (double)this.blockCoord.y, 0.5 + (double)this.blockCoord.z) < 1.0) {
            FakePlayerPool.instance.executeOnPlayer((WorldServer)world, new FakePlayerPool.PlayerUser(){

                public void usePlayer(OpenModsFakePlayer fakePlayer) {
                    int meta;
                    fakePlayer.field_71071_by.field_70461_c = 0;
                    Block block = BlockProperties.getBlock((Coord)EntityAIBreakBlock.this.blockCoord, (World)world);
                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(((EntityAIBreakBlock)EntityAIBreakBlock.this).blockCoord.x, ((EntityAIBreakBlock)EntityAIBreakBlock.this).blockCoord.y, ((EntityAIBreakBlock)EntityAIBreakBlock.this).blockCoord.z, ((EntityAIBreakBlock)EntityAIBreakBlock.this).entity.field_70170_p, block, meta = BlockProperties.getBlockMetadata((Coord)EntityAIBreakBlock.this.blockCoord, (World)world), (EntityPlayer)fakePlayer);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        return;
                    }
                    if (ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)fakePlayer, (int)meta)) {
                        block.func_149636_a(world, (EntityPlayer)fakePlayer, ((EntityAIBreakBlock)EntityAIBreakBlock.this).blockCoord.x, ((EntityAIBreakBlock)EntityAIBreakBlock.this).blockCoord.y, ((EntityAIBreakBlock)EntityAIBreakBlock.this).blockCoord.z, meta);
                        world.func_147468_f(((EntityAIBreakBlock)EntityAIBreakBlock.this).blockCoord.x, ((EntityAIBreakBlock)EntityAIBreakBlock.this).blockCoord.y, ((EntityAIBreakBlock)EntityAIBreakBlock.this).blockCoord.z);
                    }
                    EntityAIBreakBlock.this.blockCoord = null;
                }
            });
        }
    }

    public boolean canHarvestBlock(Coord coord) {
        return BlockProperties.isFlower((Coord)coord, (World)this.entity.field_70170_p) || BlockProperties.getBlock((Coord)coord, (World)this.entity.field_70170_p) == Blocks.field_150478_aa;
    }
}

