/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import openblocks.OpenBlocks;
import openblocks.client.model.ModelSleepingBag;
import openmods.utils.BlockUtils;
import openmods.utils.ItemUtils;

public class ItemSleepingBag
extends ItemArmor {
    private static final String TAG_SPAWN_Z = "spawnz";
    private static final String TAG_SPAWN_Y = "spawny";
    private static final String TAG_SPAWN_X = "spawnx";
    private static final String TAG_SLEEPING = "sleeping";
    private static final int ARMOR_CHESTPIECE_TYPE = 1;
    private static final int ARMOR_CHESTPIECE_SLOT = 2;
    public static final String TEXTURE_SLEEPINGBAG = "openblocks:textures/models/sleepingbag.png";

    public ItemSleepingBag() {
        super(ItemArmor.ArmorMaterial.IRON, 2, 1);
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return TEXTURE_SLEEPINGBAG;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister registry) {
        this.field_77791_bV = registry.func_94245_a("openblocks:sleepingbag");
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        return armorSlot == 1 ? ModelSleepingBag.instance : null;
    }

    public ItemStack func_77659_a(ItemStack sleepingBagStack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            ItemStack currentArmor = player.func_82169_q(2);
            if (currentArmor != null) {
                currentArmor = currentArmor.func_77946_l();
            }
            ItemSleepingBag.setChestPieceSlot(player, sleepingBagStack.func_77946_l());
            if (currentArmor != null) {
                return currentArmor;
            }
            sleepingBagStack.field_77994_a = 0;
        }
        return sleepingBagStack;
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return armorType == 1;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (world.field_72995_K) {
            return;
        }
        if (player.func_70608_bn()) {
            return;
        }
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)itemStack);
        if (tag.func_74767_n(TAG_SLEEPING)) {
            ItemSleepingBag.revertSpawnFromTag(player, tag);
            tag.func_82580_o(TAG_SLEEPING);
            ItemSleepingBag.ejectSleepingBagFromPlayer(player);
        } else {
            int posZ;
            int posY;
            int posX = MathHelper.func_76128_c((double)player.field_70165_t);
            if (!world.func_147439_a(posX, (posY = MathHelper.func_76128_c((double)(player.field_70163_u + 1.0))) + 1, posZ = MathHelper.func_76128_c((double)player.field_70161_v)).isAir((IBlockAccess)world, posX, posY, posZ)) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("openblocks.misc.oh_no_ceiling", new Object[0]));
                ItemSleepingBag.ejectSleepingBagFromPlayer(player);
            } else {
                EntityPlayer.EnumStatus status = player.func_71018_a(posX, posY, posZ);
                if (status == EntityPlayer.EnumStatus.OK) {
                    ChunkCoordinates spawn = player.getBedLocation(world.field_73011_w.field_76574_g);
                    player.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    ItemSleepingBag.saveOriginalSpawn(spawn, tag);
                    tag.func_74757_a(TAG_SLEEPING, true);
                } else {
                    if (status == EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.noSleep", new Object[0]));
                    } else if (status == EntityPlayer.EnumStatus.NOT_SAFE) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.notSafe", new Object[0]));
                    }
                    ItemSleepingBag.ejectSleepingBagFromPlayer(player);
                }
            }
        }
    }

    private static void ejectSleepingBagFromPlayer(EntityPlayer player) {
        ItemStack stack = ItemSleepingBag.getChestpieceSlot(player);
        if (ItemSleepingBag.isSleepingBag(stack)) {
            ItemSleepingBag.setChestPieceSlot(player, null);
            BlockUtils.dropItemStackInWorld((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)stack);
        }
    }

    private static void revertSpawnFromTag(EntityPlayer player, NBTTagCompound tag) {
        if (tag.func_74764_b(TAG_SPAWN_X) && tag.func_74764_b(TAG_SPAWN_Y) && tag.func_74764_b(TAG_SPAWN_Z)) {
            ChunkCoordinates coords = new ChunkCoordinates(tag.func_74762_e(TAG_SPAWN_X), tag.func_74762_e(TAG_SPAWN_Y), tag.func_74762_e(TAG_SPAWN_Z));
            player.setSpawnChunk(coords, false, player.field_70170_p.field_73011_w.field_76574_g);
            tag.func_82580_o(TAG_SPAWN_X);
            tag.func_82580_o(TAG_SPAWN_Y);
            tag.func_82580_o(TAG_SPAWN_Z);
        }
    }

    private static void saveOriginalSpawn(ChunkCoordinates spawn, NBTTagCompound tag) {
        if (spawn != null) {
            tag.func_74768_a(TAG_SPAWN_X, spawn.field_71574_a);
            tag.func_74768_a(TAG_SPAWN_Y, spawn.field_71572_b);
            tag.func_74768_a(TAG_SPAWN_Z, spawn.field_71573_c);
        }
    }

    public static boolean isWearingSleepingBag(EntityPlayer player) {
        ItemStack armor = ItemSleepingBag.getChestpieceSlot(player);
        return ItemSleepingBag.isSleepingBag(armor);
    }

    private static boolean isSleepingBag(ItemStack armor) {
        return armor != null && armor.func_77973_b() instanceof ItemSleepingBag;
    }

    private static ItemStack setChestPieceSlot(EntityPlayer player, ItemStack chestpiece) {
        player.field_71071_by.field_70460_b[2] = chestpiece;
        return player.field_71071_by.field_70460_b[2];
    }

    private static ItemStack getChestpieceSlot(EntityPlayer player) {
        return player.field_71071_by.field_70460_b[2];
    }
}

