/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.api.IActivateAwareTile;
import openmods.api.INeighbourAwareTile;
import openmods.api.ISurfaceAttachment;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityBearTrap
extends SyncedTileEntity
implements IActivateAwareTile,
ISurfaceAttachment,
INeighbourAwareTile {
    public static final int OPENING_ANIMATION_TIME = 15;
    private SyncableFlags flags;
    private SyncableBoolean isLocked;
    private SyncableInt trappedEntityId;
    private int tickSinceOpened;

    public TileEntityBearTrap() {
        this.syncMap.addUpdateListener(new ISyncListener(){

            public void onSync(Set<ISyncableObject> changes) {
                if (changes.contains(TileEntityBearTrap.this.flags) && !TileEntityBearTrap.this.isShut()) {
                    TileEntityBearTrap.this.tickSinceOpened = 0;
                }
            }
        });
    }

    protected void createSyncedFields() {
        this.flags = SyncableFlags.create((int)Flags.values().length);
        this.trappedEntityId = new SyncableInt();
        this.isLocked = new SyncableBoolean();
        this.flags.on((Enum)Flags.isShut);
    }

    public void func_145845_h() {
        super.func_145845_h();
        ++this.tickSinceOpened;
        int entityId = this.trappedEntityId.get();
        if (entityId != 0) {
            this.immobilizeEntity(entityId);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    private void immobilizeEntity(int entityId) {
        Entity trappedEntity = this.field_145850_b.func_73045_a(entityId);
        if (trappedEntity != null) {
            trappedEntity.field_82151_R = 0.0f;
            trappedEntity.field_70140_Q = 0.0f;
            trappedEntity.field_70165_t = 0.5 + (double)this.field_145851_c;
            trappedEntity.field_70161_v = 0.5 + (double)this.field_145849_e;
            trappedEntity.field_70163_u = this.field_145848_d;
            trappedEntity.field_70169_q = 0.5 + (double)this.field_145851_c;
            trappedEntity.field_70166_s = 0.5 + (double)this.field_145849_e;
            trappedEntity.field_70167_r = this.field_145848_d;
            trappedEntity.field_70142_S = 0.5 + (double)this.field_145851_c;
            trappedEntity.field_70136_U = 0.5 + (double)this.field_145849_e;
            trappedEntity.field_70137_T = this.field_145848_d;
            trappedEntity.field_70159_w = 0.0;
            trappedEntity.field_70181_x = 0.0;
            trappedEntity.field_70179_y = 0.0;
        }
    }

    public void onEntityCollided(Entity entity) {
        if (!this.field_145850_b.field_72995_K && entity instanceof EntityCreature && !this.isLocked.get() && this.tickSinceOpened > 15) {
            this.close(entity);
        }
    }

    public boolean isShut() {
        return this.flags.get((Enum)Flags.isShut);
    }

    public int getComparatorLevel() {
        int entityId = this.trappedEntityId.get();
        if (entityId == 0) {
            return 0;
        }
        Entity e = this.field_145850_b.func_73045_a(entityId);
        if (e == null) {
            return 0;
        }
        return e.field_70168_am.ordinal() + 1;
    }

    public int ticksSinceOpened() {
        return this.tickSinceOpened;
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!this.field_145850_b.field_72995_K) {
            this.open();
        }
        return true;
    }

    private void close(Entity trapped) {
        if (!this.flags.get((Enum)Flags.isShut)) {
            this.flags.on((Enum)Flags.isShut);
            this.trappedEntityId.set(trapped.func_145782_y());
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "openblocks:beartrap.close", 0.5f, 1.0f);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    private void open() {
        if (this.flags.get((Enum)Flags.isShut)) {
            this.flags.off((Enum)Flags.isShut);
            this.trappedEntityId.set(0);
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "openblocks:beartrap.open", 0.5f, 1.0f);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public ForgeDirection getSurfaceDirection() {
        return ForgeDirection.DOWN;
    }

    public void onNeighbourChanged(Block block) {
        if (!this.field_145850_b.field_72995_K) {
            int redstoneLevel = this.field_145850_b.func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            boolean isLocked = redstoneLevel > 0;
            this.isLocked.set(isLocked);
            if (isLocked) {
                this.open();
            }
        }
    }

    public static enum Flags {
        isShut;

    }
}

