/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.ElevatorBlockRules;
import openblocks.events.ElevatorActionEvent;
import openmods.events.network.TileEntityMessageEventPacket;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.EnchantmentUtils;

public class TileEntityElevator
extends OpenTileEntity {
    private boolean canTeleportPlayer(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (block == null || block.isAir((IBlockAccess)this.field_145850_b, x, y, z)) {
            return true;
        }
        if (!Config.irregularBlocksArePassable) {
            return false;
        }
        AxisAlignedBB aabb = block.func_149668_a(this.field_145850_b, x, y, z);
        return aabb == null || aabb.func_72320_b() < 0.7;
    }

    private int findLevel(ForgeDirection direction) {
        Preconditions.checkArgument((direction == ForgeDirection.UP || direction == ForgeDirection.DOWN ? 1 : 0) != 0, (Object)"Must be either up or down... for now");
        int thisColor = this.getMetadata();
        int blocksInTheWay = 0;
        int delta = direction.offsetY;
        int y = this.field_145848_d;
        block4: for (int i = 0; i < Config.elevatorTravelDistance && this.field_145850_b.func_72899_e(this.field_145851_c, y += delta, this.field_145849_e); ++i) {
            int otherColor;
            TileEntity otherBlock;
            if (this.field_145850_b.func_147437_c(this.field_145851_c, y, this.field_145849_e)) continue;
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e);
            if (block == OpenBlocks.Blocks.elevator && (otherBlock = this.field_145850_b.func_147438_o(this.field_145851_c, y, this.field_145849_e)) instanceof TileEntityElevator && (otherColor = otherBlock.func_145832_p()) == thisColor && this.canTeleportPlayer(this.field_145851_c, y + 1, this.field_145849_e) && this.canTeleportPlayer(this.field_145851_c, y + 2, this.field_145849_e)) {
                return y;
            }
            ElevatorBlockRules.Action action = ElevatorBlockRules.instance.getActionForBlock(block);
            switch (action) {
                case ABORT: {
                    return -1;
                }
                case IGNORE: {
                    continue block4;
                }
                default: {
                    if (++blocksInTheWay > Config.elevatorMaxBlockPassCount) break block4;
                }
            }
        }
        return -1;
    }

    protected void initialize() {
    }

    private void activate(EntityPlayer player, ForgeDirection dir) {
        int level = this.findLevel(dir);
        if (level >= 0) {
            int distance = (int)Math.abs(player.field_70163_u - (double)level);
            boolean drainXP = Config.elevatorDrainsXP && !player.field_71075_bZ.field_75098_d;
            boolean doTeleport = false;
            if (drainXP) {
                int playerXP = EnchantmentUtils.getPlayerXP((EntityPlayer)player);
                if (playerXP >= distance) {
                    EnchantmentUtils.addPlayerXP((EntityPlayer)player, (int)(-distance));
                    doTeleport = true;
                }
            } else {
                doTeleport = true;
            }
            if (doTeleport) {
                player.func_70634_a((double)this.field_145851_c + 0.5, (double)level + 1.1, (double)this.field_145849_e + 0.5);
                this.field_145850_b.func_72956_a((Entity)player, "openblocks:elevator.activate", 1.0f, 1.0f);
            }
        }
    }

    public void onEvent(TileEntityMessageEventPacket event) {
        if (event instanceof ElevatorActionEvent) {
            ElevatorActionEvent elevatorEvent = (ElevatorActionEvent)event;
            if (elevatorEvent.sender != null) {
                switch (elevatorEvent.type) {
                    case JUMP: {
                        this.activate(event.sender, ForgeDirection.UP);
                        break;
                    }
                    case SNEAK: {
                        this.activate(event.sender, ForgeDirection.DOWN);
                    }
                }
            }
        }
    }
}

