/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.util;

import li.cil.oc.util.GameTimeFormatter;
import li.cil.oc.util.GameTimeFormatter$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

public final class GameTimeFormatter$ {
    public static final GameTimeFormatter$ MODULE$;
    private final String[] li$cil$oc$util$GameTimeFormatter$$weekDays;
    private final String[] li$cil$oc$util$GameTimeFormatter$$shortWeekDays;
    private final String[] li$cil$oc$util$GameTimeFormatter$$months;
    private final String[] li$cil$oc$util$GameTimeFormatter$$shortMonths;
    private final String[] li$cil$oc$util$GameTimeFormatter$$amPm;
    private final Map<Object, Function1<GameTimeFormatter.DateTime, String>> specifiers;
    private final int[][] monthLengths;

    static {
        new GameTimeFormatter$();
    }

    public String[] li$cil$oc$util$GameTimeFormatter$$weekDays() {
        return this.li$cil$oc$util$GameTimeFormatter$$weekDays;
    }

    public String[] li$cil$oc$util$GameTimeFormatter$$shortWeekDays() {
        return this.li$cil$oc$util$GameTimeFormatter$$shortWeekDays;
    }

    public String[] li$cil$oc$util$GameTimeFormatter$$months() {
        return this.li$cil$oc$util$GameTimeFormatter$$months;
    }

    public String[] li$cil$oc$util$GameTimeFormatter$$shortMonths() {
        return this.li$cil$oc$util$GameTimeFormatter$$shortMonths;
    }

    public String[] li$cil$oc$util$GameTimeFormatter$$amPm() {
        return this.li$cil$oc$util$GameTimeFormatter$$amPm;
    }

    private Map<Object, Function1<GameTimeFormatter.DateTime, String>> specifiers() {
        return this.specifiers;
    }

    private int[][] monthLengths() {
        return this.monthLengths;
    }

    private int[] monthLengthsForYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? this.monthLengths()[0] : this.monthLengths()[1];
    }

    public GameTimeFormatter.DateTime parse(double time) {
        long day = (long)(time / (double)24000);
        int weekDay = (int)((4L + day) % 7L);
        int year = 1970 + (int)((double)day / 364.2425);
        int yearDay = (int)((double)day % 364.2425);
        day = yearDay;
        int[] monthLengths = this.monthLengthsForYear(year);
        int month = 0;
        while (day >= (long)monthLengths[month]) {
            day -= (long)monthLengths[month];
            ++month;
        }
        int seconds = (int)(time % (double)24000 * (double)60 * (double)60 / (double)1000);
        int minutes = seconds / 60;
        int hours = minutes / 60 % 24;
        return new GameTimeFormatter.DateTime(year, month + 1, (int)day + 1, weekDay + 1, yearDay + 1, hours, minutes %= 60, seconds %= 60);
    }

    public String format(String format, GameTimeFormatter.DateTime time) {
        StringBuilder result2 = new StringBuilder();
        Iterator iterator = new StringOps(Predef$.MODULE$.augmentString(format)).iterator();
        while (iterator.hasNext()) {
            char c = BoxesRunTime.unboxToChar((Object)iterator.next());
            switch (c) {
                case '%': {
                    StringBuilder stringBuilder;
                    if (iterator.hasNext()) {
                        BoxedUnit boxedUnit;
                        Option option = this.specifiers().get(iterator.next());
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Function1 specifier = (Function1)some.x();
                            boxedUnit = result2.append((String)specifier.apply((Object)time));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        stringBuilder = boxedUnit;
                        break;
                    }
                }
                default: {
                    StringBuilder stringBuilder = result2.append(c);
                }
            }
        }
        return result2.toString();
    }

    public Option<Object> mktime(int year, int mon, int mday, int hour, int min2, int sec) {
        if (year < 1970 || mon < 1 || mon > 12) {
            return None$.MODULE$;
        }
        int[] monthLengths = this.monthLengthsForYear(year);
        int days = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)(year - 1970) * 365.2425)) + BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), mon - 1).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(monthLengths){
            private final int[] monthLengths$1;

            public final int apply(int d, int m) {
                return this.apply$mcIII$sp(d, m);
            }

            public int apply$mcIII$sp(int d, int m) {
                return d + this.monthLengths$1[m];
            }
            {
                this.monthLengths$1 = monthLengths$1;
            }
        })) + mday - 1;
        int secs = sec + (min2 + (hour - 1 + days * 24) * 60) * 60;
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)secs));
    }

    private GameTimeFormatter$() {
        MODULE$ = this;
        this.li$cil$oc$util$GameTimeFormatter$$weekDays = (String[])((Object[])new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"});
        this.li$cil$oc$util$GameTimeFormatter$$shortWeekDays = (String[])((Object[])new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"});
        this.li$cil$oc$util$GameTimeFormatter$$months = (String[])((Object[])new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"});
        this.li$cil$oc$util$GameTimeFormatter$$shortMonths = (String[])((Object[])new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"});
        this.li$cil$oc$util$GameTimeFormatter$$amPm = (String[])((Object[])new String[]{"AM", "PM"});
        this.specifiers = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'a')), (Object)new anonfun.2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'A')), (Object)new anonfun.3()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'b')), (Object)new anonfun.4()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'B')), (Object)new anonfun.5()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'c')), (Object)new anonfun.6()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'C')), (Object)new anonfun.7()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'d')), (Object)new anonfun.8()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'D')), (Object)new anonfun.9()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'e')), (Object)new anonfun.10()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'F')), (Object)new anonfun.11()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'h')), (Object)new anonfun.12()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'H')), (Object)new anonfun.13()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'I')), (Object)new anonfun.14()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'j')), (Object)new anonfun.15()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'m')), (Object)new anonfun.16()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'M')), (Object)new anonfun.17()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'n')), (Object)new anonfun.18()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'p')), (Object)new anonfun.19()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'r')), (Object)new anonfun.20()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'R')), (Object)new anonfun.21()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'S')), (Object)new anonfun.22()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'t')), (Object)new anonfun.23()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'T')), (Object)new anonfun.24()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'w')), (Object)new anonfun.25()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'x')), (Object)new anonfun.26()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'X')), (Object)new anonfun.27()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'y')), (Object)new anonfun.28()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'Y')), (Object)new anonfun.29()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'%')), (Object)new anonfun.30())}));
        this.monthLengths = (int[][])((Object[])new int[][]{{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}});
    }
}

