/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.lib.jse;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JseProcess {
    final Process process;
    final Thread input;
    final Thread output;
    final Thread error;

    public JseProcess(String[] cmd, InputStream stdin, OutputStream stdout, OutputStream stderr) throws IOException {
        this(Runtime.getRuntime().exec(cmd), stdin, stdout, stderr);
    }

    public JseProcess(String cmd, InputStream stdin, OutputStream stdout, OutputStream stderr) throws IOException {
        this(Runtime.getRuntime().exec(cmd), stdin, stdout, stderr);
    }

    private JseProcess(Process process2, InputStream stdin, OutputStream stdout, OutputStream stderr) {
        this.process = process2;
        this.input = stdin == null ? null : this.copyBytes(stdin, process2.getOutputStream(), null, process2.getOutputStream());
        this.output = stdout == null ? null : this.copyBytes(process2.getInputStream(), stdout, process2.getInputStream(), null);
        this.error = stderr == null ? null : this.copyBytes(process2.getErrorStream(), stderr, process2.getErrorStream(), null);
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public int waitFor() throws InterruptedException {
        int r = this.process.waitFor();
        if (this.input != null) {
            this.input.join();
        }
        if (this.output != null) {
            this.output.join();
        }
        if (this.error != null) {
            this.error.join();
        }
        this.process.destroy();
        return r;
    }

    private Thread copyBytes(final InputStream input, final OutputStream output, final InputStream ownedInput, final OutputStream ownedOutput) {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    byte[] buf = new byte[1024];
                    try {
                        int r;
                        while ((r = input.read(buf)) >= 0) {
                            output.write(buf, 0, r);
                        }
                    }
                    finally {
                        if (ownedInput != null) {
                            ownedInput.close();
                        }
                        if (ownedOutput != null) {
                            ownedOutput.close();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        return t;
    }
}

