/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.machine.luac;

import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.IdentityHashMap;
import li.cil.oc.OpenComputers$;
import li.cil.oc.Settings$;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.Item;
import li.cil.oc.api.driver.item.Memory;
import li.cil.oc.api.machine.Architecture;
import li.cil.oc.api.machine.ExecutionResult;
import li.cil.oc.api.machine.LimitReachedException;
import li.cil.oc.api.machine.Signal;
import li.cil.oc.common.SaveHandler$;
import li.cil.oc.server.machine.Machine;
import li.cil.oc.server.machine.Machine$State$;
import li.cil.oc.server.machine.luac.ComponentAPI;
import li.cil.oc.server.machine.luac.ComputerAPI;
import li.cil.oc.server.machine.luac.NativeLuaAPI;
import li.cil.oc.server.machine.luac.OSAPI;
import li.cil.oc.server.machine.luac.PersistenceAPI;
import li.cil.oc.server.machine.luac.SystemAPI;
import li.cil.oc.server.machine.luac.UnicodeAPI;
import li.cil.oc.server.machine.luac.UserdataAPI;
import li.cil.oc.util.ExtendedLuaState;
import li.cil.oc.util.ExtendedLuaState$;
import li.cil.oc.util.LuaStateFactory$;
import li.cil.repack.com.naef.jnlua.LuaGcMetamethodException;
import li.cil.repack.com.naef.jnlua.LuaMemoryAllocationException;
import li.cil.repack.com.naef.jnlua.LuaRuntimeException;
import li.cil.repack.com.naef.jnlua.LuaState;
import li.cil.repack.com.naef.jnlua.LuaType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.convert.WrapAsScala$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@Architecture.Name(value="Lua")
@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001=\u0011QCT1uSZ,G*^1Be\u000eD\u0017\u000e^3diV\u0014XM\u0003\u0002\u0004\t\u0005!A.^1d\u0015\t)a!A\u0004nC\u000eD\u0017N\\3\u000b\u0005\u001dA\u0011AB:feZ,'O\u0003\u0002\n\u0015\u0005\u0011qn\u0019\u0006\u0003\u00171\t1aY5m\u0015\u0005i\u0011A\u00017j\u0007\u0001\u00192\u0001\u0001\t\u0019!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bCA\r\u001e\u001b\u0005Q\"BA\u0003\u001c\u0015\ta\u0002\"A\u0002ba&L!A\b\u000e\u0003\u0019\u0005\u00138\r[5uK\u000e$XO]3\t\u0011\u0015\u0001!Q1A\u0005\u0002\u0001*\u0012!\t\t\u00033\tJ!a\t\u000e\u0003\u000f5\u000b7\r[5oK\"AQ\u0005\u0001B\u0001B\u0003%\u0011%\u0001\u0005nC\u000eD\u0017N\\3!\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\u0011\u0011f\u000b\t\u0003U\u0001i\u0011A\u0001\u0005\u0006\u000b\u0019\u0002\r!\t\u0005\t[\u0001\u0001\r\u0011\"\u0001\u0005]\u0005\u0019A.^1\u0016\u0003=\u0002\"\u0001M\u001d\u000e\u0003ER!AM\u001a\u0002\u000b)tG.^1\u000b\u0005Q*\u0014\u0001\u00028bK\u001aT!AN\u001c\u0002\u0007\r|WN\u0003\u00029\u0015\u00051!/\u001a9bG.L!AO\u0019\u0003\u00111+\u0018m\u0015;bi\u0016D\u0001\u0002\u0010\u0001A\u0002\u0013\u0005A!P\u0001\bYV\fw\fJ3r)\tqD\t\u0005\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005I\u0001\u0003V]&$\bbB#<\u0003\u0003\u0005\raL\u0001\u0004q\u0012\n\u0004BB$\u0001A\u0003&q&\u0001\u0003mk\u0006\u0004\u0003\u0002C%\u0001\u0001\u0004%\t\u0001\u0002&\u0002\u0019-,'O\\3m\u001b\u0016lwN]=\u0016\u0003-\u0003\"a\u0010'\n\u00055\u0003%aA%oi\"Aq\n\u0001a\u0001\n\u0003!\u0001+\u0001\tlKJtW\r\\'f[>\u0014\u0018p\u0018\u0013fcR\u0011a(\u0015\u0005\b\u000b:\u000b\t\u00111\u0001L\u0011\u0019\u0019\u0006\u0001)Q\u0005\u0017\u0006i1.\u001a:oK2lU-\\8ss\u0002B\u0001\"\u0016\u0001C\u0002\u0013\u0005AAV\u0001\te\u0006l7kY1mKV\tq\u000b\u0005\u0002@1&\u0011\u0011\f\u0011\u0002\u0007\t>,(\r\\3\t\rm\u0003\u0001\u0015!\u0003X\u0003%\u0011\u0018-\\*dC2,\u0007\u0005C\u0004^\u0001\t\u0007I\u0011\u00020\u0002\u0017A,'o]5ti\u0016t7-Z\u000b\u0002?B\u0011!\u0006Y\u0005\u0003C\n\u0011a\u0002U3sg&\u001cH/\u001a8dK\u0006\u0003\u0016\n\u0003\u0004d\u0001\u0001\u0006IaX\u0001\ra\u0016\u00148/[:uK:\u001cW\r\t\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0003\u0011\t\u0007/[:\u0016\u0003\u001d\u00042a\u00105k\u0013\tI\u0007IA\u0003BeJ\f\u0017\u0010\u0005\u0002+W&\u0011AN\u0001\u0002\r\u001d\u0006$\u0018N^3Mk\u0006\f\u0005+\u0013\u0005\u0007]\u0002\u0001\u000b\u0011B4\u0002\u000b\u0005\u0004\u0018n\u001d\u0011\t\rA\u0004A\u0011\u0001\u0003r\u0003\u0019IgN^8lKR\u00111J\u001d\u0005\u0006g>\u0004\r\u0001^\u0001\u0002MB\u0019q(^<\n\u0005Y\u0004%!\u0003$v]\u000e$\u0018n\u001c81!\ry\u0004\u000e\u001f\t\u0003\u007feL!A\u001f!\u0003\r\u0005s\u0017PU3g\u0011\u0019a\b\u0001\"\u0001\u0005{\u0006iAm\\2v[\u0016tG/\u0019;j_:$\"a\u0013@\t\u000bM\\\b\u0019A@\u0011\t}*\u0018\u0011\u0001\t\u0005\u0003\u0007\tIAD\u0002@\u0003\u000bI1!a\u0002A\u0003\u0019\u0001&/\u001a3fM&!\u00111BA\u0007\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0001!\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014\u0005i\u0011n]%oSRL\u0017\r\\5{K\u0012$\"!!\u0006\u0011\u0007}\n9\"C\u0002\u0002\u001a\u0001\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002\u001e\u0001!\t%a\b\u0002\u001fI,7m\\7qkR,W*Z7pef$B!!\u0006\u0002\"!A\u00111EA\u000e\u0001\u0004\t)#\u0001\u0006d_6\u0004xN\\3oiN\u0004R!EA\u0014\u0003WI1!!\u000b\u0013\u0005!IE/\u001a:bE2,\u0007\u0003BA\u0017\u0003wi!!a\f\u000b\t\u0005E\u00121G\u0001\u0005SR,WN\u0003\u0003\u00026\u0005]\u0012!C7j]\u0016\u001c'/\u00194u\u0015\t\tI$A\u0002oKRLA!!\u0010\u00020\tI\u0011\n^3n'R\f7m\u001b\u0005\b\u0003\u0003\u0002A\u0011BA\"\u00035iW-\\8ss&s')\u001f;fgR\u00191*!\u0012\t\u0011\u0005\r\u0012q\ba\u0001\u0003KAq!!\u0013\u0001\t\u0003\nY%A\bsk:\u001c\u0016P\\2ie>t\u0017N_3e)\u0005q\u0004bBA(\u0001\u0011\u0005\u0013\u0011K\u0001\feVtG\u000b\u001b:fC\u0012,G\r\u0006\u0003\u0002T\u0005e\u0003cA\r\u0002V%\u0019\u0011q\u000b\u000e\u0003\u001f\u0015CXmY;uS>t'+Z:vYRD\u0001\"a\u0017\u0002N\u0001\u0007\u0011QC\u0001\u0015SN\u001c\u0016P\\2ie>t\u0017N_3e%\u0016$XO\u001d8\t\u000f\u0005}\u0003\u0001\"\u0011\u0002\u0014\u0005Q\u0011N\\5uS\u0006d\u0017N_3\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002L\u0005IqN\\\"p]:,7\r\u001e\u0005\b\u0003O\u0002A\u0011IA&\u0003\u0015\u0019Gn\\:f\u0011\u001d\tY\u0007\u0001C\u0005\u0003[\nQa\u001d;bi\u0016,\"!a\u001c\u0011\r\u0005E\u00141PA@\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003s\u0002\u0015AC2pY2,7\r^5p]&!\u0011QPA:\u0005\u0015\u0019F/Y2l!\u0011\t\t)!%\u000f\t\u0005\r\u00151\u0012\b\u0005\u0003\u000b\u000b9)D\u0001\u0005\u0013\r\tI\tB\u0001\b\u001b\u0006\u001c\u0007.\u001b8f\u0013\u0011\ti)a$\u0002\u000bM#\u0018\r^3\u000b\u0007\u0005%E!\u0003\u0003\u0002\u0014\u0006U%!\u0002,bYV,\u0017bAAL\u0001\nYQI\\;nKJ\fG/[8oQ\u0011\tI'a'\u0011\u0007E\ti*C\u0002\u0002 J\u0011!\u0002R3qe\u0016\u001c\u0017\r^3e\u0011\u001d\t\u0019\u000b\u0001C!\u0003K\u000bA\u0001\\8bIR\u0019a(a*\t\u0011\u0005%\u0016\u0011\u0015a\u0001\u0003W\u000b1A\u001c2u!\u0011\ti+!-\u000e\u0005\u0005=&\u0002BAU\u0003gIA!a-\u00020\nqaJ\u0011+UC\u001e\u001cu.\u001c9pk:$\u0007bBA\\\u0001\u0011\u0005\u0013\u0011X\u0001\u0005g\u00064X\rF\u0002?\u0003wC\u0001\"!+\u00026\u0002\u0007\u00111\u0016\u0015\b\u0001\u0005}\u0016QZAh!\u0011\t\t-a2\u000f\u0007e\t\u0019-C\u0002\u0002Fj\tA\"\u0011:dQ&$Xm\u0019;ve\u0016LA!!3\u0002L\n!a*Y7f\u0015\r\t)MG\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003#\f1\u0001T;b\u0001")
public class NativeLuaArchitecture
implements Architecture {
    private final li.cil.oc.api.machine.Machine machine;
    private LuaState lua;
    private int kernelMemory;
    private final double ramScale;
    private final PersistenceAPI persistence;
    private final NativeLuaAPI[] apis;

    public li.cil.oc.api.machine.Machine machine() {
        return this.machine;
    }

    public LuaState lua() {
        return this.lua;
    }

    public void lua_$eq(LuaState x$1) {
        this.lua = x$1;
    }

    public int kernelMemory() {
        return this.kernelMemory;
    }

    public void kernelMemory_$eq(int x$1) {
        this.kernelMemory = x$1;
    }

    public double ramScale() {
        return this.ramScale;
    }

    private PersistenceAPI persistence() {
        return this.persistence;
    }

    private NativeLuaAPI[] apis() {
        return this.apis;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int invoke(Function0<Object[]> f) {
        try {
            Object[] objectArray = (Object[])f.apply();
            if (objectArray == null) {
                this.lua().pushBoolean(true);
                return 1;
            }
            Object[] objectArray2 = objectArray;
            this.lua().pushBoolean(true);
            Predef$.MODULE$.refArrayOps(objectArray2).foreach((Function1)new Serializable(this){
                private final /* synthetic */ NativeLuaArchitecture $outer;

                public final void apply(Object result2) {
                    ExtendedLuaState.ExtendedLuaState qual$1 = ExtendedLuaState$.MODULE$.extendLuaState(this.$outer.lua());
                    Object x$2 = result2;
                    IdentityHashMap<Object, Object> x$3 = qual$1.pushValue$default$2();
                    qual$1.pushValue(x$2, x$3);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            int n = 1 + objectArray2.length;
            int n2 = n;
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (Settings$.MODULE$.get().logLuaCallbackErrors() && !(throwable instanceof LimitReachedException)) {
                OpenComputers$.MODULE$.log().warn("Exception in Lua callback.", throwable);
            }
            boolean bl = false;
            IllegalArgumentException illegalArgumentException = null;
            Throwable throwable3 = throwable;
            if (throwable3 instanceof LimitReachedException) {
                return 0;
            }
            if (throwable3 instanceof IllegalArgumentException) {
                bl = true;
                illegalArgumentException = (IllegalArgumentException)throwable3;
                if (illegalArgumentException.getMessage() != null) {
                    this.lua().pushBoolean(false);
                    this.lua().pushString(illegalArgumentException.getMessage());
                    return 2;
                }
            }
            if (throwable3 != null && (throwable2 = throwable3).getMessage() != null) {
                this.lua().pushBoolean(true);
                this.lua().pushNil();
                this.lua().pushString(throwable2.getMessage());
                if (!Settings$.MODULE$.get().logLuaCallbackErrors()) return 3;
                this.lua().pushString(Predef$.MODULE$.refArrayOps((Object[])throwable2.getStackTrace()).mkString("", "\n", "\n"));
                return 4;
            }
            if (throwable3 instanceof IndexOutOfBoundsException) {
                this.lua().pushBoolean(false);
                this.lua().pushString("index out of bounds");
                return 2;
            }
            if (bl) {
                this.lua().pushBoolean(false);
                this.lua().pushString("bad argument");
                return 2;
            }
            if (throwable3 instanceof NoSuchMethodException) {
                this.lua().pushBoolean(false);
                this.lua().pushString("no such method");
                return 2;
            }
            if (throwable3 instanceof FileNotFoundException) {
                this.lua().pushBoolean(true);
                this.lua().pushNil();
                this.lua().pushString("file not found");
                return 3;
            }
            if (throwable3 instanceof SecurityException) {
                this.lua().pushBoolean(true);
                this.lua().pushNil();
                this.lua().pushString("access denied");
                return 3;
            }
            if (throwable3 instanceof IOException) {
                this.lua().pushBoolean(true);
                this.lua().pushNil();
                this.lua().pushString("i/o error");
                return 3;
            }
            if (throwable3 instanceof UnsupportedOperationException) {
                this.lua().pushBoolean(false);
                this.lua().pushString("unsupported operation");
                return 2;
            }
            if (throwable3 == null) throw new MatchError((Object)throwable3);
            Throwable throwable4 = throwable3;
            OpenComputers$.MODULE$.log().warn("Unexpected error in Lua callback.", throwable4);
            this.lua().pushBoolean(true);
            this.lua().pushNil();
            this.lua().pushString("unknown error");
            return 3;
        }
    }

    public int documentation(Function0<String> f) {
        int n;
        try {
            String doc = (String)f.apply();
            if (Strings.isNullOrEmpty((String)doc)) {
                this.lua().pushNil();
            } else {
                this.lua().pushString(doc);
            }
            n = 1;
        }
        catch (Throwable throwable) {
            this.lua().pushNil();
            this.lua().pushString(throwable.getMessage() == null ? throwable.toString() : throwable.getMessage());
            n = 2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.lua().pushNil();
            this.lua().pushString("no such method");
            n = 2;
        }
        return n;
    }

    @Override
    public boolean isInitialized() {
        return this.kernelMemory() > 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean recomputeMemory(Iterable<ItemStack> components) {
        memory = (int)package$.MODULE$.ceil((double)this.memoryInBytes(components) * this.ramScale());
        var3_3 = Option$.MODULE$.apply((Object)this.lua());
        if (!(var3_3 instanceof Some)) ** GOTO lbl-1000
        var4_4 = (Some)var3_3;
        l = (LuaState)var4_4.x();
        if (Settings$.MODULE$.get().limitMemory()) {
            l.setTotalMemory(0x7FFFFFFF);
            if (this.kernelMemory() > 0) {
                l.setTotalMemory(this.kernelMemory() + memory);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = BoxedUnit.UNIT;
            }
            var6_6 = v0;
        } else lbl-1000:
        // 2 sources

        {
            var6_7 = BoxedUnit.UNIT;
        }
        return memory > 0;
    }

    private int memoryInBytes(Iterable<ItemStack> components2) {
        return BoxesRunTime.unboxToInt((Object)WrapAsScala$.MODULE$.iterableAsScalaIterable(components2).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){

            public final int apply(int acc, ItemStack stack) {
                int n;
                Some some;
                Item driver;
                Option option = Option$.MODULE$.apply((Object)Driver.driverFor(stack));
                if (option instanceof Some && (driver = (Item)(some = (Some)option).x()) instanceof Memory) {
                    Memory memory = (Memory)driver;
                    int[] sizes = Settings$.MODULE$.get().ramSizes();
                    int tier = (int)package$.MODULE$.round(memory.amount(stack)) - 1;
                    n = sizes[RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(tier), 0)), sizes.length - 1)] * 1024;
                } else {
                    n = 0;
                }
                return acc + n;
            }
        }));
    }

    @Override
    public void runSynchronized() {
        Predef$.MODULE$.assert(this.lua().getTop() == 2);
        Predef$.MODULE$.assert(this.lua().isThread(1));
        Predef$.MODULE$.assert(this.lua().isFunction(2));
        try {
            this.lua().call(0, 1);
            this.lua().checkType(2, LuaType.TABLE);
            return;
        }
        catch (LuaMemoryAllocationException luaMemoryAllocationException) {
            throw new OutOfMemoryError("not enough memory");
        }
    }

    @Override
    public ExecutionResult runThreaded(boolean isSynchronizedReturn) {
        Throwable throwable2;
        block26: {
            ExecutionResult executionResult;
            try {
                int results;
                int n;
                Predef$.MODULE$.assert(this.lua().isThread(1));
                if (isSynchronizedReturn) {
                    Predef$.MODULE$.assert(this.lua().getTop() == 2);
                    Predef$.MODULE$.assert(this.lua().isTable(2));
                    n = this.lua().resume(1, 1);
                } else if (this.kernelMemory() == 0) {
                    if (this.lua().resume(1, 0) > 0) {
                        n = 0;
                    } else {
                        this.lua().gc(LuaState.GcAction.COLLECT, 0);
                        this.kernelMemory_$eq(package$.MODULE$.max(this.lua().getTotalMemory() - this.lua().getFreeMemory(), 1));
                        this.recomputeMemory(this.machine().host().internalComponents());
                        this.lua().pushInteger(0);
                        n = 1;
                    }
                } else {
                    int n2;
                    Signal signal2 = this.machine().popSignal();
                    if (signal2 == null) {
                        n2 = this.lua().resume(1, 0);
                    } else {
                        this.lua().pushString(signal2.name());
                        Predef$.MODULE$.refArrayOps(signal2.args()).foreach((Function1)new Serializable(this){
                            private final /* synthetic */ NativeLuaArchitecture $outer;

                            public final void apply(Object arg) {
                                ExtendedLuaState.ExtendedLuaState qual$2 = ExtendedLuaState$.MODULE$.extendLuaState(this.$outer.lua());
                                Object x$4 = arg;
                                IdentityHashMap<Object, Object> x$5 = qual$2.pushValue$default$2();
                                qual$2.pushValue(x$4, x$5);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        n2 = this.lua().resume(1, 1 + signal2.args().length);
                    }
                    n = results = n2;
                }
                if (this.lua().status(1) == 1) {
                    if (results == 1 && this.lua().isFunction(2)) {
                        executionResult = new ExecutionResult.SynchronizedCall();
                    } else if (results == 1 && this.lua().isBoolean(2)) {
                        executionResult = new ExecutionResult.Shutdown(this.lua().toBoolean(2));
                    } else {
                        int ticks = results == 1 && this.lua().isNumber(2) ? (int)(this.lua().toNumber(2) * (double)20) : Integer.MAX_VALUE;
                        this.lua().pop(results);
                        executionResult = new ExecutionResult.Sleep(ticks);
                    }
                } else {
                    Predef$.MODULE$.assert(this.lua().isThread(1));
                    if (!this.lua().isBoolean(2) || !this.lua().isString(3) && !this.lua().isNoneOrNil(3)) {
                        OpenComputers$.MODULE$.log().warn("Kernel returned unexpected results.");
                    }
                    if (this.lua().toBoolean(2)) {
                        OpenComputers$.MODULE$.log().warn("Kernel stopped unexpectedly.");
                        executionResult = new ExecutionResult.Shutdown(false);
                    } else {
                        String error2;
                        if (Settings$.MODULE$.get().limitMemory()) {
                            this.lua().setTotalMemory(Integer.MAX_VALUE);
                        }
                        String string = error2 = this.lua().isJavaObjectRaw(3) ? this.lua().toJavaObjectRaw(3).toString() : this.lua().toString(3);
                        executionResult = error2 == null ? new ExecutionResult.Error("unknown error") : new ExecutionResult.Error(error2);
                    }
                }
            }
            catch (Throwable throwable2) {
                ExecutionResult.Error error3;
                Throwable throwable3 = throwable2;
                if (throwable3 instanceof LuaRuntimeException) {
                    LuaRuntimeException luaRuntimeException = (LuaRuntimeException)throwable3;
                    OpenComputers$.MODULE$.log().warn(new StringBuilder().append((Object)"Kernel crashed. This is a bug!\n").append((Object)luaRuntimeException.toString()).append((Object)"\tat ").append((Object)Predef$.MODULE$.refArrayOps((Object[])luaRuntimeException.getLuaStackTrace()).mkString("\n\tat ")).toString());
                    error3 = new ExecutionResult.Error("kernel panic: this is a bug, check your log file and report it");
                } else if (throwable3 instanceof LuaGcMetamethodException) {
                    LuaGcMetamethodException luaGcMetamethodException = (LuaGcMetamethodException)throwable3;
                    error3 = luaGcMetamethodException.getMessage() == null ? new ExecutionResult.Error("kernel panic:\nerror in garbage collection metamethod") : new ExecutionResult.Error(new StringBuilder().append((Object)"kernel panic:\n").append((Object)luaGcMetamethodException.getMessage()).toString());
                } else if (throwable3 instanceof LuaMemoryAllocationException) {
                    error3 = new ExecutionResult.Error("not enough memory");
                } else {
                    if (!(throwable3 instanceof Error)) break block26;
                    Error error4 = (Error)throwable3;
                    String string = error4.getMessage();
                    String string2 = "not enough memory";
                    if (string != null ? !string.equals(string2) : string2 != null) break block26;
                    error3 = new ExecutionResult.Error("not enough memory");
                }
                executionResult = error3;
            }
            return executionResult;
        }
        throw throwable2;
    }

    @Override
    public boolean initialize() {
        Option<LuaState> option = LuaStateFactory$.MODULE$.createState();
        if (None$.MODULE$.equals(option)) {
            this.lua_$eq(null);
            this.machine().crash("native libraries not available");
            return false;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            LuaState value = (LuaState)some.x();
            this.lua_$eq(value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Predef$.MODULE$.refArrayOps((Object[])this.apis()).foreach((Function1)new Serializable(this){

                public final void apply(NativeLuaAPI x$1) {
                    x$1.initialize();
                }
            });
            this.lua().load(Machine.class.getResourceAsStream(new StringBuilder().append((Object)Settings$.MODULE$.scriptPath()).append((Object)"machine.lua").toString()), "=kernel", "t");
            this.lua().newThread();
            return true;
        }
        throw new MatchError(option);
    }

    @Override
    public void onConnect() {
    }

    @Override
    public void close() {
        if (this.lua() != null) {
            if (Settings$.MODULE$.get().limitMemory()) {
                this.lua().setTotalMemory(Integer.MAX_VALUE);
            }
            this.lua().close();
        }
        this.lua_$eq(null);
        this.kernelMemory_$eq(0);
    }

    @Deprecated
    private Stack<Enumeration.Value> state() {
        return ((Machine)this.machine()).state();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void load(NBTTagCompound nbt) {
        if (!this.machine().isRunning()) return;
        if (Settings$.MODULE$.get().limitMemory()) {
            this.lua().setTotalMemory(Integer.MAX_VALUE);
        }
        try {
            Constable constable;
            this.lua().setTop(0);
            this.persistence().unpersist(SaveHandler$.MODULE$.load(nbt, new StringBuilder().append((Object)this.machine().node().address()).append((Object)"_kernel").toString()));
            if (!this.lua().isThread(1)) throw new LuaRuntimeException("Invalid kernel.");
            if (this.state().contains((Object)Machine$State$.MODULE$.SynchronizedCall()) || this.state().contains((Object)Machine$State$.MODULE$.SynchronizedReturn())) {
                this.persistence().unpersist(SaveHandler$.MODULE$.load(nbt, new StringBuilder().append((Object)this.machine().node().address()).append((Object)"_stack").toString()));
                if (!(this.state().contains((Object)Machine$State$.MODULE$.SynchronizedCall()) ? this.lua().isFunction(2) : this.lua().isTable(2))) {
                    throw new LuaRuntimeException("Invalid stack.");
                }
            }
            this.kernelMemory_$eq((int)((double)nbt.func_74762_e("kernelMemory") * this.ramScale()));
            Predef$.MODULE$.refArrayOps((Object[])this.apis()).foreach((Function1)new Serializable(this, nbt){
                private final NBTTagCompound nbt$2;

                public final void apply(NativeLuaAPI api) {
                    api.load(this.nbt$2);
                }
                {
                    this.nbt$2 = nbt$2;
                }
            });
            try {
                constable = BoxesRunTime.boxToInteger((int)this.lua().gc(LuaState.GcAction.COLLECT, 0));
            }
            catch (Throwable throwable) {
                OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error cleaning up loaded computer @ (", ", ", ", ", "). This either means the server is badly overloaded or a user created an evil __gc method, accidentally or not."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.machine().host().xPosition()), BoxesRunTime.boxToDouble((double)this.machine().host().yPosition()), BoxesRunTime.boxToDouble((double)this.machine().host().zPosition())})));
                constable = BoxesRunTime.boxToBoolean((boolean)this.machine().crash("error in garbage collector, most likely __gc method timed out"));
            }
        }
        catch (LuaRuntimeException luaRuntimeException) {
            throw new Exception(new StringBuilder().append((Object)luaRuntimeException.toString()).append((Object)(Predef$.MODULE$.refArrayOps((Object[])luaRuntimeException.getLuaStackTrace()).isEmpty() ? "" : new StringBuilder().append((Object)"\tat ").append((Object)Predef$.MODULE$.refArrayOps((Object[])luaRuntimeException.getLuaStackTrace()).mkString("\n\tat ")).toString())).toString(), luaRuntimeException);
        }
        this.recomputeMemory(this.machine().host().internalComponents());
    }

    @Override
    public void save(NBTTagCompound nbt) {
        Constable constable;
        if (Settings$.MODULE$.get().limitMemory()) {
            this.lua().setTotalMemory(Integer.MAX_VALUE);
        }
        try {
            Predef$.MODULE$.assert(this.lua().isThread(1));
            SaveHandler$.MODULE$.scheduleSave(this.machine().host(), nbt, new StringBuilder().append((Object)this.machine().node().address()).append((Object)"_kernel").toString(), this.persistence().persist(1));
            if (this.state().contains((Object)Machine$State$.MODULE$.SynchronizedCall()) || this.state().contains((Object)Machine$State$.MODULE$.SynchronizedReturn())) {
                Predef$.MODULE$.assert(this.state().contains((Object)Machine$State$.MODULE$.SynchronizedCall()) ? this.lua().isFunction(2) : this.lua().isTable(2));
                SaveHandler$.MODULE$.scheduleSave(this.machine().host(), nbt, new StringBuilder().append((Object)this.machine().node().address()).append((Object)"_stack").toString(), this.persistence().persist(2));
            }
            nbt.func_74768_a("kernelMemory", (int)package$.MODULE$.ceil((double)this.kernelMemory() / this.ramScale()));
            Predef$.MODULE$.refArrayOps((Object[])this.apis()).foreach((Function1)new Serializable(this, nbt){
                private final NBTTagCompound nbt$1;

                public final void apply(NativeLuaAPI api) {
                    api.save(this.nbt$1);
                }
                {
                    this.nbt$1 = nbt$1;
                }
            });
            try {
                constable = BoxesRunTime.boxToInteger((int)this.lua().gc(LuaState.GcAction.COLLECT, 0));
            }
            catch (Throwable throwable) {
                OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error cleaning up loaded computer @ (", ", ", ", ", "). This either means the server is badly overloaded or a user created an evil __gc method, accidentally or not."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.machine().host().xPosition()), BoxesRunTime.boxToDouble((double)this.machine().host().yPosition()), BoxesRunTime.boxToDouble((double)this.machine().host().zPosition())})));
                constable = BoxesRunTime.boxToBoolean((boolean)this.machine().crash("error in garbage collector, most likely __gc method timed out"));
            }
        }
        catch (LuaGcMetamethodException luaGcMetamethodException) {
            OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not persist computer @ (", ", ", ", ", ").\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.machine().host().xPosition()), BoxesRunTime.boxToDouble((double)this.machine().host().yPosition()), BoxesRunTime.boxToDouble((double)this.machine().host().zPosition()), luaGcMetamethodException.toString()})));
            nbt.func_82580_o("state");
            constable = BoxedUnit.UNIT;
        }
        catch (LuaRuntimeException luaRuntimeException) {
            OpenComputers$.MODULE$.log().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not persist computer @ (", ", ", ", ", ").\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.machine().host().xPosition()), BoxesRunTime.boxToDouble((double)this.machine().host().yPosition()), BoxesRunTime.boxToDouble((double)this.machine().host().zPosition()), luaRuntimeException.toString()}))).append((Object)(Predef$.MODULE$.refArrayOps((Object[])luaRuntimeException.getLuaStackTrace()).isEmpty() ? "" : new StringBuilder().append((Object)"\tat ").append((Object)Predef$.MODULE$.refArrayOps((Object[])luaRuntimeException.getLuaStackTrace()).mkString("\n\tat ")).toString())).toString());
            nbt.func_82580_o("state");
            constable = BoxedUnit.UNIT;
        }
        this.recomputeMemory(this.machine().host().internalComponents());
    }

    public NativeLuaArchitecture(li.cil.oc.api.machine.Machine machine) {
        this.machine = machine;
        this.lua = null;
        this.kernelMemory = 0;
        this.ramScale = LuaStateFactory$.MODULE$.is64Bit() ? Settings$.MODULE$.get().ramScaleFor64Bit() : 1.0;
        this.persistence = new PersistenceAPI(this);
        this.apis = (NativeLuaAPI[])((Object[])new NativeLuaAPI[]{new ComponentAPI(this), new ComputerAPI(this), new OSAPI(this), new SystemAPI(this), new UnicodeAPI(this), new UserdataAPI(this), this.persistence()});
    }
}

