/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.util;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import li.cil.oc.OpenComputers$;
import li.cil.oc.Settings$;
import li.cil.oc.server.machine.Machine;
import li.cil.oc.util.ExtendedLuaState$;
import li.cil.oc.util.LuaStateFactory$Architecture$;
import li.cil.repack.com.naef.jnlua.LuaState;
import li.cil.repack.com.naef.jnlua.NativeSupport;
import org.apache.commons.lang3.SystemUtils;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

public final class LuaStateFactory$ {
    public static final LuaStateFactory$ MODULE$;
    private boolean haveNativeLibrary;
    private String li$cil$oc$util$LuaStateFactory$$currentLib;
    private final String libraryName;
    private final boolean is64Bit;

    static {
        new LuaStateFactory$();
    }

    private boolean haveNativeLibrary() {
        return this.haveNativeLibrary;
    }

    private void haveNativeLibrary_$eq(boolean x$1) {
        this.haveNativeLibrary = x$1;
    }

    public String li$cil$oc$util$LuaStateFactory$$currentLib() {
        return this.li$cil$oc$util$LuaStateFactory$$currentLib;
    }

    private void li$cil$oc$util$LuaStateFactory$$currentLib_$eq(String x$1) {
        this.li$cil$oc$util$LuaStateFactory$$currentLib = x$1;
    }

    private String libraryName() {
        return this.libraryName;
    }

    public boolean isAvailable() {
        return this.haveNativeLibrary();
    }

    public boolean is64Bit() {
        return this.is64Bit;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public void init() {
        File tmpLibFile;
        block24: {
            Object object;
            String path;
            URL libraryUrl;
            if (this.libraryName() == null) {
                return;
            }
            if (SystemUtils.IS_OS_WINDOWS && !Settings$.MODULE$.get().alwaysTryNative()) {
                if (SystemUtils.IS_OS_WINDOWS_XP) {
                    OpenComputers$.MODULE$.log().warn("Sorry, but Windows XP isn't supported. I'm afraid you'll have to use a newer Windows. I very much recommend upgrading your Windows, anyway, since Microsoft has stopped supporting Windows XP in April 2014.");
                    return;
                }
                if (SystemUtils.IS_OS_WINDOWS_2003) {
                    OpenComputers$.MODULE$.log().warn("Sorry, but Windows Server 2003 isn't supported. I'm afraid you'll have to use a newer Windows.");
                    return;
                }
            }
            if ((libraryUrl = Machine.class.getResource(new StringBuilder().append((Object)"/assets/").append((Object)Settings$.MODULE$.resourceDomain()).append((Object)"/lib/").append((Object)this.libraryName()).toString())) == null) {
                OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Native library with name '", "' not found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.libraryName()})));
                return;
            }
            String tmpLibName = new StringBuilder().append((Object)"OpenComputersMod-1.5.2.9-").append((Object)this.libraryName()).toString();
            String tmpBasePath = Settings$.MODULE$.get().nativeInTmpDir() ? ((path = System.getProperty("java.io.tmpdir")) == null ? "" : (path.endsWith("/") || path.endsWith("\\") ? path : new StringBuilder().append((Object)path).append((Object)"/").toString())) : "";
            tmpLibFile = new File(new StringBuilder().append((Object)tmpBasePath).append((Object)tmpLibName).toString());
            if (tmpLibFile.exists()) {
                boolean matching = true;
                try {
                    InputStream inCurrent = libraryUrl.openStream();
                    FileInputStream inExisting = new FileInputStream(tmpLibFile);
                    int inCurrentByte = 0;
                    int inExistingByte = 0;
                    do {
                        if ((inCurrentByte = inCurrent.read()) == (inExistingByte = inExisting.read())) continue;
                        matching = false;
                        inCurrentByte = -1;
                        inExistingByte = -1;
                    } while (inCurrentByte != -1 && inExistingByte != -1);
                    inCurrent.close();
                    inExisting.close();
                }
                catch (Throwable throwable) {
                    matching = false;
                }
                if (!matching) {
                    Boolean bl;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)tmpLibFile.delete());
                    }
                    catch (Throwable throwable) {
                        bl = BoxedUnit.UNIT;
                    }
                    if (tmpLibFile.exists()) {
                        OpenComputers$.MODULE$.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not update native library '", "'!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpLibFile.getName()})));
                    }
                }
            }
            try {
                ReadableByteChannel in = Channels.newChannel(libraryUrl.openStream());
                FileChannel out = new FileOutputStream(tmpLibFile).getChannel();
                out.transferFrom(in, 0L, Long.MAX_VALUE);
                tmpLibFile.deleteOnExit();
                tmpLibFile.setReadable(true, false);
                tmpLibFile.setWritable(true, false);
                boolean bl = tmpLibFile.setExecutable(true, false);
                out.close();
                in.close();
                object = BoxesRunTime.boxToBoolean((boolean)bl);
                break block24;
                {
                    catch (Throwable throwable) {
                        try {
                            void var15_13;
                            var15_13.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            void var13_12;
                            var13_12.close();
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object = BoxedUnit.UNIT;
            }
        }
        this.li$cil$oc$util$LuaStateFactory$$currentLib_$eq(tmpLibFile.getAbsolutePath());
        try {
            new LuaState().close();
            OpenComputers$.MODULE$.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found a compatible native library: '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpLibFile.getName()})));
            this.haveNativeLibrary_$eq(true);
        }
        catch (Throwable throwable) {
            if (Settings$.MODULE$.get().logFullLibLoadErrors()) {
                OpenComputers$.MODULE$.log().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not load native library '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpLibFile.getName()})), throwable);
            } else {
                OpenComputers$.MODULE$.log().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not load native library '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpLibFile.getName()})));
            }
            tmpLibFile.delete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<LuaState> createState() {
        if (!this.haveNativeLibrary()) return None$.MODULE$;
        LuaState state = Settings$.MODULE$.get().limitMemory() ? new LuaState(Integer.MAX_VALUE) : new LuaState();
        try {
            state.openLib(LuaState.Library.BASE);
            state.openLib(LuaState.Library.BIT32);
            state.openLib(LuaState.Library.COROUTINE);
            state.openLib(LuaState.Library.DEBUG);
            state.openLib(LuaState.Library.ERIS);
            state.openLib(LuaState.Library.MATH);
            state.openLib(LuaState.Library.STRING);
            state.openLib(LuaState.Library.TABLE);
            state.pop(8);
            if (!Settings$.MODULE$.get().disableLocaleChanging()) {
                state.openLib(LuaState.Library.OS);
                state.getField(-1, "setlocale");
                state.pushString("C");
                state.call(1, 0);
                state.pop(1);
            }
            state.newTable();
            state.setGlobal("os");
            state.pushNil();
            state.setGlobal("unpack");
            state.pushNil();
            state.setGlobal("loadstring");
            state.getGlobal("math");
            state.pushNil();
            state.setField(-2, "log10");
            state.pop(1);
            state.getGlobal("table");
            state.pushNil();
            state.setField(-2, "maxn");
            state.pop(1);
            state.pushNil();
            state.setGlobal("dofile");
            state.pushNil();
            state.setGlobal("loadfile");
            state.getGlobal("math");
            Random random2 = new Random();
            ExtendedLuaState$.MODULE$.extendLuaState(state).pushScalaFunction((Function1<LuaState, Object>)new Serializable(random2){
                private final Random random$1;

                public final int apply(LuaState lua) {
                    double r = this.random$1.nextDouble();
                    int n = lua.getTop();
                    switch (n) {
                        default: {
                            throw new IllegalArgumentException("wrong number of arguments");
                        }
                        case 2: {
                            double l = lua.checkNumber(1);
                            double u = lua.checkNumber(2);
                            lua.checkArg(2, l <= u, "interval is empty");
                            lua.pushNumber(package$.MODULE$.floor(r * (u - l + 1.0)) + l);
                            break;
                        }
                        case 1: {
                            double u = lua.checkNumber(1);
                            lua.checkArg(1, 1.0 <= u, "interval is empty");
                            lua.pushNumber(package$.MODULE$.floor(r * u) + 1.0);
                            break;
                        }
                        case 0: {
                            lua.pushNumber(r);
                        }
                    }
                    return 1;
                }
                {
                    this.random$1 = random$1;
                }
            });
            state.setField(-2, "random");
            ExtendedLuaState$.MODULE$.extendLuaState(state).pushScalaFunction((Function1<LuaState, Object>)new Serializable(random2){
                private final Random random$1;

                public final int apply(LuaState lua) {
                    this.random$1.setSeed((long)lua.checkNumber(1));
                    return 0;
                }
                {
                    this.random$1 = random$1;
                }
            });
            state.setField(-2, "randomseed");
            state.pop(1);
            return new Some((Object)state);
        }
        catch (Throwable throwable) {
            try {
                OpenComputers$.MODULE$.log().warn("Failed creating Lua state.", throwable);
                state.close();
                return None$.MODULE$;
            }
            catch (Throwable throwable2) {
                OpenComputers$.MODULE$.log().warn("Failed creating Lua state.", throwable2);
                return None$.MODULE$;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                OpenComputers$.MODULE$.log().error("Failed loading the native libraries.");
            }
        }
        return None$.MODULE$;
    }

    private LuaStateFactory$() {
        MODULE$ = this;
        this.haveNativeLibrary = false;
        this.li$cil$oc$util$LuaStateFactory$$currentLib = "";
        this.libraryName = Strings.isNullOrEmpty((String)Settings$.MODULE$.get().forceNativeLib()) ? (SystemUtils.IS_OS_FREE_BSD && LuaStateFactory$Architecture$.MODULE$.IS_OS_X64() ? "native.64.bsd.so" : (SystemUtils.IS_OS_FREE_BSD && LuaStateFactory$Architecture$.MODULE$.IS_OS_X86() ? "native.32.bsd.so" : (SystemUtils.IS_OS_LINUX && LuaStateFactory$Architecture$.MODULE$.IS_OS_ARM() ? "native.32.arm.so" : (SystemUtils.IS_OS_LINUX && LuaStateFactory$Architecture$.MODULE$.IS_OS_X64() ? "native.64.so" : (SystemUtils.IS_OS_LINUX && LuaStateFactory$Architecture$.MODULE$.IS_OS_X86() ? "native.32.so" : (SystemUtils.IS_OS_MAC && LuaStateFactory$Architecture$.MODULE$.IS_OS_X64() ? "native.64.dylib" : (SystemUtils.IS_OS_MAC && LuaStateFactory$Architecture$.MODULE$.IS_OS_X86() ? "native.32.dylib" : (SystemUtils.IS_OS_WINDOWS && LuaStateFactory$Architecture$.MODULE$.IS_OS_X64() ? "native.64.dll" : (SystemUtils.IS_OS_WINDOWS && LuaStateFactory$Architecture$.MODULE$.IS_OS_X86() ? "native.32.dll" : null))))))))) : Settings$.MODULE$.get().forceNativeLib();
        this.is64Bit = LuaStateFactory$Architecture$.MODULE$.IS_OS_X64();
        NativeSupport.getInstance().setLoader(new NativeSupport.Loader(){

            public void load() {
                System.load(LuaStateFactory$.MODULE$.li$cil$oc$util$LuaStateFactory$$currentLib());
            }
        });
        this.init();
        if (!this.haveNativeLibrary()) {
            OpenComputers$.MODULE$.log().warn("Unsupported platform, you won't be able to host games with persistent computers.");
        }
    }
}

